/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.impl;

import com.vmware.vim.binding.sca.ServiceInstanceContent;
import com.vmware.vim.binding.sca.configuration.ConfigurationUpdate;
import com.vmware.vim.binding.sca.configuration.Parameter;
import com.vmware.vim.binding.sca.configuration.ServiceConfigurationManager;
import com.vmware.vim.binding.sca.configuration.response.ResponseError;
import com.vmware.vim.binding.sca.configuration.response.UpdateResponse;
import com.vmware.vim.binding.sca.fault.ServiceManagerFault;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.core.model.monitor.TaskState;
import com.vmware.vise.data.common.PathParam;
import com.vmware.vise.data.mutation.MutationMapping;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.usersession.UserSessionService;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.sca.ScaService;
import com.vmware.vise.vim.sca.ScaServiceManager;
import com.vmware.vsphere.client.cm.ServiceOperationSpec;
import com.vmware.vsphere.client.cm.ServiceStartupTypeSpec;
import com.vmware.vsphere.client.cm.impl.ScaServiceControlProvider;
import com.vmware.vsphere.client.cm.impl.VmonServiceControlProvider;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUiFeatureSwitch;
import com.vmware.vsphere.client.cm.util.CmUtil;
import com.vmware.vsphere.client.cm.util.ScmUtil;
import com.vmware.vsphere.client.task.TaskRegistry;
import java.net.URI;
import java.util.Calendar;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServicesMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(ServicesMutationProvider.class);
    private final ScaServiceManager _scaServiceManager;
    private final VmonServiceControlProvider _vmonControlProvider;
    private final ScaServiceControlProvider _scaControlProvider;
    private final CmUiFeatureSwitch _cmUiFeatureSwitch;
    private final TaskRegistry _clientTaskRegistry;
    private final UserSessionService _userSessionService;

    public ServicesMutationProvider(ScaServiceManager scaServiceManager, VmonServiceControlProvider vmonServiceControlProvider, ScaServiceControlProvider scaServiceControlProvider, CmUiFeatureSwitch cmUiFeatureSwitch, TaskRegistry taskRegistry, UserSessionService userSessionService) {
        this._scaServiceManager = scaServiceManager;
        this._vmonControlProvider = vmonServiceControlProvider;
        this._scaControlProvider = scaServiceControlProvider;
        this._cmUiFeatureSwitch = cmUiFeatureSwitch;
        this._clientTaskRegistry = taskRegistry;
        this._userSessionService = userSessionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult apply(URI uRI, ServiceOperationSpec serviceOperationSpec) {
        ClientTaskInfo clientTaskInfo = this.createClientTaskInfo(uRI, serviceOperationSpec);
        try {
            clientTaskInfo = this._clientTaskRegistry.addTask(clientTaskInfo);
            OperationResult operationResult = this._cmUiFeatureSwitch.useVmonForService(uRI) ? this._vmonControlProvider.apply(uRI, serviceOperationSpec) : this._scaControlProvider.apply(uRI, serviceOperationSpec);
            clientTaskInfo.progress = 100;
            if (operationResult.error == null) {
                clientTaskInfo.state = TaskState.SUCCESS;
            } else {
                clientTaskInfo.state = TaskState.ERROR;
                clientTaskInfo.error = operationResult.error;
            }
            OperationResult operationResult2 = operationResult;
            return operationResult2;
        }
        catch (Exception exception) {
            clientTaskInfo.error = exception;
            clientTaskInfo.progress = 100;
            clientTaskInfo.state = TaskState.ERROR;
            OperationResult operationResult = new OperationResult();
            operationResult.entity = uRI;
            operationResult.error = exception;
            OperationResult operationResult3 = operationResult;
            return operationResult3;
        }
        finally {
            if (clientTaskInfo.progress != 100) {
                clientTaskInfo.progress = 100;
            }
            if (clientTaskInfo.state != TaskState.SUCCESS && clientTaskInfo.state != TaskState.ERROR) {
                clientTaskInfo.state = TaskState.SUCCESS;
            }
            clientTaskInfo.completionTime = Calendar.getInstance().getTime();
            this._clientTaskRegistry.updateTask(clientTaskInfo);
        }
    }

    public OperationResult apply(URI uRI, ServiceStartupTypeSpec serviceStartupTypeSpec) {
        if (this._cmUiFeatureSwitch.useVmonForService(uRI)) {
            return this._vmonControlProvider.apply(uRI, serviceStartupTypeSpec);
        }
        return this._scaControlProvider.apply(uRI, serviceStartupTypeSpec);
    }

    @MutationMapping(type="cm:Service", property="settings.{resourceKey*}")
    public OperationResult apply(URI uRI, Map<String, Object> map, @PathParam(value="resourceKey") String string) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = uRI;
        String string2 = CmReferenceUtil.getId(uRI);
        if (uRI == null || map == null || string2 == null || string == null) {
            _logger.error((Object)"ServicesMutationProvider: Invalid entity or arguments.");
            operationResult.error = CmUtil.getFault("error.invalidArgument", new String[0]);
            return operationResult;
        }
        Parameter[] parameterArray = ScmUtil.convertToParameterArray(map);
        if (parameterArray == null) {
            _logger.error((Object)"ServicesMutationProvider: Null parameters.");
            operationResult.error = CmUtil.getFault("error.invalidArgument", new String[0]);
            return operationResult;
        }
        String string3 = CmReferenceUtil.getServerId(uRI);
        ScaService scaService = this._scaServiceManager.getService((Object)string3);
        ServiceInstanceContent serviceInstanceContent = scaService.getServiceContent();
        ServiceConfigurationManager serviceConfigurationManager = (ServiceConfigurationManager)scaService.getManagedObject(serviceInstanceContent.configManager);
        ConfigurationUpdate configurationUpdate = new ConfigurationUpdate();
        configurationUpdate.setResourceKey(string);
        configurationUpdate.setUpdate(parameterArray);
        try {
            UpdateResponse updateResponse = serviceConfigurationManager.update(string2, configurationUpdate);
            operationResult.error = ServicesMutationProvider.getErrorFromResponse(updateResponse);
        }
        catch (ServiceManagerFault serviceManagerFault) {
            _logger.error((Object)serviceManagerFault.getMessage());
            operationResult.error = MixedUtil.getMethodFault((Throwable)serviceManagerFault);
        }
        return operationResult;
    }

    private static MethodFault getErrorFromResponse(UpdateResponse updateResponse) {
        if (updateResponse.success) {
            return null;
        }
        ResponseError[] responseErrorArray = updateResponse.errors;
        StringBuilder stringBuilder = new StringBuilder(CmUtil.getLocalizedString("serviceConfiguration.errors", new String[0]));
        if (responseErrorArray != null) {
            for (ResponseError responseError : responseErrorArray) {
                stringBuilder.append("\n");
                stringBuilder.append(responseError.getName());
                stringBuilder.append(": ");
                stringBuilder.append(CmUtil.getLocalizedMessage(responseError.getError()));
            }
        }
        return new MethodFault(stringBuilder.toString());
    }

    private ClientTaskInfo createClientTaskInfo(URI uRI, ServiceOperationSpec serviceOperationSpec) {
        ClientTaskInfo clientTaskInfo = new ClientTaskInfo();
        clientTaskInfo.cancelable = false;
        clientTaskInfo.pausable = false;
        clientTaskInfo.startTime = Calendar.getInstance().getTime();
        clientTaskInfo.entity = uRI;
        clientTaskInfo.progress = 0;
        clientTaskInfo.state = TaskState.RUNNING;
        clientTaskInfo.entityName = serviceOperationSpec.serviceName;
        clientTaskInfo.entityType = "cm:Service";
        clientTaskInfo.initiator = this._userSessionService.getUserSession().userName;
        clientTaskInfo.description = CmUtil.getLocalizedString("serviceAction." + serviceOperationSpec.operation.name().toLowerCase(), new String[0]);
        clientTaskInfo.taskRef = this.generateTaskReference();
        return clientTaskInfo;
    }

    private ManagedObjectReference generateTaskReference() {
        return new ManagedObjectReference("cm:ServiceTask", UUID.randomUUID().toString(), "");
    }
}

