/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cm.util;

import com.vmware.appliance.vmon.ServiceTypes;
import com.vmware.cis.common.sso.SsoOverRestHelper;
import com.vmware.cis.services.common.sso.SsoOverRestHelper;
import com.vmware.cis.services.common.sso.SsoOverRestRequest;
import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.vim.binding.sca.control.ServiceControlManager;
import com.vmware.vim.binding.sca.control.ServiceState;
import com.vmware.vim.binding.sca.fault.ServiceManagerFault;
import com.vmware.vim.binding.sso.admin.ActiveDirectoryJoinInfo;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.http.Request;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.http.HttpClient;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.vim.cloudvm.CloudVmService;
import com.vmware.vise.vim.cloudvm.CloudVmServiceException;
import com.vmware.vise.vim.cloudvm.IPv4Config;
import com.vmware.vise.vim.cloudvm.IPv6Address;
import com.vmware.vise.vim.cloudvm.IPv6Config;
import com.vmware.vise.vim.cloudvm.NetworkInterfaceInfo;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vise.vim.sca.ScaService;
import com.vmware.vise.vim.sca.ScaServiceManager;
import com.vmware.vise.vim.security.certificates.X509Spec;
import com.vmware.vise.vim.security.sso.SsoAdminService;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.vapi.VapiConnectionManagerRegistry;
import com.vmware.vise.vim.vmca.VmcaService;
import com.vmware.vsphere.client.cm.ActiveDirectoryInfo;
import com.vmware.vsphere.client.cm.HealthState;
import com.vmware.vsphere.client.cm.LogManifestInfo;
import com.vmware.vsphere.client.cm.ServerDeploymentType;
import com.vmware.vsphere.client.cm.ServiceStatus;
import com.vmware.vsphere.client.cm.VmInfo;
import com.vmware.vsphere.client.cm.util.ApplmgmtServiceRegistry;
import com.vmware.vsphere.client.cm.util.CachingPropertyValueExtractor;
import com.vmware.vsphere.client.cm.util.CmReferenceUtil;
import com.vmware.vsphere.client.cm.util.CmUiFeatureSwitch;
import com.vmware.vsphere.client.cm.util.CmUtil;
import com.vmware.vsphere.client.cm.util.InternalServerInfo;
import com.vmware.vsphere.client.cm.util.InternalServiceInfo;
import com.vmware.vsphere.client.cm.util.PropertyCache;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.utils.URIBuilder;

public class ServerPropertyValueExtractor
extends CachingPropertyValueExtractor<InternalServerInfo> {
    private static final String VM_TYPE = VirtualMachine.class.getSimpleName();
    private static final String SCA_SUPPORT_BUNDLE_PATH = "/supportbundle";
    private static final Log _logger = LogFactory.getLog(ServerPropertyValueExtractor.class);
    private static final ApplmgmtControlState UNKOWN_APPLMGMT_CONTROL_STATE = new ApplmgmtControlState(ServiceStatus.UNKNOWN, HealthState.UNKNOWN, new String[0]);
    private final DataService _dataService;
    private final ApplmgmtServiceRegistry _applmgmtServiceRegistry;
    private final SsoService _ssoService;
    private final KeystoreService _ksService;
    private final SSLConfigurationProvider _sslConfigurationProvider;
    private final VmcaService _vmcaService;
    private final Set<String> _propertiesNotNeedingRemoteCall;
    private SsoServiceManager _ssoServiceManager;
    private ScaServiceManager _scaServiceManager;
    private final VapiConnectionManagerRegistry<String> _vmonConnectionRegistry;
    private final PropertyCache<String> _unreachableServerCache;
    private final CmUiFeatureSwitch _featureSwitch;

    public ServerPropertyValueExtractor(DataService dataService, SsoService ssoService, ApplmgmtServiceRegistry applmgmtServiceRegistry, KeystoreService keystoreService, SSLConfigurationProvider sSLConfigurationProvider, VmcaService vmcaService, VapiConnectionManagerRegistry<String> vapiConnectionManagerRegistry, PropertyCache<InternalServerInfo> propertyCache, Set<String> set, PropertyCache<String> propertyCache2, Executor executor, CmUiFeatureSwitch cmUiFeatureSwitch) {
        super(propertyCache, set, executor);
        this._dataService = dataService;
        this._ssoService = ssoService;
        this._applmgmtServiceRegistry = applmgmtServiceRegistry;
        this._ksService = keystoreService;
        this._sslConfigurationProvider = sSLConfigurationProvider;
        this._vmcaService = vmcaService;
        this._vmonConnectionRegistry = vapiConnectionManagerRegistry;
        this._featureSwitch = cmUiFeatureSwitch;
        this._unreachableServerCache = propertyCache2;
        this._propertiesNotNeedingRemoteCall = new HashSet<String>();
        this._propertiesNotNeedingRemoteCall.add("name");
        this._propertiesNotNeedingRemoteCall.add("services");
        this._propertiesNotNeedingRemoteCall.add("isDomainController");
        this._propertiesNotNeedingRemoteCall.add("systemHealth");
        this._propertiesNotNeedingRemoteCall.add("supportBundleUrl");
        this._propertiesNotNeedingRemoteCall.add("healthMessages");
        this._propertiesNotNeedingRemoteCall.add("isUnreachable");
    }

    public void setSsoServiceManager(SsoServiceManager ssoServiceManager) {
        this._ssoServiceManager = ssoServiceManager;
    }

    public void setScaServiceManager(ScaServiceManager scaServiceManager) {
        this._scaServiceManager = scaServiceManager;
    }

    public Object[][] getValues(InternalServerInfo[] internalServerInfoArray, String[] stringArray) {
        Object[][] objectArray = new Object[stringArray.length][internalServerInfoArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = this.getValuesPerProperty(internalServerInfoArray, stringArray[i]);
        }
        return objectArray;
    }

    @Override
    protected String getServerId(InternalServerInfo internalServerInfo) {
        return internalServerInfo.getHostname();
    }

    @Override
    protected boolean propertyNeedsRemoteCall(String string) {
        return !this._propertiesNotNeedingRemoteCall.contains(string);
    }

    protected Object[] getValuesPerPropertyDirectly(InternalServerInfo[] internalServerInfoArray, String string, boolean bl) {
        Object[] objectArray = new Object[internalServerInfoArray.length];
        for (int i = 0; i < internalServerInfoArray.length; ++i) {
            try {
                URI uRI;
                if ("name".equals(string)) {
                    objectArray[i] = internalServerInfoArray[i].getHostname();
                    continue;
                }
                if ("serverIconId".equals(string)) {
                    objectArray[i] = this.getPrimaryIconId(internalServerInfoArray[i]);
                    continue;
                }
                if ("hostname".equals(string)) {
                    objectArray[i] = this.getHostname(internalServerInfoArray[i]);
                    continue;
                }
                if ("serviceInfos".equals(string)) {
                    objectArray[i] = this.getRelatedServiceInfos(internalServerInfoArray[i]);
                    continue;
                }
                if ("services".equals(string)) {
                    objectArray[i] = this.getRelatedServices(internalServerInfoArray[i]);
                    continue;
                }
                if ("isApplianceManaged".equals(string)) {
                    objectArray[i] = this.isApplmgmtServiceAvailable(internalServerInfoArray[i]);
                    continue;
                }
                if ("isDomainController".equals(string)) {
                    objectArray[i] = this.isDomainController(internalServerInfoArray[i]);
                    continue;
                }
                if ("applmgmtExistsAndDown".equals(string)) {
                    objectArray[i] = this.hasApplmgmtAndInRunningState(internalServerInfoArray[i], false);
                    continue;
                }
                if ("applmgmtExistsAndUp".equals(string)) {
                    objectArray[i] = this.hasApplmgmtAndInRunningState(internalServerInfoArray[i], true);
                    continue;
                }
                if ("isUnreachable".equals(string)) {
                    objectArray[i] = this.isUnreachable(internalServerInfoArray[i]);
                    continue;
                }
                if ("systemHealth".equals(string)) {
                    objectArray[i] = this.getHealth(internalServerInfoArray[i]);
                    continue;
                }
                if ("applmgmtControlState".equals(string)) {
                    objectArray[i] = this.getApplmgmtControlState(internalServerInfoArray[i]);
                    continue;
                }
                if ("manifestArray".equals(string)) {
                    objectArray[i] = this.getManifestArrays(internalServerInfoArray[i]);
                    continue;
                }
                if ("supportBundleUrl".equals(string)) {
                    uRI = this.getSupportBundleUrl(internalServerInfoArray[i]);
                    objectArray[i] = uRI != null ? uRI.toString() : null;
                    continue;
                }
                if ("deploymentType".equals(string)) {
                    objectArray[i] = this.getDeploymentType(internalServerInfoArray[i]);
                    continue;
                }
                if ("activeDirectoryInfo".equals(string)) {
                    objectArray[i] = this.getActiveDirectoryInfo(internalServerInfoArray[i]);
                    continue;
                }
                if ("activeDirectoryJoined".equals(string)) {
                    objectArray[i] = this.getActiveDirectoryJoined(internalServerInfoArray[i]);
                    continue;
                }
                if ("uptime".equals(string)) {
                    objectArray[i] = this.getUptime(internalServerInfoArray[i]);
                    continue;
                }
                if ("vmca:activeCertificates".equals(string)) {
                    objectArray[i] = this.getActiveCertificates(internalServerInfoArray[i].getHostname());
                    continue;
                }
                if ("vmca:revokedCertificates".equals(string)) {
                    objectArray[i] = this.getRevokedCertificates(internalServerInfoArray[i].getHostname());
                    continue;
                }
                if ("vmca:expiredCertificates".equals(string)) {
                    objectArray[i] = this.getExpiredCertificates(internalServerInfoArray[i].getHostname());
                    continue;
                }
                if ("vmca:rootCertificates".equals(string)) {
                    objectArray[i] = this.getRootCertificates(internalServerInfoArray[i].getHostname());
                    continue;
                }
                if ("isvmcainitialized".equals(string)) {
                    objectArray[i] = this.isVMCAClientAvailable(internalServerInfoArray[i].getHostname());
                    continue;
                }
                uRI = this.getCloudVmService(internalServerInfoArray[i]);
                if (uRI == null || this.hasApplmgmtAndInRunningState(internalServerInfoArray[i], false)) continue;
                if ("consoleCliEnabled".equals(string)) {
                    objectArray[i] = uRI.isConsoleCliEnabled();
                    continue;
                }
                if ("dcuiEnabled".equals(string)) {
                    objectArray[i] = uRI.isDcuiEnabled();
                    continue;
                }
                if ("shellConfig".equals(string)) {
                    objectArray[i] = uRI.getShellConfig();
                    continue;
                }
                if ("sshEnabled".equals(string)) {
                    objectArray[i] = uRI.isSshEnabled();
                    continue;
                }
                if ("domains".equals(string)) {
                    objectArray[i] = uRI.listDnsDomains();
                    continue;
                }
                if ("dnsConfig".equals(string)) {
                    objectArray[i] = uRI.getDnsServersConfig();
                    continue;
                }
                if ("nics".equals(string)) {
                    objectArray[i] = uRI.listNics();
                    continue;
                }
                if ("ipv4Config".equals(string)) {
                    objectArray[i] = uRI.listIPv4Config();
                    continue;
                }
                if ("ipv6Config".equals(string)) {
                    objectArray[i] = uRI.listIPv6Config();
                    continue;
                }
                if ("firewallRules".equals(string)) {
                    objectArray[i] = uRI.listFirewallRules();
                    continue;
                }
                if ("routes".equals(string)) {
                    objectArray[i] = uRI.listRoutes();
                    continue;
                }
                if ("storageHealth".equals(string)) {
                    objectArray[i] = uRI.getStorageHealth();
                    continue;
                }
                if ("memHealth".equals(string)) {
                    objectArray[i] = uRI.getMemHealth();
                    continue;
                }
                if ("loadHealth".equals(string)) {
                    objectArray[i] = uRI.getLoadHealth();
                    continue;
                }
                if ("swapHealth".equals(string)) {
                    objectArray[i] = uRI.getSwapHealth();
                    continue;
                }
                if ("cpuStats".equals(string)) {
                    objectArray[i] = uRI.getCpuStats();
                    continue;
                }
                if ("memStats".equals(string)) {
                    objectArray[i] = uRI.getMemStats();
                    continue;
                }
                if ("netStats".equals(string)) {
                    objectArray[i] = uRI.listNetStats();
                    continue;
                }
                if ("storageStats".equals(string)) {
                    objectArray[i] = uRI.listStorageStats();
                    continue;
                }
                if ("vmInfo".equals(string)) {
                    objectArray[i] = this.getVmInfo((CloudVmService)uRI);
                    continue;
                }
                if ("healthMessages".equals(string)) {
                    objectArray[i] = this.getHealthMessages(internalServerInfoArray[i]);
                    continue;
                }
                if (CmUtil.UNHANDLED_PROPERTIES_TO_IGNORE.contains(string)) break;
                _logger.warn((Object)("Unknown server property: " + string));
                break;
            }
            catch (CloudVmServiceException cloudVmServiceException) {
                _logger.error((Object)cloudVmServiceException.getMessage(), (Throwable)cloudVmServiceException);
                continue;
            }
            catch (IOException iOException) {
                _logger.error((Object)iOException.getMessage(), (Throwable)iOException);
                continue;
            }
            catch (Exception exception) {
                _logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        return objectArray;
    }

    @Override
    protected void sanitizeValues(String string, Object[] objectArray) {
        block8: {
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block7: {
                                assert (objectArray != null);
                                if (!"uptime".equals(string)) break block7;
                                for (int i = 0; i < objectArray.length; ++i) {
                                    if (objectArray[i] != null) continue;
                                    objectArray[i] = -1.0;
                                }
                                break block8;
                            }
                            if (!"systemHealth".equals(string)) break block9;
                            for (int i = 0; i < objectArray.length; ++i) {
                                if (objectArray[i] != null) continue;
                                objectArray[i] = HealthState.UNKNOWN;
                            }
                            break block8;
                        }
                        if (!"deploymentType".equals(string)) break block10;
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (objectArray[i] != null) continue;
                            objectArray[i] = ServerDeploymentType.UNKNOWN;
                        }
                        break block8;
                    }
                    if (!"isApplianceManaged".equals(string)) break block11;
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (objectArray[i] != null) continue;
                        objectArray[i] = Boolean.FALSE;
                    }
                    break block8;
                }
                if (!"applmgmtExistsAndDown".equals(string)) break block12;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] != null) continue;
                    objectArray[i] = Boolean.FALSE;
                }
                break block8;
            }
            if (!"applmgmtControlState".equals(string)) break block8;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != null) continue;
                objectArray[i] = UNKOWN_APPLMGMT_CONTROL_STATE;
            }
        }
    }

    private String getHostname(InternalServerInfo internalServerInfo) throws CloudVmServiceException {
        assert (internalServerInfo != null);
        CloudVmService cloudVmService = this.getCloudVmService(internalServerInfo);
        if (cloudVmService != null && !this.isUnreachable(internalServerInfo)) {
            return cloudVmService.getHostname();
        }
        return internalServerInfo.getHostname();
    }

    private X509Spec[][] getRootCertificates(String string) {
        X509Spec[][] x509SpecArray = this._vmcaService.getRootCertificate(string);
        return x509SpecArray;
    }

    private X509Spec[] getActiveCertificates(String string) {
        X509Spec[] x509SpecArray = this._vmcaService.getActiveCertificates(string);
        return x509SpecArray;
    }

    private X509Spec[] getRevokedCertificates(String string) {
        X509Spec[] x509SpecArray = this._vmcaService.getRevokedCertificates(string);
        return x509SpecArray;
    }

    private X509Spec[] getExpiredCertificates(String string) {
        X509Spec[] x509SpecArray = this._vmcaService.getExpiredCertificates(string);
        return x509SpecArray;
    }

    private String getPrimaryIconId(InternalServerInfo internalServerInfo) {
        ServerDeploymentType serverDeploymentType = (ServerDeploymentType)((Object)this.getValuesPerProperty(new InternalServerInfo[]{internalServerInfo}, "deploymentType")[0]);
        return "CmUiImages:" + serverDeploymentType.iconId;
    }

    private Object getVmInfo(CloudVmService cloudVmService) throws CloudVmServiceException {
        Object object;
        QuerySpec querySpec;
        ArrayList<PropertyConstraint> arrayList = new ArrayList<PropertyConstraint>();
        String[] stringArray = this.getNicNames(cloudVmService);
        IPv4Config[] iPv4ConfigArray = cloudVmService.getIPv4Config(stringArray);
        for (int i = 0; i < iPv4ConfigArray.length; ++i) {
            if (StringUtil.isNullOrEmpty((String)iPv4ConfigArray[i].address)) continue;
            PropertyConstraint propertyConstraint = this.getPropConstraintForVmPerIp(iPv4ConfigArray[i].address);
            arrayList.add(propertyConstraint);
        }
        IPv6Config[] iPv6ConfigArray = cloudVmService.getIPv6Config(stringArray);
        for (int i = 0; i < iPv6ConfigArray.length; ++i) {
            if (iPv6ConfigArray[i].addresses == null) continue;
            querySpec = iPv6ConfigArray[i].addresses;
            for (int j = 0; j < ((IPv6Address[])querySpec).length; ++j) {
                if (StringUtil.isNullOrEmpty((String)querySpec[i].address)) continue;
                object = this.getPropConstraintForVmPerIp(querySpec[j].address);
                arrayList.add((PropertyConstraint)object);
            }
        }
        if (arrayList.size() < 1) {
            _logger.info((Object)"Server IP addresses were not found.");
            return null;
        }
        CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])((Constraint[])arrayList.toArray(new PropertyConstraint[arrayList.size()])), (Conjoiner)Conjoiner.OR);
        compositeConstraint.targetType = VM_TYPE;
        querySpec = QueryUtil.buildQuerySpec((Constraint)compositeConstraint, (String[])new String[]{"name"});
        ResultSet resultSet = null;
        try {
            resultSet = QueryUtil.getData((DataService)this._dataService, (QuerySpec)querySpec);
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        if (resultSet != null && resultSet.error != null) {
            _logger.error((Object)resultSet.error.getMessage(), (Throwable)resultSet.error);
        }
        if (resultSet == null || ArrayUtil.isNullOrEmpty((Object[])resultSet.items)) {
            _logger.info((Object)"Server VM was not found.");
            return null;
        }
        object = new VmInfo();
        object.vm = (ManagedObjectReference)resultSet.items[0].resourceObject;
        if (!ArrayUtil.isNullOrEmpty((Object[])resultSet.items[0].properties)) {
            object.name = resultSet.items[0].properties[0].value.toString();
        }
        return object;
    }

    private String[] getNicNames(CloudVmService cloudVmService) throws CloudVmServiceException {
        NetworkInterfaceInfo[] networkInterfaceInfoArray = cloudVmService.listNics();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < networkInterfaceInfoArray.length; ++i) {
            NetworkInterfaceInfo networkInterfaceInfo = networkInterfaceInfoArray[i];
            if (networkInterfaceInfo.status != NetworkInterfaceInfo.NetworkInterfaceStatus.UP) continue;
            arrayList.add(networkInterfaceInfo.name);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private PropertyConstraint getPropConstraintForVmPerIp(String string) {
        return QueryUtil.createPropertyConstraint((String)VM_TYPE, (String)"guest.ipAddress", (Comparator)Comparator.EQUALS, (Object)string);
    }

    private Collection<InternalServiceInfo> getRelatedServiceInfos(InternalServerInfo internalServerInfo) throws ServiceManagerFault {
        assert (internalServerInfo != null);
        if (this.isUnreachable(internalServerInfo)) {
            return new ArrayList<InternalServiceInfo>();
        }
        if (this._featureSwitch.useVmonForHost(internalServerInfo.getHostname())) {
            return CmUtil.getVmonServicesForServer(this._vmonConnectionRegistry, internalServerInfo.getHostname());
        }
        return CmUtil.getScaServicesForServer(this._scaServiceManager, internalServerInfo.getHostname());
    }

    private URI[] getRelatedServices(InternalServerInfo internalServerInfo) throws ServiceManagerFault {
        assert (internalServerInfo != null);
        if (this.isUnreachable(internalServerInfo)) {
            return new URI[0];
        }
        Collection collection = (Collection)this.getValuesPerProperty(new InternalServerInfo[]{internalServerInfo}, "serviceInfos")[0];
        URI[] uRIArray = new URI[collection.size()];
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            InternalServiceInfo internalServiceInfo = (InternalServiceInfo)iterator.next();
            uRIArray[n++] = CmReferenceUtil.getServiceReference(internalServiceInfo);
        }
        return uRIArray;
    }

    private HealthState getHealth(InternalServerInfo internalServerInfo) throws ServiceManagerFault {
        assert (internalServerInfo != null) : "Null server info provided";
        if (!this.isApplmgmtServiceAvailable(internalServerInfo) || this.isUnreachable(internalServerInfo)) {
            return HealthState.UNSUPPORTED;
        }
        ApplmgmtControlState applmgmtControlState = (ApplmgmtControlState)this.getValuesPerProperty(new InternalServerInfo[]{internalServerInfo}, "applmgmtControlState")[0];
        return applmgmtControlState.healthState;
    }

    private String[] getHealthMessages(InternalServerInfo internalServerInfo) throws ServiceManagerFault {
        assert (internalServerInfo != null) : "Null server info provided";
        if (!this.isApplmgmtServiceAvailable(internalServerInfo) || this.isUnreachable(internalServerInfo)) {
            return null;
        }
        ApplmgmtControlState applmgmtControlState = (ApplmgmtControlState)this.getValuesPerProperty(new InternalServerInfo[]{internalServerInfo}, "applmgmtControlState")[0];
        return applmgmtControlState.localizedHealthMessages;
    }

    private ApplmgmtControlState getApplmgmtControlState(InternalServerInfo internalServerInfo) throws ServiceManagerFault {
        ApplmgmtControlState applmgmtControlState;
        if (!this.isApplmgmtServiceAvailable(internalServerInfo) || this.isUnreachable(internalServerInfo)) {
            return null;
        }
        if (this._featureSwitch.useVmonForHost(internalServerInfo.getHostname())) {
            ServiceTypes.Info info = CmUtil.getVmonServiceInfo(this._vmonConnectionRegistry, internalServerInfo.getHostname(), "applmgmt");
            applmgmtControlState = new ApplmgmtControlState(info);
        } else {
            ScaService scaService = this._scaServiceManager.getService((Object)internalServerInfo.getHostname());
            ServiceControlManager serviceControlManager = (ServiceControlManager)scaService.getManagedObject(scaService.getServiceContent().controlManager);
            ServiceState[] serviceStateArray = serviceControlManager.getServiceStates(new String[]{"applmgmt"}, 10L);
            applmgmtControlState = new ApplmgmtControlState(serviceStateArray[0]);
        }
        return applmgmtControlState;
    }

    private boolean hasApplmgmtAndInRunningState(InternalServerInfo internalServerInfo, boolean bl) {
        if (this.isUnreachable(internalServerInfo)) {
            return !bl;
        }
        InternalServerInfo[] internalServerInfoArray = new InternalServerInfo[]{internalServerInfo};
        boolean bl2 = (Boolean)this.getValuesPerProperty(internalServerInfoArray, "isApplianceManaged")[0];
        if (!bl2) {
            return false;
        }
        ApplmgmtControlState applmgmtControlState = (ApplmgmtControlState)this.getValuesPerProperty(internalServerInfoArray, "applmgmtControlState")[0];
        return applmgmtControlState.runningState.isRunningState() == bl;
    }

    private boolean isUnreachable(InternalServerInfo internalServerInfo) {
        assert (internalServerInfo != null);
        boolean bl = false;
        if (this._unreachableServerCache.getProperty(internalServerInfo.getHostname(), "__singleton") != null) {
            bl = true;
        }
        return bl;
    }

    private ServerDeploymentType getDeploymentType(InternalServerInfo internalServerInfo) throws ServiceManagerFault {
        ServerDeploymentType serverDeploymentType = ServerDeploymentType.UNKNOWN;
        if (this.isUnreachable(internalServerInfo)) {
            return serverDeploymentType;
        }
        if (!internalServerInfo.isDomainController()) {
            serverDeploymentType = ServerDeploymentType.MANAGEMENT;
        } else {
            Object object;
            if (this._featureSwitch.useVmonForHost(internalServerInfo.getHostname())) {
                object = CmUtil.getVmonServiceInfo(this._vmonConnectionRegistry, internalServerInfo.getHostname(), "vpxd");
            } else {
                object = CmUtil.getScaServiceByName(this._scaServiceManager, internalServerInfo.getHostname(), "vmware-vpxd");
                if (object == null) {
                    object = CmUtil.getScaServiceByName(this._scaServiceManager, internalServerInfo.getHostname(), "vpxd");
                }
            }
            serverDeploymentType = object != null ? ServerDeploymentType.EMBEDDED : ServerDeploymentType.INFRASTRUCTURE;
        }
        return serverDeploymentType;
    }

    private ActiveDirectoryInfo getActiveDirectoryInfo(InternalServerInfo internalServerInfo) {
        if (this.isUnreachable(internalServerInfo)) {
            return null;
        }
        URI uRI = CmReferenceUtil.getServerReference(internalServerInfo);
        SsoAdminService ssoAdminService = this._ssoServiceManager.getAdminService((Object)uRI, SsoDomain.getLocal());
        try {
            ActiveDirectoryJoinInfo activeDirectoryJoinInfo = ssoAdminService.getSystemManagementService().getActiveDirectoryJoinStatus();
            ActiveDirectoryInfo activeDirectoryInfo = null;
            if (ActiveDirectoryJoinInfo.JoinStatus.ACTIVE_DIRECTORY_JOIN_STATUS_DOMAIN.name().equals(activeDirectoryJoinInfo.joinStatus)) {
                activeDirectoryInfo = new ActiveDirectoryInfo();
                activeDirectoryInfo.domain = activeDirectoryJoinInfo.name;
            }
            return activeDirectoryInfo;
        }
        catch (Exception exception) {
            _logger.error((Object)("Cannot get Active Directory join info for " + uRI.toString()), (Throwable)exception);
            return null;
        }
    }

    private boolean getActiveDirectoryJoined(InternalServerInfo internalServerInfo) {
        return this.getActiveDirectoryInfo(internalServerInfo) != null;
    }

    private LogManifestInfo getManifestArrays(InternalServerInfo internalServerInfo) throws IOException, SsoOverRestHelper.SsoOverRestHelperException {
        LogManifestInfo logManifestInfo = new LogManifestInfo();
        URI uRI = this.getManifestUrl(internalServerInfo);
        if (uRI == null) {
            return null;
        }
        SsoOverRestRequest ssoOverRestRequest = new SsoOverRestRequest(Request.Method.GET, uRI.toURL(), null);
        PrivateKey privateKey = this._ssoService.getHokPrivateKey();
        Map map = SsoOverRestHelper.calcAuthHeader((com.vmware.cis.common.sso.SsoOverRestRequest)ssoOverRestRequest, (PrivateKey)privateKey, (SamlToken)AuthSessionUtil.getSsoToken(), (int)1024);
        HttpClient httpClient = new SSLBuilder().sslConfigurationProvider(this._sslConfigurationProvider).addTrustStore(this._ksService.getKeyStore()).buildHttpClientIgnoreErrors();
        String string = httpClient.executeMethod(uRI.toString(), null, map);
        if (string == null) {
            _logger.error((Object)("Null manifest list retrieved from server" + internalServerInfo.getHostname()));
            return null;
        }
        String[] stringArray = string.split("(\n\n|\r\n\r\n)", 2);
        if (stringArray.length != 2) {
            _logger.error((Object)("Invalid manifest list retrieved from server" + internalServerInfo.getHostname()));
            return null;
        }
        logManifestInfo.manifest = stringArray[1];
        return logManifestInfo;
    }

    private URI getSupportBundleUrl(InternalServerInfo internalServerInfo) {
        String string = internalServerInfo.getHostname();
        ScaService scaService = this._scaServiceManager.getService((Object)string);
        if (scaService == null) {
            _logger.error((Object)("Error getting SCA service for " + string));
            return null;
        }
        URI uRI = scaService.getVmomiClient().getBinding().getEndpointUri();
        URIBuilder uRIBuilder = new URIBuilder(uRI);
        uRIBuilder.setPath(SCA_SUPPORT_BUNDLE_PATH);
        try {
            return uRIBuilder.build();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private URI getManifestUrl(InternalServerInfo internalServerInfo) {
        URI uRI = this.getSupportBundleUrl(internalServerInfo);
        URI uRI2 = null;
        if (uRI != null) {
            try {
                uRI2 = new URIBuilder(uRI).setParameter("params", "--listmanifests%20--xmloutput").build();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return uRI2;
    }

    private double getUptime(InternalServerInfo internalServerInfo) {
        assert (internalServerInfo != null);
        double d = -1.0;
        if (this.isUnreachable(internalServerInfo)) {
            return d;
        }
        try {
            CloudVmService cloudVmService = this.getCloudVmService(internalServerInfo);
            if (cloudVmService == null) {
                return d;
            }
            d = cloudVmService.getSystemStats().uptime;
        }
        catch (CloudVmServiceException cloudVmServiceException) {
            _logger.error((Object)("Cloudvm exception thrown while getting server uptime: " + cloudVmServiceException.getMessage()));
        }
        return d;
    }

    private boolean isApplmgmtServiceAvailable(InternalServerInfo internalServerInfo) {
        CloudVmService cloudVmService = this._applmgmtServiceRegistry.getCloudVmService(internalServerInfo.getHostname());
        return cloudVmService != null;
    }

    private CloudVmService getCloudVmService(InternalServerInfo internalServerInfo) {
        return this._applmgmtServiceRegistry.getCloudVmService(internalServerInfo.getHostname());
    }

    private boolean isDomainController(InternalServerInfo internalServerInfo) {
        return internalServerInfo.isDomainController();
    }

    private synchronized boolean isVMCAClientAvailable(String string) {
        boolean bl = false;
        ConcurrentHashMap concurrentHashMap = this._vmcaService.getVmcaClientMap();
        bl = concurrentHashMap == null ? false : concurrentHashMap.containsKey(string);
        return bl;
    }

    private static class ApplmgmtControlState {
        ServiceStatus runningState;
        HealthState healthState;
        String[] localizedHealthMessages;

        ApplmgmtControlState(ServiceTypes.Info info) {
            this.runningState = CmUtil.vmonCodeToServiceStatus(info.getState());
            this.healthState = CmUtil.healthStateFromVmonHealthStatus(info.getHealth());
            this.localizedHealthMessages = CmUtil.extractHealthMessages(info);
        }

        ApplmgmtControlState(ServiceState serviceState) {
            this.runningState = CmUtil.scaCodeToServiceStatus(serviceState.controlStatus);
            this.healthState = CmUtil.healthStateFromScaHealthStatus(serviceState.healthStatus);
            this.localizedHealthMessages = CmUtil.extractHealthMessages(serviceState);
        }

        ApplmgmtControlState(ServiceStatus serviceStatus, HealthState healthState, String[] stringArray) {
            this.runningState = serviceStatus;
            this.healthState = healthState;
            this.localizedHealthMessages = stringArray;
        }
    }
}

