/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.CustomizationSpecInfo;
import com.vmware.vim.binding.vim.CustomizationSpecItem;
import com.vmware.vim.binding.vim.CustomizationSpecManager;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.EnvironmentBrowser;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroupInfo;
import com.vmware.vim.binding.vim.dvs.PortCriteria;
import com.vmware.vim.binding.vim.fault.InvalidName;
import com.vmware.vim.binding.vim.host.Capability;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.CpuIdInfo;
import com.vmware.vim.binding.vim.host.ScsiLun;
import com.vmware.vim.binding.vim.host.StorageDeviceInfo;
import com.vmware.vim.binding.vim.host.StorageSystem;
import com.vmware.vim.binding.vim.option.OptionManager;
import com.vmware.vim.binding.vim.vApp.OvfSectionInfo;
import com.vmware.vim.binding.vim.vApp.VmConfigInfo;
import com.vmware.vim.binding.vim.vm.AffinityInfo;
import com.vmware.vim.binding.vim.vm.ConfigInfo;
import com.vmware.vim.binding.vim.vm.ConfigOption;
import com.vmware.vim.binding.vim.vm.ConfigOptionDescriptor;
import com.vmware.vim.binding.vim.vm.ConfigTarget;
import com.vmware.vim.binding.vim.vm.DatastoreInfo;
import com.vmware.vim.binding.vim.vm.GuestOsDescriptor;
import com.vmware.vim.binding.vim.vm.NetworkInfo;
import com.vmware.vim.binding.vim.vm.RuntimeInfo;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualEthernetCard;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.ManagedObjectNotFound;
import com.vmware.vim.vmomi.client.common.impl.ClientFutureImpl;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.common.util.OvfUtil;
import com.vmware.vsphere.client.ippool.util.IpPoolUtil;
import com.vmware.vsphere.client.ippool.vapp.VAppIpPoolData;
import com.vmware.vsphere.client.storagedrs.rules.SdrsRuleInfo;
import com.vmware.vsphere.client.util.envbrowser.EnvironmentBrowserUtil;
import com.vmware.vsphere.client.vm.config.VmConfigContext;
import com.vmware.vsphere.client.vm.config.VmConfigEnvParams;
import com.vmware.vsphere.client.vm.config.VmConfigEnvironment;
import com.vmware.vsphere.client.vm.provisioning.GuestOsDescriptorFilter;
import com.vmware.vsphere.client.vm.provisioning.VirtualDeviceOptionFilter;
import com.vmware.vsphere.client.vm.provisioning.VmOptionDescriptorFilter;
import com.vmware.vsphere.client.vm.storageDrs.VmStorageInfo;
import com.vmware.vsphere.client.vm.storageDrs.rules.SdrsRulesManager;
import com.vmware.vsphere.client.vm.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmProvisioningProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(VmProvisioningProvider.class);
    private static final String CONFIG_PROPERTY = "config";
    private static final String RUNTIME_PROPERTY = "runtime";
    private static final String ENV_BROWSER_PROPERTY = "environmentBrowser";
    private static final String DEFAULT_HW_VERSION_KEY_PROPERTY = "configurationEx.defaultHardwareVersionKey";
    private static final String NETWORK_PROPERTY = "allNetwork";
    private static final String HOST_PROPERTY = "host";
    private static final String HOST_CR_RELATIONSHIP = "parent";
    private static final String HOST_CPU_MHZ_PROPERTY = "summary.hardware.cpuMhz";
    private static final String HOST_VC_IP_PROPERTY = "summary.managementServerIp";
    private static final String PARENT_VAPP_PROPERTY = "parentVApp";
    private static final String RP_PROPERTY = "resourcePool";
    private static final String RP_OWNER_PROPERTY = "owner";
    private static final String NAME_IP_GENERATOR = "config.guestcust.name-ip-generator";
    private final DataService _dataService;
    private final QueryExecutor _queryExecutor;

    public VmProvisioningProvider(DataService dataService, QueryExecutor queryExecutor) {
        this._dataService = dataService;
        this._queryExecutor = queryExecutor;
    }

    private static QuerySpec createVmConfigContextQuerySpec(ManagedObjectReference vmRef) {
        ResourceSpec rSpec = new ResourceSpec();
        rSpec.constraint = QueryUtil.createObjectIdentityConstraint((Object)vmRef);
        PropertySpec vmPropSpec = new PropertySpec();
        vmPropSpec.type = VirtualMachine.class.getSimpleName();
        vmPropSpec.propertyNames = new String[]{RUNTIME_PROPERTY, PARENT_VAPP_PROPERTY, "grantedPrivileges"};
        PropertySpec hostPropSpec = new PropertySpec();
        hostPropSpec.type = HostSystem.class.getSimpleName();
        hostPropSpec.relation = HOST_PROPERTY;
        hostPropSpec.propertyNames = new String[]{HOST_CPU_MHZ_PROPERTY};
        PropertySpec rpPropSpec = new PropertySpec();
        rpPropSpec.type = ResourcePool.class.getSimpleName();
        rpPropSpec.relation = RP_PROPERTY;
        rpPropSpec.propertyNames = new String[]{RP_OWNER_PROPERTY};
        rSpec.propertySpecs = new PropertySpec[]{vmPropSpec, hostPropSpec, rpPropSpec};
        QuerySpec qSpec = new QuerySpec();
        qSpec.resourceSpec = rSpec;
        return qSpec;
    }

    private static Map<String, Map<String, Object>> createVmConfigContextResultMap(ResultSet vmConfigContextResult) {
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>();
        if (vmConfigContextResult == null || vmConfigContextResult.items == null) {
            _logger.error((Object)"Empty result set for getVmConfigContext Data Service call");
            return resultMap;
        }
        if (vmConfigContextResult.error != null) {
            _logger.warn((Object)"Error while retrieving some getVmConfigContext properties", (Throwable)vmConfigContextResult.error);
        }
        ResultItem vmResultItem = vmConfigContextResult.items[0];
        for (PropertyValue propValue : vmResultItem.properties) {
            if (!(propValue.resourceObject instanceof ManagedObjectReference)) {
                _logger.warn((Object)"Unexpected data retrieved in getVmConfigContext data request");
                continue;
            }
            ManagedObjectReference resource = (ManagedObjectReference)propValue.resourceObject;
            String resourceType = resource.getType();
            HashMap<String, Object> resourceValues = (HashMap<String, Object>)resultMap.get(resourceType);
            if (resourceValues == null) {
                resourceValues = new HashMap<String, Object>();
                resultMap.put(resourceType, resourceValues);
            }
            resourceValues.put(propValue.propertyName, propValue.value);
        }
        return resultMap;
    }

    @type(value="VirtualMachine")
    public ConfigTarget getVmConfigTarget(ManagedObjectReference vmRef) throws Exception {
        _logger.debug((Object)"getVmConfigTarget");
        if (vmRef == null) {
            return null;
        }
        VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
        EnvironmentBrowser browser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vm.getEnvironmentBrowser());
        ConfigTarget retVal = browser.queryConfigTarget(null);
        _logger.debug((Object)"exiting getVmConfigTarget");
        return retVal;
    }

    @type(value="VirtualMachine")
    public VmConfigContext getVmConfigContext(ManagedObjectReference vmRef, String gos) throws Exception {
        EnvironmentBrowser browser;
        ClientFutureImpl configInfoFuture;
        long t0;
        block12: {
            _logger.debug((Object)"getVmConfigContext");
            t0 = System.currentTimeMillis();
            VirtualMachine virtualMachine = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
            ClientFutureImpl browserFuture = new ClientFutureImpl();
            virtualMachine.getEnvironmentBrowser((Future)browserFuture);
            configInfoFuture = new ClientFutureImpl();
            virtualMachine.getConfig((Future)configInfoFuture);
            browser = null;
            try {
                browser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)((ManagedObjectReference)browserFuture.get()));
            }
            catch (ExecutionException ex) {
                if (!(ex.getCause() instanceof ManagedObjectNotFound)) break block12;
                throw new Exception(Util.getLocalizedString("error.vm.configInfo.failed.vmNotAccesible"), ex);
            }
        }
        long t1 = System.currentTimeMillis() - t0;
        ConfigInfo config = (ConfigInfo)configInfoFuture.get();
        if (config == null) {
            throw new Exception(Util.getLocalizedString("error.vm.configInfo.failed"));
        }
        long t2 = System.currentTimeMillis() - t0 - t1;
        VmProvisioningProvider.initConfigInfo(config);
        Util.sortOVFProperties(config.vAppConfig);
        VmProvisioningProvider.formatOvfSections(config);
        long t3 = System.currentTimeMillis() - t0 - t1 - t2;
        ClientFutureImpl configOptionFuture = new ClientFutureImpl();
        try {
            EnvironmentBrowser.ConfigOptionQuerySpec query = new EnvironmentBrowser.ConfigOptionQuerySpec();
            query.guestId = gos == null || gos == "" ? new String[]{config.guestId} : new String[]{gos};
            browser.queryConfigOptionEx(query, (Future)configOptionFuture);
        }
        catch (Error err) {
            browser.queryConfigOption(null, null, (Future)configOptionFuture);
        }
        catch (Exception ex) {
            browser.queryConfigOption(null, null, (Future)configOptionFuture);
        }
        ClientFutureImpl configTargetFuture = new ClientFutureImpl();
        browser.queryConfigTarget(null, (Future)configTargetFuture);
        ClientFutureImpl dsBrowserFuture = new ClientFutureImpl();
        browser.getDatastoreBrowser((Future)dsBrowserFuture);
        ClientFutureImpl capabilityFuture = new ClientFutureImpl();
        browser.queryTargetCapabilities(null, (Future)capabilityFuture);
        ClientFutureImpl descriptorsFuture = new ClientFutureImpl();
        browser.queryConfigOptionDescriptor((Future)descriptorsFuture);
        long t4 = System.currentTimeMillis() - t0 - t1 - t2 - t3;
        QuerySpec qSpec = VmProvisioningProvider.createVmConfigContextQuerySpec(vmRef);
        ResultSet result = QueryUtil.getData((DataService)this._dataService, (QuerySpec)qSpec);
        Map<String, Map<String, Object>> propertiesByType = VmProvisioningProvider.createVmConfigContextResultMap(result);
        Map<String, Object> vmPropertiesByName = propertiesByType.get(VirtualMachine.class.getSimpleName());
        Map<String, Object> hostPropertiesByName = propertiesByType.get(HostSystem.class.getSimpleName());
        Map<String, Object> rpPropertiesByName = propertiesByType.get(ResourcePool.class.getSimpleName());
        if (vmPropertiesByName == null) {
            throw new Exception(Util.getLocalizedString("error.vm.configContext.failed"));
        }
        ManagedObjectReference parentVApp = (ManagedObjectReference)vmPropertiesByName.get(PARENT_VAPP_PROPERTY);
        RuntimeInfo rtInfo = (RuntimeInfo)vmPropertiesByName.get(RUNTIME_PROPERTY);
        String[] grantedPrivileges = (String[])vmPropertiesByName.get("grantedPrivileges");
        Number hostCpuMhz = null;
        if (hostPropertiesByName != null) {
            hostCpuMhz = (Number)hostPropertiesByName.get(HOST_CPU_MHZ_PROPERTY);
        }
        Boolean isInCluster = false;
        if (rpPropertiesByName == null && parentVApp != null) {
            rpPropertiesByName = propertiesByType.get(VirtualApp.class.getSimpleName());
        }
        if (rpPropertiesByName != null) {
            ManagedObjectReference crRef = (ManagedObjectReference)rpPropertiesByName.get(RP_OWNER_PROPERTY);
            isInCluster = ManagedObjectUtil.isOfType((ManagedObjectReference)crRef, ClusterComputeResource.class);
        }
        long t5 = System.currentTimeMillis() - t0 - t1 - t2 - t3 - t4;
        ConfigTarget target = (ConfigTarget)configTargetFuture.get();
        long t6 = System.currentTimeMillis() - t0 - t1 - t2 - t3 - t4 - t5;
        ManagedObjectReference vmDatastore = this.getVmDatastore(target.datastore, config.files.vmPathName);
        VmStorageInfo storageInfo = Util.getVmStorageInfo(this._dataService, vmRef, vmDatastore);
        long t7 = System.currentTimeMillis() - t0 - t1 - t2 - t3 - t4 - t5 - t6;
        ConfigOption option = (ConfigOption)configOptionFuture.get();
        if (gos == null || gos == "" || gos == config.guestId) {
            this.removeExtraGos(config.guestId, option);
        }
        long t8 = System.currentTimeMillis() - t0 - t1 - t2 - t3 - t4 - t5 - t6 - t7;
        VmConfigEnvironment env = new VmConfigEnvironment();
        env.configTarget = target;
        env.configOption = option;
        env.hostCapability = (Capability)capabilityFuture.get();
        env.powerState = rtInfo.powerState;
        env.parentVApp = parentVApp;
        env.ipPoolData = this.getIpPoolData(target, config);
        long t9 = System.currentTimeMillis() - t0 - t1 - t2 - t3 - t4 - t5 - t6 - t7 - t8;
        env.isInCluster = isInCluster;
        env.hostCpuMhz = hostCpuMhz;
        env.datastoreBrowser = (ManagedObjectReference)dsBrowserFuture.get();
        env.descriptors = (ConfigOptionDescriptor[])descriptorsFuture.get();
        String[] npivNodeWorldWideNameHexStrings = Util.formatAsHexStringArray(config.npivNodeWorldWideName);
        String[] npivPortWorldWideNameHexStrings = Util.formatAsHexStringArray(config.npivPortWorldWideName);
        VmConfigContext context = new VmConfigContext();
        context.environment = env;
        context.config = config;
        context.rtInfo = rtInfo;
        context.storageInfo = storageInfo;
        context.npivNodeWorldWideNameHexStrings = npivNodeWorldWideNameHexStrings;
        context.npivPortWorldWideNameHexStrings = npivPortWorldWideNameHexStrings;
        context.privileges = grantedPrivileges;
        long t10 = System.currentTimeMillis() - t0 - t1 - t2 - t3 - t4 - t5 - t6 - t7 - t8 - t9;
        long t11 = System.currentTimeMillis() - t0;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)String.format("\ngetVmConfigContext\n%1$d - Get EnvironmentBrowser\n%2$d - Get ConfigInfo\n%3$d - ConfigInfo manipulation\n%4$d - Fire all futures\n%5$d - Main DS call and data extraction\n%6$d - get ConfigTarget blocking call\n%7$d - VmStorageInfo DS call\n%8$d - get ConfigOption blocking call\n%9$d - VmConfigEnvironment creation + getIpPoolData\n%10$d - VmConfigContext creation\n\n\nTOTAL %11$d", t1, t2, t3, t4, t5, t6, t7, t8, t9, t10, t11));
        }
        return context;
    }

    @type(value="VirtualMachine")
    public VmConfigContext getVmConfigContextLite(ManagedObjectReference vmRef, String gos) throws Exception {
        _logger.debug((Object)"getVmConfigContextLite");
        VmConfigContext retVal = this.getVmConfigContext(vmRef, gos);
        VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
        _logger.debug((Object)"invoke getNetwork()");
        ManagedObjectReference[] networks = vm.getNetwork();
        _logger.debug((Object)"invoke trimConfigTarget()");
        VmProvisioningProvider.trimConfigTarget(retVal.environment.configTarget, networks);
        return retVal;
    }

    private static void trimConfigTarget(ConfigTarget target, ManagedObjectReference[] networks) {
        if (target == null || networks == null) {
            return;
        }
        DistributedVirtualPortgroupInfo[] fullList = target.distributedVirtualPortgroup;
        if (fullList == null) {
            return;
        }
        if (fullList.length == 0) {
            return;
        }
        HashSet<String> lookup = new HashSet<String>();
        for (ManagedObjectReference network : networks) {
            String key = network.getValue();
            lookup.add(key);
        }
        ArrayList<DistributedVirtualPortgroupInfo> shortList = new ArrayList<DistributedVirtualPortgroupInfo>();
        for (DistributedVirtualPortgroupInfo item : fullList) {
            ManagedObjectReference mor = item.portgroup;
            String pgKey = mor.getValue();
            if (!lookup.contains(pgKey)) continue;
            shortList.add(item);
        }
        shortList.trimToSize();
        DistributedVirtualPortgroupInfo[] shortArray = new DistributedVirtualPortgroupInfo[shortList.size()];
        shortList.toArray(shortArray);
        target.distributedVirtualPortgroup = shortArray;
    }

    @type(value="VirtualMachine")
    public VAppIpPoolData getIpPoolData(ManagedObjectReference vmRef) throws Exception {
        ConfigInfo info = (ConfigInfo)QueryUtil.getProperty((DataService)this._dataService, (Object)vmRef, (String)CONFIG_PROPERTY);
        if (info.template) {
            ManagedObjectReference[] networks = (ManagedObjectReference[])QueryUtil.getProperty((DataService)this._dataService, (Object)vmRef, (String)NETWORK_PROPERTY);
            VAppIpPoolData data2 = IpPoolUtil.getIpPoolData((ManagedObjectReference[])networks, (DataService)this._dataService);
            return data2;
        }
        ManagedObjectReference browserRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)vmRef, (String)ENV_BROWSER_PROPERTY);
        EnvironmentBrowser browser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)browserRef);
        EnvironmentBrowser.ConfigTargetQuerySpec onlyNetworksSpec = new EnvironmentBrowser.ConfigTargetQuerySpec(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        ConfigTarget target = EnvironmentBrowserUtil.queryConfigTarget((EnvironmentBrowser)browser, null, (EnvironmentBrowser.ConfigTargetQuerySpec)onlyNetworksSpec);
        VAppIpPoolData data3 = this.getIpPoolData(target, info);
        return data3;
    }

    private void removeExtraGos(String guestId, ConfigOption option) throws Exception {
        for (GuestOsDescriptor descriptor : option.guestOSDescriptor) {
            if (!descriptor.id.equals(guestId)) continue;
            option.guestOSDescriptor = new GuestOsDescriptor[]{descriptor};
            return;
        }
        _logger.error((Object)("guestId '" + guestId + "' is not found in option.guestOSDescriptor array"));
        throw new Exception("Invalid guestId in ConfigInfo");
    }

    @type(value="VirtualMachine")
    public CustomizationSpecInfo[] getCustomizationSpecs(ManagedObjectReference vmRef, String guestId) throws Exception {
        assert (vmRef != null);
        VcService service = VimSessionUtil.getService((String)vmRef.getServerGuid());
        CustomizationSpecManager manager = (CustomizationSpecManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)service.getServiceInstanceContent().customizationSpecManager);
        try {
            manager.checkResources(guestId);
            CustomizationSpecInfo[] result = manager.getInfo();
            return result;
        }
        catch (Exception e) {
            _logger.error((Object)"exception in getCustomizationSpecs", (Throwable)e);
            throw e;
        }
    }

    @type(value="VirtualMachine")
    public CustomizationSpecItem getCustomizationSpec(ManagedObjectReference vmRef, String name) throws Exception {
        assert (vmRef != null);
        assert (!name.isEmpty());
        VcService service = VimSessionUtil.getService((String)vmRef.getServerGuid());
        CustomizationSpecManager manager = (CustomizationSpecManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)service.getServiceInstanceContent().customizationSpecManager);
        try {
            CustomizationSpecItem result = manager.get(name);
            return result;
        }
        catch (Exception e) {
            _logger.error((Object)"exception in getCustomizationSpec", (Throwable)e);
            throw e;
        }
    }

    @type(value="Folder")
    public Boolean getIsNameIpGeneratorDefined(ManagedObjectReference rootFolderRef) throws Exception {
        assert (rootFolderRef != null);
        assert (ManagedObjectUtil.isRootFolder((ManagedObjectReference)rootFolderRef));
        OptionManager optionManager = this.getOptionManager(rootFolderRef);
        try {
            optionManager.queryView(NAME_IP_GENERATOR);
        }
        catch (InvalidName ex) {
            return false;
        }
        return true;
    }

    @type(value="VirtualMachine")
    public SdrsRuleInfo[] getSdrsRulesData(ManagedObjectReference vmRef) throws Exception {
        assert (vmRef != null);
        try {
            SdrsRulesManager ruleManager = new SdrsRulesManager(this._dataService);
            SdrsRuleInfo[] sdrsRules = ruleManager.getSdrsRules(vmRef);
            return sdrsRules;
        }
        catch (Exception e) {
            _logger.error((Object)"exception in getSdrsRules", (Throwable)e);
            throw e;
        }
    }

    @type(value="EnvironmentBrowser,VirtualMachine,HostSystem,ClusterComputeResource,ComputeResource,Datacenter,ResourcePool,VirtualApp")
    public ConfigOptionDescriptor[] getOptionDescriptors(ManagedObjectReference objRef) throws Exception {
        ConfigOptionDescriptor[] optionDescriptors;
        _logger.debug((Object)"getOptionDescriptors");
        assert (objRef != null);
        ManagedObjectReference moRef = null;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, ResourcePool.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, VirtualApp.class)) {
            objRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)objRef, (String)RP_OWNER_PROPERTY);
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, HostSystem.class)) {
            String targetType = ComputeResource.class.getSimpleName();
            PropertyValue[] propValue = QueryUtil.getPropertyForRelatedObjects((DataService)this._dataService, (Object)objRef, (String)HOST_CR_RELATIONSHIP, (String)targetType, (String)ENV_BROWSER_PROPERTY);
            if (propValue.length > 0) {
                moRef = (ManagedObjectReference)propValue[0].value;
            }
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, ClusterComputeResource.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, ComputeResource.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, VirtualMachine.class)) {
            moRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)objRef, (String)ENV_BROWSER_PROPERTY);
        } else {
            assert (ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, EnvironmentBrowser.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, Datacenter.class));
            moRef = objRef;
        }
        if (moRef == null) {
            _logger.debug((Object)"EnvironmentBrowser is unset");
            return null;
        }
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)moRef, EnvironmentBrowser.class)) {
            EnvironmentBrowser envBrowser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)moRef);
            assert (envBrowser != null);
            _logger.debug((Object)"invoke queryConfigOptionDescriptor() for env browser.");
            optionDescriptors = envBrowser.queryConfigOptionDescriptor();
        } else {
            Datacenter dc = (Datacenter)ManagedObjectUtil.getManagedObject((ManagedObjectReference)moRef);
            assert (dc != null);
            _logger.debug((Object)"invoke queryConfigOptionDescriptor() for dc.");
            optionDescriptors = dc.queryConfigOptionDescriptor();
        }
        return optionDescriptors;
    }

    @type(value="EnvironmentBrowser,VirtualMachine,HostSystem,ClusterComputeResource,ComputeResource,Datacenter,ResourcePool,VirtualApp")
    public ConfigOptionDescriptor[] getOptionDescriptorsWithCreateSupported(ManagedObjectReference objRef) throws Exception {
        ConfigOptionDescriptor[] unfilteredOptionDescriptors = this.getOptionDescriptors(objRef);
        VmOptionDescriptorFilter filter = new VmOptionDescriptorFilter();
        return filter.filterCreateSupported(unfilteredOptionDescriptors, objRef);
    }

    @type(value="VmwareDistributedVirtualSwitch")
    public DistributedVirtualPort getDistributedVirtualPort(ManagedObjectReference ref, String port) throws Exception {
        DistributedVirtualPort retVal = null;
        DistributedVirtualSwitch dvs = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)ref);
        PortCriteria criteria = new PortCriteria();
        criteria.portKey = new String[1];
        criteria.portKey[0] = port;
        DistributedVirtualPort[] ports = dvs.fetchPorts(criteria);
        if (ports != null && ports.length > 0) {
            retVal = ports[0];
        }
        return retVal;
    }

    @type(value="HostSystem")
    public String getCanonicalName(ManagedObjectReference hostRef, String lunUUID) throws Exception {
        ScsiLun scsiLun;
        HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
        ConfigManager mgr = host.getConfigManager();
        ManagedObjectReference storageRef = mgr.getStorageSystem();
        if (storageRef == null) {
            return "";
        }
        StorageSystem storage = (StorageSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)storageRef);
        StorageDeviceInfo storageCfg = storage.getStorageDeviceInfo();
        HashMap<String, ScsiLun> map = new HashMap<String, ScsiLun>();
        for (ScsiLun scsiLun2 : storageCfg.scsiLun) {
            map.put(scsiLun2.key, scsiLun2);
        }
        for (ScsiLun scsiLun3 : storageCfg.multipathInfo.lun) {
            if (!map.containsKey(scsiLun3.lun)) continue;
            scsiLun = (ScsiLun)map.get(scsiLun3.lun);
            if (!scsiLun.uuid.equals(lunUUID)) continue;
            return scsiLun.canonicalName;
        }
        for (ScsiLun scsiLun4 : storageCfg.plugStoreTopology.device) {
            if (!map.containsKey(scsiLun4.lun)) continue;
            scsiLun = (ScsiLun)map.get(scsiLun4.lun);
            if (scsiLun.uuid != lunUUID) continue;
            return scsiLun.canonicalName;
        }
        return "";
    }

    @type(value="HostSystem")
    public String getDefaultHardwareVersionKey(ManagedObjectReference moRef) throws Exception {
        String targetType = ComputeResource.class.getSimpleName();
        PropertyValue[] propValue = QueryUtil.getPropertyForRelatedObjects((DataService)this._dataService, (Object)moRef, (String)HOST_CR_RELATIONSHIP, (String)targetType, (String)DEFAULT_HW_VERSION_KEY_PROPERTY);
        if (propValue.length > 0) {
            return (String)propValue[0].value;
        }
        return null;
    }

    @type(value="EnvironmentBrowser")
    public VmConfigEnvironment getVmConfigEnvironment(ManagedObjectReference browserRef, VmConfigEnvParams params) throws Exception {
        _logger.debug((Object)"getVmConfigEnvironment");
        long t0 = System.currentTimeMillis();
        assert (browserRef != null);
        EnvironmentBrowser browser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)browserRef);
        assert (browser != null);
        ClientFutureImpl configOptionFuture = new ClientFutureImpl();
        browser.queryConfigOption(params.key, params.host, (Future)configOptionFuture);
        ClientFutureImpl configTargetFuture = new ClientFutureImpl();
        browser.queryConfigTarget(params.host, (Future)configTargetFuture);
        ClientFutureImpl capabilityFuture = new ClientFutureImpl();
        browser.queryTargetCapabilities(params.host, (Future)capabilityFuture);
        ClientFutureImpl dsBrowserFuture = new ClientFutureImpl();
        browser.getDatastoreBrowser((Future)dsBrowserFuture);
        Number hostCpuMhz = null;
        if (params.host != null) {
            _logger.debug((Object)"fetching host's CPU clock frequency");
            hostCpuMhz = (Number)QueryUtil.getProperty((DataService)this._dataService, (Object)params.host, (String)HOST_CPU_MHZ_PROPERTY);
        }
        long t1 = System.currentTimeMillis() - t0;
        VmConfigEnvironment env = new VmConfigEnvironment();
        env.configTarget = (ConfigTarget)configTargetFuture.get();
        long t2 = System.currentTimeMillis() - t0 - t1;
        env.configOption = (ConfigOption)configOptionFuture.get();
        long t3 = System.currentTimeMillis() - t0 - t1 - t2;
        env.hostCapability = (Capability)capabilityFuture.get();
        env.datastoreBrowser = (ManagedObjectReference)dsBrowserFuture.get();
        env.powerState = VirtualMachine.PowerState.poweredOff;
        env.parentVApp = null;
        env.ipPoolData = this.getIpPoolData(env.configTarget, env.configOption);
        long t4 = System.currentTimeMillis() - t0 - t1 - t2 - t3;
        env.isInCluster = null;
        env.hostCpuMhz = hostCpuMhz;
        long t5 = System.currentTimeMillis() - t0;
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)String.format("\ngetVmConfigEnvironment\n%1$d - host CPU DS call\n%2$d - get ConfigTarget blocking call\n%3$d - get ConfigOption blocking call\n%4$d - ipPoolData DS call\n\n\nTOTAL %5$d", t1, t2, t3, t4, t5));
        }
        return env;
    }

    @type(value="ResourcePool,VirtualApp")
    public VmConfigEnvironment getVmConfigEnvironmentForPool(ManagedObjectReference resPoolRef, VmConfigEnvParams vmConfigEnvParams) throws Exception {
        ManagedObjectReference cr = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)resPoolRef, (String)RP_OWNER_PROPERTY);
        ManagedObjectReference envBrowser = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)cr, (String)ENV_BROWSER_PROPERTY);
        VmConfigEnvironment configEnvironment = this.getVmConfigEnvironment(envBrowser, vmConfigEnvParams);
        configEnvironment.configOption.setGuestOSDescriptor(GuestOsDescriptorFilter.filterCreateSupported(configEnvironment.configOption.guestOSDescriptor));
        configEnvironment.configOption.hardwareOptions.setVirtualDeviceOption(VirtualDeviceOptionFilter.filterDeprecated(configEnvironment.configOption.hardwareOptions.virtualDeviceOption));
        return configEnvironment;
    }

    @type(value="EnvironmentBrowser")
    public DatastoreInfo[] getEnvironmentBrowserDatastoreInfo(ManagedObjectReference browserRef, ManagedObjectReference hostSystemRef) throws Exception {
        _logger.debug((Object)"getEnvironmentBrowserDatastoreInfo");
        assert (browserRef != null);
        EnvironmentBrowser eBrowser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)browserRef);
        assert (eBrowser != null);
        EnvironmentBrowser.ConfigTargetQuerySpec onlyDatastoresSpec = new EnvironmentBrowser.ConfigTargetQuerySpec(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        ConfigTarget configTarget = EnvironmentBrowserUtil.queryConfigTarget((EnvironmentBrowser)eBrowser, (ManagedObjectReference)hostSystemRef, (EnvironmentBrowser.ConfigTargetQuerySpec)onlyDatastoresSpec);
        return configTarget.datastore;
    }

    @type(value="HostSystem,ComputeResource,ClusterComputeResource")
    public DatastoreInfo[] getComputeResourceDatastoreInfo(ManagedObjectReference destination) throws Exception {
        ManagedObjectReference computeResourceRef;
        ManagedObjectReference destinationHost = null;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)destination, HostSystem.class)) {
            computeResourceRef = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)destination, (String)HOST_CR_RELATIONSHIP);
            destinationHost = destination;
        } else {
            computeResourceRef = destination;
        }
        ComputeResource cr = (ComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)computeResourceRef);
        ManagedObjectReference environmentBrowserRef = cr.getEnvironmentBrowser();
        EnvironmentBrowser environmentBrowser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)environmentBrowserRef);
        EnvironmentBrowser.ConfigTargetQuerySpec onlyDatastoresSpec = new EnvironmentBrowser.ConfigTargetQuerySpec(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false));
        ConfigTarget configTarget = EnvironmentBrowserUtil.queryConfigTarget((EnvironmentBrowser)environmentBrowser, (ManagedObjectReference)destinationHost, (EnvironmentBrowser.ConfigTargetQuerySpec)onlyDatastoresSpec);
        return configTarget.datastore;
    }

    private static void initConfigInfo(ConfigInfo config) {
        assert (config != null);
        if (config.cpuAffinity == null) {
            config.cpuAffinity = new AffinityInfo();
        }
        if (config.cpuAffinity.affinitySet == null) {
            config.cpuAffinity.affinitySet = new int[0];
        }
        if (config.memoryAffinity == null) {
            config.memoryAffinity = new AffinityInfo();
        }
        if (config.memoryAffinity.affinitySet == null) {
            config.memoryAffinity.affinitySet = new int[0];
        }
        if (config.cpuFeatureMask == null) {
            config.cpuFeatureMask = new CpuIdInfo[0];
        }
        config.name = MixedUtil.unescapeVimEntityNameSpecialChars((String)config.name);
        if (config.files != null) {
            config.files.vmPathName = MixedUtil.unescapeVimEntityNameSpecialChars((String)config.files.vmPathName);
            config.files.logDirectory = MixedUtil.unescapeVimEntityNameSpecialChars((String)config.files.logDirectory);
            config.files.snapshotDirectory = MixedUtil.unescapeVimEntityNameSpecialChars((String)config.files.snapshotDirectory);
            config.files.suspendDirectory = MixedUtil.unescapeVimEntityNameSpecialChars((String)config.files.suspendDirectory);
        }
        if (config.hardware.numCoresPerSocket == null) {
            config.hardware.numCoresPerSocket = 1;
        }
    }

    private VAppIpPoolData getIpPoolData(ConfigTarget target, ConfigOption option) throws Exception {
        if (target == null || option == null) {
            return null;
        }
        return this.getIpPoolData(target.network, option.defaultDevice);
    }

    private VAppIpPoolData getIpPoolData(ConfigTarget target, ConfigInfo info) throws Exception {
        if (target == null || info == null) {
            return null;
        }
        return this.getIpPoolData(target.network, info.hardware.device);
    }

    private VAppIpPoolData getIpPoolData(NetworkInfo[] networkInfos, VirtualDevice[] devices) throws Exception {
        if (networkInfos == null || devices == null) {
            return null;
        }
        ArrayList<ManagedObjectReference> networkList = new ArrayList<ManagedObjectReference>();
        for (NetworkInfo networkInfo : networkInfos) {
            if (!VmProvisioningProvider.hasNetwork(devices, networkInfo)) continue;
            networkList.add(networkInfo.network.network);
        }
        ManagedObjectReference[] networks = networkList.toArray(new ManagedObjectReference[networkList.size()]);
        VAppIpPoolData ipPoolData = IpPoolUtil.getIpPoolData((ManagedObjectReference[])networks, (DataService)this._dataService);
        return ipPoolData;
    }

    private static boolean hasNetwork(VirtualDevice[] devices, NetworkInfo networkInfo) {
        for (VirtualDevice device : devices) {
            if (!(device instanceof VirtualEthernetCard)) continue;
            VirtualEthernetCard card = (VirtualEthernetCard)device;
            if (!(card.backing instanceof VirtualDevice.DeviceBackingInfo)) continue;
            VirtualDevice.DeviceBackingInfo backing = (VirtualDevice.DeviceBackingInfo)card.backing;
            if (!backing.deviceName.equals(networkInfo.name)) continue;
            return true;
        }
        return false;
    }

    private static void formatOvfSections(ConfigInfo vmConfig) throws Exception {
        VmConfigInfo vappConfig = vmConfig.vAppConfig;
        if (vappConfig == null) {
            return;
        }
        OvfSectionInfo[] sections = vappConfig.ovfSection;
        if (sections == null) {
            return;
        }
        for (OvfSectionInfo section : sections) {
            String origContent = section.getContents();
            String styledContent = OvfUtil.styleOvfSection((String)origContent);
            section.setContents(styledContent);
        }
    }

    private ManagedObjectReference getVmDatastore(DatastoreInfo[] dsInfos, String vmPathName) {
        if (ArrayUtil.isNullOrEmpty((Object[])dsInfos) || StringUtil.isNullOrEmpty((String)vmPathName)) {
            return null;
        }
        if (dsInfos.length == 1) {
            return dsInfos[0].datastore.datastore;
        }
        for (DatastoreInfo dsInfo : dsInfos) {
            StringBuilder builder = new StringBuilder().append("[").append(dsInfo.name).append("] ");
            if (!vmPathName.startsWith(builder.toString())) continue;
            return dsInfo.datastore.datastore;
        }
        return null;
    }

    private OptionManager getOptionManager(ManagedObjectReference ref) throws Exception {
        String serverGuid = ref.getServerGuid();
        VcService vcService = VimSessionUtil.getService((String)serverGuid);
        ServiceInstanceContent content = vcService.getServiceInstanceContent();
        OptionManager optionManager = (OptionManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)content.setting);
        return optionManager;
    }
}

