/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.provisioning.impl;

import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.fault.InvalidState;
import com.vmware.vim.binding.vim.vm.check.ProvisioningChecker;
import com.vmware.vim.binding.vim.vm.check.Result;
import com.vmware.vim.binding.vim.vm.check.TestType;
import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.vm.VmCloneSpec;
import com.vmware.vsphere.client.vm.util.Util;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProvisioningValidator {
    private static Log _logger = LogFactory.getLog(ProvisioningValidator.class);
    private DataService _dataService;
    private TaskMonitor _taskMonitor;
    private ManagedObjectReference _vm;
    private DataObject _spec;
    private ManagedObjectReference _submittedTask = null;

    public ProvisioningValidator(DataService dataService, TaskMonitor taskMonitor, ManagedObjectReference vm, DataObject spec) {
        this._dataService = dataService;
        this._taskMonitor = taskMonitor;
        this._vm = vm;
        this._spec = spec;
    }

    public ValidationResult checkClone() {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = this._vm;
        if (this._vm == null) {
            validationResult.error = Util.getInvalidEntityFault();
            return validationResult;
        }
        TaskInfo taskInfo = null;
        try {
            Util.validateCloneSpec(this._spec);
            ProvisioningChecker checker = this.getProvisioningChecker();
            this.submitCheckCloneTask(checker);
            HashSet<ManagedObjectReference> tasks = new HashSet<ManagedObjectReference>();
            tasks.add(this._submittedTask);
            taskInfo = this.monitorTasks(tasks).get(0);
        }
        catch (Exception e) {
            validationResult.error = MixedUtil.getMethodFault((Throwable)e);
            return validationResult;
        }
        if (taskInfo.state == TaskInfo.State.success) {
            validationResult.result = (Result[])taskInfo.result;
        } else {
            MethodFault fault = new MethodFault();
            fault.initCause((Throwable)taskInfo.error);
            validationResult.error = fault;
        }
        return validationResult;
    }

    private List<TaskInfo> monitorTasks(Set<ManagedObjectReference> incompleteTasks) throws Exception {
        ArrayList<TaskInfo> result = new ArrayList<TaskInfo>();
        int sleepTimeInMs = 100;
        int maxSleepTimeInMs = 1000;
        while (!incompleteTasks.isEmpty()) {
            PropertyValue[] propertyValues;
            try {
                Thread.sleep(Math.min(sleepTimeInMs, maxSleepTimeInMs));
                sleepTimeInMs *= 2;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Object[] incompleteTasksArr = incompleteTasks.toArray(new ManagedObjectReference[0]);
            for (PropertyValue propValue : propertyValues = QueryUtil.getProperty((DataService)this._dataService, (Object[])incompleteTasksArr, (String)"info")) {
                ManagedObjectReference task = (ManagedObjectReference)propValue.resourceObject;
                TaskInfo info = (TaskInfo)propValue.value;
                if (!ProvisioningValidator.isTaskCompleted(info)) continue;
                result.add(info);
                incompleteTasks.remove(task);
            }
        }
        return result;
    }

    private static boolean isTaskCompleted(TaskInfo info) {
        if (info == null) {
            return false;
        }
        return info.state == TaskInfo.State.error || info.state == TaskInfo.State.success;
    }

    private ProvisioningChecker getProvisioningChecker() throws Exception {
        String serverGuid = this._vm.getServerGuid();
        ProvisioningChecker checker = this.getProvisioningCheckerFromVCService(serverGuid);
        if (checker == null) {
            _logger.error((Object)("No Provisioning checker found for VC service, guid = " + serverGuid));
            String errorMsg = ResourceUtil.getString((String)Util.VM_SERVICE_STRINGS, (String)"error.provisioningCheckerNotFound", (ClassLoader)this.getClass().getClassLoader());
            throw new Exception(errorMsg);
        }
        return checker;
    }

    private void submitCheckCloneTask(ProvisioningChecker checker) throws Exception {
        VmCloneSpec vmCloneSpec = (VmCloneSpec)this._spec;
        try {
            ManagedObjectReference taskRef;
            String[] testsToRun = this.convertTestTypesToStrings(vmCloneSpec.testsToRun);
            this._submittedTask = taskRef = checker.checkClone(this._vm, vmCloneSpec.folder, vmCloneSpec.name, vmCloneSpec.cloneSpec, testsToRun);
        }
        catch (InvalidState e) {
            _logger.error((Object)("InvalidState exception received for checkClone for VM " + ManagedObjectUtil.morefToString((ManagedObjectReference)this._vm)));
            throw e;
        }
        catch (Exception e) {
            _logger.error((Object)("Exception occurred for checkClone of VM " + ManagedObjectUtil.morefToString((ManagedObjectReference)this._vm)));
            throw e;
        }
    }

    private String[] convertTestTypesToStrings(TestType[] testTypes) {
        ArrayList<String> tests = new ArrayList<String>();
        if (testTypes != null && testTypes.length > 0) {
            for (TestType testType : testTypes) {
                tests.add(testType.toString());
            }
        }
        String[] testsToRun = null;
        if (!tests.isEmpty()) {
            testsToRun = tests.toArray(new String[0]);
        }
        return testsToRun;
    }

    private ProvisioningChecker getProvisioningCheckerFromVCService(String serverGuid) throws Exception {
        VcService vcService = VimSessionUtil.getService((String)serverGuid);
        if (vcService == null) {
            _logger.error((Object)("Could not get VcService for guid " + serverGuid));
            return null;
        }
        ServiceInstanceContent content = vcService.getServiceInstanceContent();
        if (content == null) {
            _logger.error((Object)("ServiceInstanceContent found null for VC service guid " + serverGuid));
            return null;
        }
        ProvisioningChecker checker = (ProvisioningChecker)ManagedObjectUtil.getManagedObject((ManagedObjectReference)content.vmProvisioningChecker);
        return checker;
    }
}

