/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin;

import com.vmware.vim.binding.sso.admin.fault.PasswordPolicyViolationFault;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.vim.security.certificates.X509Spec;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vsphere.client.sso.admin.DomainManagementService;
import com.vmware.vsphere.client.sso.admin.IdentityProviderService;
import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import com.vmware.vsphere.client.sso.admin.exception.PasswordRequiredException;
import com.vmware.vsphere.client.sso.admin.exception.SsoBackendException;
import com.vmware.vsphere.client.sso.admin.impl.ConfigurationManagementServiceImpl;
import com.vmware.vsphere.client.sso.admin.impl.IdentityProviderServiceImpl;
import com.vmware.vsphere.client.sso.admin.impl.IdentitySourceDomainManagementService;
import com.vmware.vsphere.client.sso.admin.impl.LockoutPolicyServiceImpl;
import com.vmware.vsphere.client.sso.admin.impl.PasswordPolicyServiceImpl;
import com.vmware.vsphere.client.sso.admin.impl.PrincipalManagementServiceImpl;
import com.vmware.vsphere.client.sso.admin.impl.TokenPolicyServiceImpl;
import com.vmware.vsphere.client.sso.admin.model.DecodeKeyStoreSpec;
import com.vmware.vsphere.client.sso.admin.model.DefaultDomainsSpec;
import com.vmware.vsphere.client.sso.admin.model.ExternalDomainCertificateSpec;
import com.vmware.vsphere.client.sso.admin.model.ExternalDomainSpec;
import com.vmware.vsphere.client.sso.admin.model.GroupSpec;
import com.vmware.vsphere.client.sso.admin.model.IdentitySourceSpec;
import com.vmware.vsphere.client.sso.admin.model.IdentitySourceType;
import com.vmware.vsphere.client.sso.admin.model.ImportIdentityProviderSpec;
import com.vmware.vsphere.client.sso.admin.model.LockoutPolicySpec;
import com.vmware.vsphere.client.sso.admin.model.NativeAdDomainSpec;
import com.vmware.vsphere.client.sso.admin.model.PasswordPolicySpec;
import com.vmware.vsphere.client.sso.admin.model.PasswordSpec;
import com.vmware.vsphere.client.sso.admin.model.PrincipalSpec;
import com.vmware.vsphere.client.sso.admin.model.ProbeConnectivitySpec;
import com.vmware.vsphere.client.sso.admin.model.StsCertificateSpec;
import com.vmware.vsphere.client.sso.admin.model.TokenPolicySpec;
import com.vmware.vsphere.client.sso.admin.model.UserSpec;
import com.vmware.vsphere.client.sso.admin.util.SsoAdminUtil;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SsoMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(SsoMutationProvider.class);
    private final PasswordPolicyServiceImpl _passwordPolicyService;
    private final LockoutPolicyServiceImpl _lockoutPolicyService;
    private final TokenPolicyServiceImpl _tokenPolicyService;
    private final ConfigurationManagementServiceImpl _configurationManagementService;
    private final DomainManagementService _domainManagementService;
    private final PrincipalManagementServiceImpl _principalManagementServiceImpl;
    private final IdentityProviderService _identityProviderService;
    private final BackendExceptionTransformer _exceptionTransformer;

    public SsoMutationProvider(SsoService ssoService, PasswordPolicyServiceImpl passwordPolicyServiceImpl, LockoutPolicyServiceImpl lockoutPolicyServiceImpl, TokenPolicyServiceImpl tokenPolicyServiceImpl, ConfigurationManagementServiceImpl configurationManagementServiceImpl, IdentitySourceDomainManagementService identitySourceDomainManagementService, PrincipalManagementServiceImpl principalManagementServiceImpl, IdentityProviderServiceImpl identityProviderServiceImpl, BackendExceptionTransformer backendExceptionTransformer) {
        this._passwordPolicyService = passwordPolicyServiceImpl;
        this._lockoutPolicyService = lockoutPolicyServiceImpl;
        this._tokenPolicyService = tokenPolicyServiceImpl;
        this._configurationManagementService = configurationManagementServiceImpl;
        this._domainManagementService = identitySourceDomainManagementService;
        this._principalManagementServiceImpl = principalManagementServiceImpl;
        this._identityProviderService = identityProviderServiceImpl;
        this._exceptionTransformer = backendExceptionTransformer;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, PasswordPolicySpec passwordPolicySpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            this._passwordPolicyService.updatePasswordPolicy(passwordPolicySpec.passwordPolicy);
        }
        catch (Exception exception) {
            _logger.error((Object)"apply(ManagedObjectReference, PasswordPolicySpec)", (Throwable)exception);
            operationResult.error = this.getOperationResultError(exception);
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, LockoutPolicySpec lockoutPolicySpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            this._lockoutPolicyService.updateLockoutPolicy(lockoutPolicySpec.lockoutPolicy);
        }
        catch (Exception exception) {
            _logger.error((Object)"apply(ManagedObjectReference, LockoutPolicySpec)", (Throwable)exception);
            operationResult.error = this.getOperationResultError(exception);
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, TokenPolicySpec tokenPolicySpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            this._tokenPolicyService.updateTokenPolicy(tokenPolicySpec);
        }
        catch (Exception exception) {
            _logger.error((Object)"apply(ManagedObjectReference, TokenPolicySpec)", (Throwable)exception);
            operationResult.error = this.getOperationResultError(exception);
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, StsCertificateSpec stsCertificateSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            this._configurationManagementService.setNewSignerIdentity(stsCertificateSpec.file, stsCertificateSpec.type, stsCertificateSpec.keyStorePassword, stsCertificateSpec.alias, stsCertificateSpec.privateKeyPass);
        }
        catch (Exception exception) {
            _logger.error((Object)"apply(ManagedObjectReference, StsCertificateSpec)", (Throwable)exception);
            operationResult.error = this.getOperationResultError(exception);
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, ImportIdentityProviderSpec importIdentityProviderSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            this._identityProviderService.importIdentityProviderConfiguration(importIdentityProviderSpec);
        }
        catch (Exception exception) {
            _logger.error((Object)"apply(ManagedObjectReference, IdentityProviderSpec)", (Throwable)exception);
            operationResult.error = this.getOperationResultError(exception);
        }
        return operationResult;
    }

    public OperationResult add(IdentitySourceSpec identitySourceSpec) {
        OperationResult operationResult = new OperationResult();
        try {
            if (identitySourceSpec.type == IdentitySourceType.LDAP) {
                this._domainManagementService.registerLdapDomain((ExternalDomainSpec)identitySourceSpec.domainSpec);
            } else if (identitySourceSpec.type == IdentitySourceType.NATIVE_ACTIVE_DIRECTORY) {
                this._domainManagementService.registerNativeAd((NativeAdDomainSpec)identitySourceSpec.domainSpec);
            } else if (identitySourceSpec.type == IdentitySourceType.LOCAL_OS) {
                this._domainManagementService.registerLocalOSDomain(identitySourceSpec.domainSpec.domainName);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"add(IdentitySourceSpec)", (Throwable)exception);
            operationResult.error = this.getOperationResultError(exception);
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, IdentitySourceSpec identitySourceSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            if (identitySourceSpec.domainSpec instanceof ExternalDomainSpec) {
                this._domainManagementService.updateExternalDomain((ExternalDomainSpec)identitySourceSpec.domainSpec);
            } else if (identitySourceSpec.domainSpec instanceof NativeAdDomainSpec) {
                this._domainManagementService.updateActiveDirectoryDomain((NativeAdDomainSpec)identitySourceSpec.domainSpec);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"apply(ManagedObjectReference, IdentitySourceSpec)", (Throwable)exception);
            operationResult.error = this.getOperationResultError(exception);
        }
        return operationResult;
    }

    public OperationResult remove(ManagedObjectReference managedObjectReference, IdentitySourceSpec identitySourceSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            this._domainManagementService.removeDomain(identitySourceSpec.domainSpec.domainName);
        }
        catch (Exception exception) {
            _logger.error((Object)"remove(ManagedObjectReference, IdentitySourceSpec)", (Throwable)exception);
            operationResult.error = this.getOperationResultError(exception);
        }
        return operationResult;
    }

    public OperationResult add(ExternalDomainCertificateSpec externalDomainCertificateSpec) {
        OperationResult operationResult = new OperationResult();
        try {
            this._domainManagementService.addExternalDomainCertificate(externalDomainCertificateSpec.content);
        }
        catch (Exception exception) {
            _logger.error((Object)"add(ExternalDomainCertificateSpec)", (Throwable)exception);
            operationResult.error = this.getOperationResultError(exception);
        }
        return operationResult;
    }

    public OperationResult add(UserSpec userSpec) {
        OperationResult operationResult = new OperationResult();
        try {
            this._principalManagementServiceImpl.createUser(userSpec.principalId.name, userSpec.personDetails, userSpec.password);
        }
        catch (Exception exception) {
            _logger.error((Object)"add(UserSpec)", (Throwable)exception);
            operationResult.error = this.getLocalizedOperationResultError(exception);
        }
        operationResult.result = Boolean.TRUE;
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, UserSpec userSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            if (userSpec.editOwnDetails) {
                this._principalManagementServiceImpl.editUserOwnDetails(userSpec.personDetails, userSpec.password, userSpec.principalId.name, userSpec.oldPassword);
                return operationResult;
            }
            if (userSpec.state != null) {
                if (userSpec.state.enabled != null) {
                    this._principalManagementServiceImpl.enableUser(userSpec.principalId, userSpec.state.enabled);
                }
                if (userSpec.state.unlocked != null && userSpec.state.unlocked.booleanValue()) {
                    this._principalManagementServiceImpl.unlockUser(userSpec.principalId);
                }
            }
            this._principalManagementServiceImpl.editUser(userSpec.principalId.domain, userSpec.principalId.name, userSpec.personDetails, userSpec.password);
        }
        catch (Exception exception) {
            _logger.error((Object)"apply(ManagedObjectReference, UserSpec)", (Throwable)exception);
            operationResult.error = this.getLocalizedOperationResultError(exception);
        }
        return operationResult;
    }

    public OperationResult add(GroupSpec groupSpec) {
        OperationResult operationResult = new OperationResult();
        try {
            this._principalManagementServiceImpl.createGroup(groupSpec.groupname, groupSpec.groupDetails);
        }
        catch (Exception exception) {
            _logger.error((Object)"add(GroupSpec)", (Throwable)exception);
            operationResult.error = this.getOperationResultError(exception);
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, GroupSpec groupSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            if (!ArrayUtil.isNullOrEmpty((Object[])groupSpec.userIds) || !ArrayUtil.isNullOrEmpty((Object[])groupSpec.groupIds)) {
                this._principalManagementServiceImpl.addToGroup(groupSpec.userIds, groupSpec.groupIds, groupSpec.groupname);
            }
            if (!ArrayUtil.isNullOrEmpty((Object[])groupSpec.removePrincipalIds)) {
                this._principalManagementServiceImpl.removeFromGroup(groupSpec.removePrincipalIds, groupSpec.groupname);
            }
            if (groupSpec.groupDetails != null) {
                this._principalManagementServiceImpl.updateGroup(groupSpec.groupname, groupSpec.groupDetails);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"apply(ManagedObjectReference, GroupSpec)", (Throwable)exception);
            operationResult.error = this.getOperationResultError(exception);
        }
        return operationResult;
    }

    public OperationResult remove(ManagedObjectReference managedObjectReference, PrincipalSpec principalSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            this._principalManagementServiceImpl.deletePrincipal(principalSpec.principalId);
        }
        catch (Exception exception) {
            _logger.error((Object)"remove(ManagedObjectReference, PrincipalSpec)", (Throwable)exception);
            operationResult.error = this.getOperationResultError(exception);
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, PasswordSpec passwordSpec) {
        OperationResult operationResult = new OperationResult();
        managedObjectReference.setType("vsphere:client");
        operationResult.entity = managedObjectReference;
        try {
            this._principalManagementServiceImpl.changePassword(passwordSpec.oldPassword, passwordSpec.newPassword);
        }
        catch (Exception exception) {
            _logger.error((Object)"apply(ManagedObjectReference, PasswordSpec)", (Throwable)exception);
            operationResult.error = this.getLocalizedOperationResultError(exception);
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, DefaultDomainsSpec defaultDomainsSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            this._domainManagementService.setDefaultDomains(defaultDomainsSpec.domainNames);
        }
        catch (Exception exception) {
            _logger.error((Object)"apply(ManagedObjectReference, DefaultDomainsSpec)", (Throwable)exception);
            operationResult.error = this.getOperationResultError(exception);
        }
        return operationResult;
    }

    public ValidationResult validate(ManagedObjectReference managedObjectReference, ProbeConnectivitySpec probeConnectivitySpec) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = managedObjectReference;
        try {
            this._domainManagementService.probeConnectivity(probeConnectivitySpec.url, probeConnectivitySpec.authenticationSpec);
        }
        catch (Exception exception) {
            _logger.error((Object)"validate(ManagedObjectReference, ProbeConnectivitySpec)", (Throwable)exception);
            validationResult.error = this.getOperationResultError(exception);
        }
        return validationResult;
    }

    public ValidationResult validate(ManagedObjectReference managedObjectReference, DecodeKeyStoreSpec decodeKeyStoreSpec) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = managedObjectReference;
        try {
            validationResult.result = this._configurationManagementService.decodeKeyStore(decodeKeyStoreSpec.file, decodeKeyStoreSpec.type, decodeKeyStoreSpec.password);
        }
        catch (KeyStoreException keyStoreException) {
            _logger.error((Object)"Error validating keystore", (Throwable)keyStoreException);
            validationResult.error = new SsoBackendException(keyStoreException.getMessage());
        }
        catch (PasswordRequiredException passwordRequiredException) {
            _logger.debug((Object)"Password required for this keystore type", (Throwable)passwordRequiredException);
            validationResult.error = passwordRequiredException;
        }
        catch (Exception exception) {
            _logger.error((Object)"validate(ManagedObjectReference, DecodeKeyStoreSpec)", (Throwable)exception);
            validationResult.error = this.getOperationResultError(exception);
        }
        return validationResult;
    }

    public ValidationResult validate(ManagedObjectReference managedObjectReference, StsCertificateSpec stsCertificateSpec) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = managedObjectReference;
        try {
            X509Certificate x509Certificate = CertificateUtil.decodeCertificate((byte[])stsCertificateSpec.file);
            X509Spec x509Spec = new X509Spec(x509Certificate);
            validationResult.result = x509Spec;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            _logger.error((Object)"Error reading certificate", (Throwable)illegalArgumentException);
            validationResult.error = new SsoBackendException(illegalArgumentException.getMessage());
        }
        return validationResult;
    }

    private Exception getOperationResultError(Exception exception) {
        if (exception instanceof SsoBackendException) {
            return exception;
        }
        return this._exceptionTransformer.transformException(exception);
    }

    private Exception getLocalizedOperationResultError(Exception exception) {
        Exception exception2 = this.getOperationResultError(exception);
        if (exception2 instanceof PasswordPolicyViolationFault) {
            PasswordPolicyViolationFault passwordPolicyViolationFault = (PasswordPolicyViolationFault)exception2;
            passwordPolicyViolationFault.setMessage(SsoAdminUtil.getString("sso.admin.password.policyViolation.error", new String[0]));
            return passwordPolicyViolationFault;
        }
        return exception2;
    }
}

