/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.exception;

import com.vmware.vim.binding.sso.fault.NoPermission;
import com.vmware.vsphere.client.sso.admin.exception.SsoPermissionException;
import com.vmware.vsphere.client.sso.admin.util.SsoAdminUtil;

public abstract class BackendExceptionTransformer {
    private static final String PERMISSION_ERROR_MESSAGE = "sso.admin.NoPermission";
    private BackendExceptionTransformer nextTransformer;

    public void setSpecificTransformer(BackendExceptionTransformer backendExceptionTransformer) {
        this.nextTransformer = backendExceptionTransformer;
    }

    public Exception transformException(Exception exception) {
        Exception exception2 = null;
        if (exception instanceof NoPermission) {
            return new SsoPermissionException(SsoAdminUtil.getString(PERMISSION_ERROR_MESSAGE, new String[0]));
        }
        if (this.nextTransformer != null) {
            exception2 = this.nextTransformer.transform(exception);
        }
        if (exception2 == null) {
            return this.transform(exception);
        }
        return exception2;
    }

    protected abstract Exception transform(Exception var1);
}

