/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vim.binding.sso.admin.AuthnPolicy;
import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vim.binding.sso.admin.fault.CertificateDeletionFault;
import com.vmware.vim.binding.sso.fault.InvalidCredentials;
import com.vmware.vim.binding.sso.fault.NoPermission;
import com.vmware.vim.binding.sso.fault.NotAuthenticated;
import com.vmware.vim.binding.sso.fault.ServiceFault;
import com.vmware.vise.core.model.BooleanDataObject;
import com.vmware.vise.core.model.StringDataObject;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.security.certificates.X509Spec;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vsphere.client.sso.admin.ConfigurationManagementService;
import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import com.vmware.vsphere.client.sso.admin.exception.PasswordRequiredException;
import com.vmware.vsphere.client.sso.admin.impl.AdminServiceBase;
import com.vmware.vsphere.client.sso.admin.impl.PemKeyStore;
import com.vmware.vsphere.client.sso.admin.model.CertificateChainSpec;
import com.vmware.vsphere.client.sso.admin.model.KeyStoreType;
import com.vmware.vsphere.client.sso.admin.util.SsoAdminUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfigurationManagementServiceImpl
extends AdminServiceBase
implements ConfigurationManagementService {
    private static final Log _logger = LogFactory.getLog(ConfigurationManagementServiceImpl.class);

    public ConfigurationManagementServiceImpl(SsoService ssoService, SsoServiceManager ssoServiceManager, BackendExceptionTransformer backendExceptionTransformer) {
        super(ssoService, ssoServiceManager, backendExceptionTransformer);
    }

    @Override
    public List<List<X509Spec>> getKnownCertificateChains() throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            ConfigurationManagementService.CertificateChain[] certificateChainArray = this.getAdminService(httpSession).getConfigurationManagementService().getKnownCertificateChains();
            ArrayList<List<X509Spec>> arrayList = new ArrayList<List<X509Spec>>(certificateChainArray.length);
            for (int i = 0; i < certificateChainArray.length; ++i) {
                ConfigurationManagementService.CertificateChain certificateChain = certificateChainArray[i];
                LinkedList<X509Spec> linkedList = new LinkedList<X509Spec>();
                arrayList.add(linkedList);
                for (int j = 0; j < certificateChain.certificates.length; ++j) {
                    String string = certificateChain.certificates[j];
                    X509Certificate x509Certificate = CertificateUtil.decodeCertificate((String)string);
                    X509Spec x509Spec = new X509Spec(x509Certificate);
                    linkedList.add(x509Spec);
                }
            }
            return arrayList;
        }
        catch (InvalidCredentials invalidCredentials) {
            _logger.error((Object)"Error in getKnownCertificateChains", (Throwable)invalidCredentials);
            throw this.transformBackendException((Exception)((Object)invalidCredentials));
        }
        catch (SsoServiceException ssoServiceException) {
            _logger.error((Object)"Error in getKnownCertificateChains", (Throwable)ssoServiceException);
            throw this.transformBackendException((Exception)((Object)ssoServiceException));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            _logger.error((Object)"Error in getKnownCertificateChains", (Throwable)unsupportedEncodingException);
            throw new SsoServiceException((Throwable)unsupportedEncodingException);
        }
    }

    public String[] getTrustedCertificates() throws InvalidCredentials, SsoServiceException {
        HttpSession httpSession = SessionUtil.getHttpSession();
        return this.getAdminService(httpSession).getConfigurationManagementService().getTrustedCertificates();
    }

    public String[] getIssuersCertificates() throws InvalidCredentials, SsoServiceException {
        HttpSession httpSession = SessionUtil.getHttpSession();
        return this.getAdminService(httpSession).getConfigurationManagementService().getIssuersCertificates();
    }

    public List<CertificateChainSpec> decodeKeyStore(byte[] byArray, KeyStoreType keyStoreType, String string) throws PasswordRequiredException, KeyStoreException, NoSuchAlgorithmException {
        if (string == null) {
            throw new IllegalArgumentException("Password cannot be null");
        }
        boolean bl = false;
        boolean bl2 = false;
        LinkedList<CertificateChainSpec> linkedList = new LinkedList<CertificateChainSpec>();
        KeyStore keyStore = this.getKeyStore(byArray, string, keyStoreType);
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            int n;
            bl = true;
            StringDataObject stringDataObject = new StringDataObject();
            String string2 = enumeration.nextElement();
            stringDataObject.setValue(string2);
            Certificate[] certificateArray = keyStore.getCertificateChain(string2);
            if (certificateArray == null || !keyStore.isKeyEntry(string2)) continue;
            bl2 = true;
            ArrayList<X509Spec> arrayList = new ArrayList<X509Spec>(certificateArray.length);
            for (n = 0; n < certificateArray.length; ++n) {
                x509Certificate = (X509Certificate)certificateArray[n];
                arrayList.add(new X509Spec(x509Certificate));
            }
            n = this.hasPasswordProtectedPK(keyStore, string2) ? 1 : 0;
            x509Certificate = new BooleanDataObject();
            x509Certificate.setValue(n != 0);
            CertificateChainSpec certificateChainSpec = new CertificateChainSpec(stringDataObject, arrayList, (BooleanDataObject)x509Certificate);
            linkedList.add(certificateChainSpec);
        }
        if (!bl) {
            throw new KeyStoreException(SsoAdminUtil.getString("sso.admin.exception.noAliasFound", new String[0]));
        }
        if (!bl2) {
            throw new KeyStoreException(SsoAdminUtil.getString("sso.admin.exception.noPrivateKeyFound", new String[0]));
        }
        return linkedList;
    }

    public boolean setNewSignerIdentity(byte[] byArray, KeyStoreType keyStoreType, String string, String string2, String string3) throws NotAuthenticated, NoPermission, InvalidCredentials, ServiceFault, SsoServiceException, PasswordRequiredException, KeyStoreException, CertificateEncodingException, UnsupportedEncodingException, NoSuchAlgorithmException {
        Certificate certificate;
        KeyStore keyStore = this.getKeyStore(byArray, string, keyStoreType);
        string2 = this.remapAliasIfNeeded(string2, keyStore, keyStoreType);
        KeyStore.PrivateKeyEntry privateKeyEntry = this.getPrivateKeyEntry(keyStore, string2, string3);
        Certificate[] certificateArray = privateKeyEntry.getCertificateChain();
        ConfigurationManagementService.CertificateChain certificateChain = new ConfigurationManagementService.CertificateChain();
        certificateChain.certificates = new String[certificateArray.length];
        for (int i = 0; i < certificateArray.length; ++i) {
            certificate = certificateArray[i];
            certificateChain.certificates[i] = ConfigurationManagementServiceImpl.toVmodl(certificate.getEncoded());
        }
        String string4 = ConfigurationManagementServiceImpl.toVmodl(privateKeyEntry.getPrivateKey().getEncoded());
        certificate = SessionUtil.getHttpSession();
        this.getAdminService((HttpSession)certificate).getConfigurationManagementService().setNewSignerIdentity(string4, certificateChain);
        return true;
    }

    private String remapAliasIfNeeded(String string, KeyStore keyStore, KeyStoreType keyStoreType) throws KeyStoreException {
        if (keyStore.containsAlias(string)) {
            return string;
        }
        if (KeyStoreType.PKCS12.equals((Object)keyStoreType)) {
            return keyStore.aliases().nextElement();
        }
        return string;
    }

    private KeyStore.PrivateKeyEntry getPrivateKeyEntry(KeyStore keyStore, String string, String string2) throws PasswordRequiredException, NoSuchAlgorithmException, KeyStoreException {
        try {
            KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(string2 != null ? string2.toCharArray() : null);
            return (KeyStore.PrivateKeyEntry)keyStore.getEntry(string, passwordProtection);
        }
        catch (UnrecoverableEntryException unrecoverableEntryException) {
            _logger.error((Object)unrecoverableEntryException.getMessage(), (Throwable)unrecoverableEntryException);
            throw new PasswordRequiredException(unrecoverableEntryException);
        }
    }

    private boolean hasPasswordProtectedPK(KeyStore keyStore, String string) throws NoSuchAlgorithmException, KeyStoreException {
        try {
            this.getPrivateKeyEntry(keyStore, string, null);
            return false;
        }
        catch (PasswordRequiredException passwordRequiredException) {
            return true;
        }
    }

    @Override
    public String getSsoServerHost() {
        try {
            URL uRL = new URL(this.getSsoServerInfo().getAdminAppUrl());
            return uRL.getHost();
        }
        catch (Exception exception) {
            _logger.error((Object)"getSsoServerUrl()", (Throwable)exception);
            return null;
        }
    }

    public static String toVmodl(byte[] byArray) throws UnsupportedEncodingException {
        return new String(Base64.encodeBase64((byte[])byArray), "UTF-8");
    }

    private KeyStore getKeyStore(byte[] byArray, String string, KeyStoreType keyStoreType) throws PasswordRequiredException {
        if (string == null) {
            throw new IllegalArgumentException("Password cannot be null");
        }
        try {
            KeyStore keyStore = null;
            switch (keyStoreType) {
                case PEM: {
                    keyStore = new PemKeyStore();
                    break;
                }
                default: {
                    keyStore = KeyStore.getInstance(keyStoreType.name());
                }
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            keyStore.load(byteArrayInputStream, string.toCharArray());
            return keyStore;
        }
        catch (KeyStoreException keyStoreException) {
            _logger.error((Object)keyStoreException.getMessage(), (Throwable)keyStoreException);
            throw new IllegalStateException(keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            _logger.error((Object)noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            throw new IllegalStateException(noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            _logger.error((Object)certificateException.getMessage(), (Throwable)certificateException);
            throw new IllegalStateException(certificateException);
        }
        catch (IOException iOException) {
            _logger.error((Object)iOException.getMessage(), (Throwable)iOException);
            if (iOException.getCause() instanceof UnrecoverableKeyException) {
                throw new PasswordRequiredException(iOException);
            }
            if (iOException.getCause() instanceof ArithmeticException || iOException.getCause() instanceof BadPaddingException) {
                throw new PasswordRequiredException(iOException);
            }
            throw new IllegalStateException(iOException);
        }
    }

    boolean deleteTrustedCertificate(String string) throws CertificateDeletionFault, NotAuthenticated, NoPermission, InvalidCredentials, SsoServiceException {
        _logger.debug((Object)("deleteTrustedCertificate: " + string));
        HttpSession httpSession = SessionUtil.getHttpSession();
        boolean bl = this.getAdminService(httpSession).getConfigurationManagementService().deleteTrustedCertificate(string);
        _logger.debug((Object)("deleteTrustedCertificate result = " + (bl ? "true" : "false")));
        return bl;
    }

    @Override
    public AuthnPolicy getAuthnPolicy() throws SsoServiceException {
        AuthnPolicy authnPolicy = null;
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            authnPolicy = this.getAdminService(httpSession).getConfigurationManagementService().getAuthnPolicy();
        }
        catch (Exception exception) {
            _logger.error((Object)"Exception occured while getting SSO authentication policy", (Throwable)exception);
            throw new SsoServiceException((Throwable)exception);
        }
        return authnPolicy;
    }

    @Override
    public void setAuthnPolicy(AuthnPolicy authnPolicy) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            this.getAdminService(httpSession).getConfigurationManagementService().setAuthnPolicy(authnPolicy);
        }
        catch (Exception exception) {
            _logger.error((Object)"Exception occured while setting SSO authentication policy", (Throwable)exception);
            throw new SsoServiceException((Throwable)exception);
        }
    }
}

