/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vim.binding.sso.admin.fault.ADIDSAlreadyExistFault;
import com.vmware.vim.binding.sso.fault.InvalidCredentials;
import com.vmware.vim.binding.sso.fault.NoPermission;
import com.vmware.vim.binding.sso.fault.NotAuthenticated;
import com.vmware.vim.binding.sso.fault.ServiceFault;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vsphere.client.sso.admin.impl.IdentitySourceDomainManagementService;
import com.vmware.vsphere.client.sso.admin.model.X509RemovalSpec;
import com.vmware.vsphere.client.sso.admin.model.X509UsageInfo;
import com.vmware.vsphere.client.sso.admin.model.X509UsageSpec;
import com.vmware.vsphere.client.sso.admin.util.SsoAdminUtil;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DomainManagerMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(DomainManagerMutationProvider.class);
    private final IdentitySourceDomainManagementService _domainManagementService;

    public DomainManagerMutationProvider(SsoService ssoService, IdentitySourceDomainManagementService identitySourceDomainManagementService) {
        this._domainManagementService = identitySourceDomainManagementService;
    }

    @type(value="sso:DomainManager")
    public OperationResult remove(URI uRI, X509RemovalSpec x509RemovalSpec) {
        OperationResult operationResult = new OperationResult();
        try {
            boolean bl = this._domainManagementService.removeExternalDomainCertificate(x509RemovalSpec.thumbprint);
            operationResult.result = bl;
        }
        catch (Exception exception) {
            _logger.error((Object)"remove(URI, X509RemovalSpec)", (Throwable)exception);
            operationResult.error = SsoAdminUtil.getOperationResultError(exception);
        }
        return operationResult;
    }

    @type(value="sso:DomainManager")
    public ValidationResult[] validateMultiSpec(URI uRI, X509UsageSpec[] x509UsageSpecArray) throws SsoServiceException, NotAuthenticated, NoPermission, InvalidCredentials, ADIDSAlreadyExistFault {
        if (ArrayUtil.isNullOrEmpty((Object[])x509UsageSpecArray)) {
            return new ValidationResult[0];
        }
        Map<String, String> map = this._domainManagementService.getExternalDomainsCertificateUsage(x509UsageSpecArray);
        String string = map.get("error");
        ServiceFault serviceFault = null;
        if (string != null) {
            serviceFault = new ServiceFault();
            serviceFault.setMessage(string);
        }
        ArrayList<ValidationResult> arrayList = new ArrayList<ValidationResult>(x509UsageSpecArray.length);
        for (X509UsageSpec x509UsageSpec : x509UsageSpecArray) {
            String string2 = map.get(x509UsageSpec.thumbprint);
            X509UsageInfo x509UsageInfo = new X509UsageInfo();
            x509UsageInfo.thumbprint = x509UsageSpec.thumbprint;
            x509UsageInfo.usedByDomain = string2;
            ValidationResult validationResult = new ValidationResult();
            if ("?".equals(x509UsageInfo.usedByDomain)) {
                validationResult.error = serviceFault;
            } else {
                validationResult.result = x509UsageInfo;
            }
            arrayList.add(validationResult);
        }
        return (ValidationResult[])ArrayUtil.toArray(arrayList, ValidationResult.class);
    }
}

