/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vim.binding.sso.admin.ConfigurationManagementService;
import com.vmware.vim.binding.sso.fault.InvalidCredentials;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.vim.security.certificates.X509Spec;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.exception.SsoServiceException;
import com.vmware.vsphere.client.sso.admin.SystemManagementService;
import com.vmware.vsphere.client.sso.admin.impl.IdentitySourceDomainManagementService;
import com.vmware.vsphere.client.sso.admin.model.DomainSpec;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DomainManagerPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(DomainManagerPropertyProvider.class);
    private final IdentitySourceDomainManagementService _domainManagementService;
    private final SystemManagementService _systemManagementService;

    public DomainManagerPropertyProvider(SsoService ssoService, IdentitySourceDomainManagementService identitySourceDomainManagementService, SystemManagementService systemManagementService) {
        _logger.debug((Object)"instantiated");
        this._domainManagementService = identitySourceDomainManagementService;
        this._systemManagementService = systemManagementService;
    }

    @ModelMetadata(type={"sso:DomainManager"}, property="idsCertificates")
    public X509Spec[] getIdsCertificates(URI uRI) throws InvalidCredentials, SsoServiceException, UnsupportedEncodingException {
        Object[] objectArray = this._domainManagementService.getExternalDomainsCertificates();
        ArrayList<X509Spec> arrayList = new ArrayList<X509Spec>();
        for (String string : (String[])ArrayUtil.toSafe((Object[])objectArray, String.class)) {
            X509Certificate x509Certificate = CertificateUtil.decodeCertificate((String)string);
            X509Spec x509Spec = new X509Spec(x509Certificate);
            arrayList.add(x509Spec);
        }
        return (X509Spec[])ArrayUtil.toArray(arrayList, X509Spec.class);
    }

    @ModelMetadata(type={"sso:DomainManager"}, property="vsphere:identitySourceList")
    public DomainSpec[] getIdentitySources(Object object, boolean bl) throws Exception {
        List<DomainSpec> list = this._domainManagementService.getIdentitySources(bl);
        _logger.debug((Object)("Found " + list.size() + " identity sources"));
        return (DomainSpec[])ArrayUtil.toArray(list, DomainSpec.class);
    }

    @ModelMetadata(type={"sso:DomainManager"}, property="vsphere:activeDirectoryDomainName")
    public String getActiveDirectoryDomainName(URI uRI) throws Exception {
        String string = this._systemManagementService.getDomainName();
        return string;
    }

    @ModelMetadata(type={"sso:DomainManager"}, property="vsphere:sslIdentity")
    public X509Spec[] getSslIdentity(URI uRI, String string) throws Exception {
        ArrayList<X509Spec> arrayList = new ArrayList<X509Spec>();
        URI uRI2 = new URI(string);
        ConfigurationManagementService.CertificateChain certificateChain = this._domainManagementService.getSslIdentity(uRI2);
        for (String string2 : certificateChain.certificates) {
            X509Certificate x509Certificate = CertificateUtil.decodeCertificate((String)string2);
            X509Spec x509Spec = new X509Spec(x509Certificate);
            arrayList.add(x509Spec);
        }
        return arrayList.toArray(new X509Spec[arrayList.size()]);
    }
}

