/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.impl;

import com.vmware.vim.binding.sso.admin.PasswordPolicy;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.security.sso.SsoService;
import com.vmware.vise.vim.security.sso.SsoServiceManager;
import com.vmware.vsphere.client.sso.admin.PasswordPolicyService;
import com.vmware.vsphere.client.sso.admin.exception.BackendExceptionTransformer;
import com.vmware.vsphere.client.sso.admin.impl.AdminServiceBase;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PasswordPolicyServiceImpl
extends AdminServiceBase
implements PasswordPolicyService {
    private static final Log _logger = LogFactory.getLog(PasswordPolicyServiceImpl.class);

    public PasswordPolicyServiceImpl(SsoService ssoService, SsoServiceManager ssoServiceManager, BackendExceptionTransformer backendExceptionTransformer) {
        super(ssoService, ssoServiceManager, backendExceptionTransformer);
    }

    @Override
    public PasswordPolicy getPasswordPolicy() throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            return this.getAdminService(httpSession).getPasswordPolicyService().getLocalPasswordPolicy();
        }
        catch (Exception exception) {
            _logger.error((Object)"PasswordPolicyServiceImpl.getPasswordPolicy", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }

    @Override
    public void updatePasswordPolicy(PasswordPolicy passwordPolicy) throws Exception {
        try {
            HttpSession httpSession = SessionUtil.getHttpSession();
            if (passwordPolicy.passwordLifetimeDays == 0) {
                passwordPolicy.passwordLifetimeDays = null;
            }
            this.getAdminService(httpSession).getPasswordPolicyService().updateLocalPasswordPolicy(passwordPolicy);
        }
        catch (Exception exception) {
            _logger.error((Object)"PasswordPolicyServiceImpl.updatePasswordPolicy", (Throwable)exception);
            throw this.transformBackendException(exception);
        }
    }
}

