/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.sso.admin.util;

import com.vmware.vim.binding.sso.admin.SolutionUser;
import com.vmware.vim.binding.sso.admin.fault.PasswordPolicyViolationFault;
import com.vmware.vim.binding.sso.fault.ServiceFault;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.vim.security.certificates.X509Spec;
import com.vmware.vsphere.client.sso.admin.exception.PasswordRequiredException;
import com.vmware.vsphere.client.sso.admin.model.ApplicationUser;
import java.io.UnsupportedEncodingException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SsoAdminUtil {
    private static final String RESOURCE_BUNDLE_NAME = "ssoadminservice";
    private static final Log _logger = LogFactory.getLog(SsoAdminUtil.class);

    public static ApplicationUser toApplicationUser(SolutionUser solutionUser) {
        ApplicationUser applicationUser = new ApplicationUser();
        applicationUser.id = solutionUser.id;
        applicationUser.alias = solutionUser.alias;
        applicationUser.disabled = solutionUser.disabled;
        if (solutionUser.details == null) {
            return applicationUser;
        }
        applicationUser.description = solutionUser.details.description;
        if (solutionUser.details.certificate == null) {
            return applicationUser;
        }
        try {
            Certificate certificate = CertificateUtil.generateCertificate((String)solutionUser.details.certificate);
            applicationUser.certificate = new X509Spec((X509Certificate)certificate);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            _logger.error((Object)"Certificate data encoding is wrong:", (Throwable)unsupportedEncodingException);
        }
        catch (CertificateException certificateException) {
            _logger.error((Object)"Certificate data decoding failed:", (Throwable)certificateException);
        }
        return applicationUser;
    }

    public static Exception getOperationResultError(Exception exception) {
        if (exception instanceof PasswordPolicyViolationFault || exception instanceof PasswordRequiredException) {
            return exception;
        }
        ServiceFault serviceFault = new ServiceFault();
        serviceFault.setMessage(exception.getMessage());
        serviceFault.setStackTrace(exception.getStackTrace());
        if (exception instanceof ServiceFault) {
            ServiceFault serviceFault2 = (ServiceFault)exception;
            serviceFault.setFaultCause(serviceFault2.getFaultCause());
            serviceFault.setFaultMessage(serviceFault2.getFaultMessage());
        }
        return serviceFault;
    }

    public static String getString(String string, String ... stringArray) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)string, (String[])stringArray, (ClassLoader)SsoAdminUtil.class.getClassLoader());
    }
}

