/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.cluster.ha;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.commands.DataFetchCommand;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vsphere.client.cluster.ha.ClusterDataModel;
import com.vmware.vsphere.client.cluster.ha.DatastoreDataModel;
import com.vmware.vsphere.client.cluster.ha.HeartbeatDatastoreCandidatesRetriever;
import com.vmware.vsphere.client.cluster.util.Util;
import java.util.ArrayList;
import java.util.Collection;

public class HeartbeatDatastoreCandidatesRetrieverImpl
implements HeartbeatDatastoreCandidatesRetriever {
    private static final int REQUIRED_DATASTORE_MOUNTS = 2;
    private final DataFetchCommand _dataFetchCommand;

    public HeartbeatDatastoreCandidatesRetrieverImpl(DataFetchCommand dataFetchCommand) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{dataFetchCommand});
        this._dataFetchCommand = dataFetchCommand;
    }

    @Override
    public ManagedObjectReference[] getHeartbeatDatastoreCandidates(ManagedObjectReference clusterRef) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{clusterRef});
        ArrayList<ManagedObjectReference> datastoreList = new ArrayList<ManagedObjectReference>();
        ClusterDataModel clusterData = Util.getDataModel(ClusterDataModel.class, clusterRef, this._dataFetchCommand);
        if (clusterData == null || ArrayUtil.isNullOrEmpty((Object[])clusterData.hosts) || ArrayUtil.isNullOrEmpty((Object[])clusterData.datastores)) {
            return new ManagedObjectReference[0];
        }
        Collection datastoresData = this._dataFetchCommand.execute(DatastoreDataModel.class, (Object[])clusterData.datastores);
        for (DatastoreDataModel datastoreData : datastoresData) {
            int numOfRelevantHostMounts;
            if (datastoreData == null || datastoreData.type == null || datastoreData.type.equalsIgnoreCase("vsan") || (numOfRelevantHostMounts = HeartbeatDatastoreCandidatesRetrieverImpl.getNumOfRelevantHostMounts(datastoreData.hostMounts, clusterData.hosts)) < 2) continue;
            datastoreList.add((ManagedObjectReference)datastoreData.provider);
        }
        return datastoreList.toArray(new ManagedObjectReference[datastoreList.size()]);
    }

    private static int getNumOfRelevantHostMounts(Datastore.HostMount[] hostMounts, ManagedObjectReference[] clusterHosts) {
        int numOfRelevantMounts = 0;
        for (Datastore.HostMount host : hostMounts) {
            if (!ArrayUtil.contains((Object)host.key, (Object[])clusterHosts).booleanValue()) continue;
            ++numOfRelevantMounts;
        }
        return numOfRelevantMounts;
    }
}

