/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.create;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.Capability;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.EVCMode;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.cluster.GroupInfo;
import com.vmware.vim.binding.vim.cluster.HostGroup;
import com.vmware.vim.binding.vim.cluster.VmGroup;
import com.vmware.vim.binding.vim.host.CpuPackage;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.cluster.rules.RuleConflictInfo;
import com.vmware.vsphere.client.cluster.rules.RuleInfoEx;
import com.vmware.vsphere.client.cluster.rules.RuleMemberInfo;
import com.vmware.vsphere.client.cluster.rules.impl.ClusterRuleSpecValidator;
import com.vmware.vsphere.client.clusterui.model.create.CreateClusterConfig;
import com.vmware.vsphere.client.clusterui.model.create.EvcData;
import com.vmware.vsphere.client.clusterui.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.LinkedMultiValueMap;

public class ClusterPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(ClusterPropertyProvider.class);
    private static final String NEW_UNIQUE_CLUSTER_NAME = "newUniqueClusterName";
    public static final String GROUPS = "ClusterComputeResource/configurationEx/group";
    public static final String[] VIRTUAL_MACHINES = new String[]{VirtualMachine.class.getSimpleName()};
    public static final String[] HOSTS = new String[]{HostSystem.class.getSimpleName()};
    public static final String[] CLUSTERS = new String[]{ClusterComputeResource.class.getSimpleName()};
    private final QueryExecutor _queryExecutor;
    private final DataService _dataService;
    private final QueryService _queryService;

    public ClusterPropertyProvider(DataService dataService, QueryExecutor queryExecutor, QueryServiceFactory queryServiceFactory) {
        this._dataService = dataService;
        this._queryExecutor = queryExecutor;
        this._queryService = queryServiceFactory.getQueryService();
    }

    @type(value="ClusterComputeResource")
    public GroupInfo[] getGroupsData(ManagedObjectReference clusterRef, String filterText) throws Exception {
        LinkedMultiValueMap vmMembers = new LinkedMultiValueMap();
        LinkedMultiValueMap hostMembers = new LinkedMultiValueMap();
        GroupInfo[] groups = this.getGroupInfos(clusterRef);
        if (!StringUtil.isNullOrEmpty((String)filterText)) {
            HashSet<GroupInfo> filteredGroups = new HashSet<GroupInfo>();
            for (GroupInfo group : groups) {
                VmGroup vmGroup;
                ManagedObjectReference[] vms;
                if (StringUtils.containsIgnoreCase((String)group.name, (String)filterText)) {
                    filteredGroups.add(group);
                    continue;
                }
                if (group instanceof HostGroup) {
                    HostGroup hostGroup = (HostGroup)group;
                    ManagedObjectReference[] hosts = hostGroup.getHost();
                    if (hosts == null) continue;
                    for (ManagedObjectReference host : hosts) {
                        hostMembers.add((Object)host, (Object)group);
                    }
                    continue;
                }
                if (!(group instanceof VmGroup) || (vms = (vmGroup = (VmGroup)group).getVm()) == null) continue;
                for (ManagedObjectReference vm : vms) {
                    vmMembers.add((Object)vm, (Object)group);
                }
            }
            if (!vmMembers.isEmpty()) {
                List<ManagedObjectReference> filteredVms = this.filterByName(filterText, vmMembers.keySet(), VIRTUAL_MACHINES);
                for (ManagedObjectReference vm : filteredVms) {
                    filteredGroups.addAll((Collection)vmMembers.get((Object)vm));
                }
            }
            if (!hostMembers.isEmpty()) {
                List<ManagedObjectReference> filteredHosts = this.filterByName(filterText, hostMembers.keySet(), HOSTS);
                for (ManagedObjectReference host : filteredHosts) {
                    filteredGroups.addAll((Collection)hostMembers.get((Object)host));
                }
            }
            groups = filteredGroups.toArray(new GroupInfo[0]);
        }
        return groups;
    }

    private GroupInfo[] getGroupInfos(ManagedObjectReference clusterRef) {
        ResultSet groupsResultSet = this._queryService.select(new String[]{GROUPS}).from(CLUSTERS).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)clusterRef)}).opId("get-cluster-groups").fetch();
        List resourceItem = groupsResultSet.getItems();
        GroupInfo[] result = !ArrayUtil.isNullOrEmpty((List)resourceItem) ? (GroupInfo[])((ResourceItem)resourceItem.get(0)).get(GROUPS) : new GroupInfo[]{};
        return result;
    }

    private List<ManagedObjectReference> filterByName(String filterText, Set<ManagedObjectReference> objects, String[] targetTypes) {
        ResultSet filteredVmsResultSet;
        List resourceItems;
        ArrayList<ManagedObjectReference> filteredObjects = new ArrayList<ManagedObjectReference>();
        if (!CollectionUtil.isNullOrEmpty(objects) && !(resourceItems = (filteredVmsResultSet = this._queryService.select(new String[]{"@modelKey"}).from(targetTypes).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, objects), PropertyPredicate.containsIgnoreCase((String)"name", (String)filterText)}).opId("search-groups-by-member-names").fetch()).getItems()).isEmpty()) {
            for (ResourceItem vmItem : resourceItems) {
                filteredObjects.add((ManagedObjectReference)vmItem.get("@modelKey"));
            }
        }
        return filteredObjects;
    }

    @type(value="Folder,Datacenter")
    public CreateClusterConfig getCreateClusterConfig(ManagedObjectReference mor) {
        CreateClusterConfig config = new CreateClusterConfig();
        config.uniqueName = this.getClusterUniqueName(mor);
        Capability capability = this.getCapability(mor);
        if (capability != null) {
            config.evcModes = this.getEvcModes(capability);
            config.hciWorkflowSupported = false;
        }
        return config;
    }

    @type(value="ClusterComputeResource")
    public RuleInfoEx[] getRulesData(ManagedObjectReference clusterRef) throws Exception {
        RuleInfoEx[] rules;
        ClusterRuleSpecValidator validator = new ClusterRuleSpecValidator(this._dataService, clusterRef, null);
        for (RuleInfoEx ruleInfoEx : rules = validator.getConflictsForExistingRules()) {
            ruleInfoEx.conflictingRules = ClusterPropertyProvider.copyRuleInfoExArray(ruleInfoEx.conflictingRules);
            ruleInfoEx.members = ClusterPropertyProvider.copyRuleMemberInfoArrayWithConflicts(ruleInfoEx.members);
        }
        return rules;
    }

    private static ArrayList<RuleMemberInfo> copyRuleMemberInfoArrayWithConflicts(ArrayList<RuleMemberInfo> ruleMembers) {
        ArrayList<RuleMemberInfo> ruleMembersCopy = new ArrayList<RuleMemberInfo>(ruleMembers.size());
        for (RuleMemberInfo ruleMember : ruleMembers) {
            RuleMemberInfo copyOfRuleMember = RuleMemberInfo.createInstance(ruleMember.entity);
            copyOfRuleMember.rules = ClusterPropertyProvider.copyRuleInfoExArrayWithConflicts(ruleMember.rules);
            copyOfRuleMember.conflicts = ClusterPropertyProvider.copyRuleConflictInfoArray(ruleMember.conflicts);
            ruleMembersCopy.add(copyOfRuleMember);
        }
        return ruleMembersCopy;
    }

    private static ArrayList<RuleInfoEx> copyRuleInfoExArray(ArrayList<RuleInfoEx> rules) {
        ArrayList<RuleInfoEx> rulesCopy = new ArrayList<RuleInfoEx>(rules.size());
        for (RuleInfoEx ruleInfoEx : rules) {
            rulesCopy.add(RuleInfoEx.createFromRuleInfo(ruleInfoEx.rule));
        }
        return rulesCopy;
    }

    private static ArrayList<RuleInfoEx> copyRuleInfoExArrayWithConflicts(ArrayList<RuleInfoEx> rules) {
        ArrayList<RuleInfoEx> rulesCopy = new ArrayList<RuleInfoEx>(rules.size());
        for (RuleInfoEx ruleInfoEx : rules) {
            RuleInfoEx ruleCopy = RuleInfoEx.createFromRuleInfo(ruleInfoEx.rule);
            ruleCopy.conflictingRules = ClusterPropertyProvider.copyRuleInfoExArray(ruleInfoEx.conflictingRules);
            rulesCopy.add(ruleCopy);
        }
        return rulesCopy;
    }

    private static ArrayList<RuleConflictInfo> copyRuleConflictInfoArray(ArrayList<RuleConflictInfo> ruleConflicts) {
        ArrayList<RuleConflictInfo> ruleConflictsCopy = new ArrayList<RuleConflictInfo>(ruleConflicts.size());
        for (RuleConflictInfo ruleConflict : ruleConflicts) {
            RuleConflictInfo ruleConflictCopy = RuleConflictInfo.createInstance(ruleConflict.conflictType);
            ruleConflictCopy.rule1 = RuleInfoEx.createFromRuleInfo(ruleConflict.rule1.rule);
            ruleConflictCopy.rule2 = RuleInfoEx.createFromRuleInfo(ruleConflict.rule2.rule);
            ruleConflictCopy.members = ClusterPropertyProvider.copyRuleMemberInfoArray(ruleConflict.members);
            ruleConflictsCopy.add(ruleConflictCopy);
        }
        return ruleConflictsCopy;
    }

    private static RuleMemberInfo[] copyRuleMemberInfoArray(RuleMemberInfo[] ruleMembers) {
        RuleMemberInfo[] ruleMembersCopy = new RuleMemberInfo[ruleMembers.length];
        for (int i = 0; i < ruleMembers.length; ++i) {
            ruleMembersCopy[i] = RuleMemberInfo.createInstance(ruleMembers[i].entity);
        }
        return ruleMembersCopy;
    }

    private String getClusterUniqueName(ManagedObjectReference mor) {
        try {
            return (String)this._queryExecutor.getProperty((Object)mor, NEW_UNIQUE_CLUSTER_NAME);
        }
        catch (Exception e) {
            _logger.error((Object)"Can't return cluster unique name.", (Throwable)e);
            return "";
        }
    }

    private EvcData[] getEvcModes(Capability capability) {
        ArrayList<EvcData> amdEvcData = new ArrayList<EvcData>();
        ArrayList<EvcData> intelEvcData = new ArrayList<EvcData>();
        Object[] evcModes = capability.supportedEVCMode;
        if (ArrayUtil.isNullOrEmpty((Object[])evcModes)) {
            return new EvcData[0];
        }
        for (Object mode : evcModes) {
            EvcData evcData = this.createEvcData((EVCMode)mode);
            if (CpuPackage.Vendor.amd.toString().equals(((EVCMode)mode).vendor)) {
                amdEvcData.add(evcData);
                continue;
            }
            if (!CpuPackage.Vendor.intel.toString().equals(((EVCMode)mode).vendor)) continue;
            intelEvcData.add(evcData);
        }
        ArrayList<EvcData> result = new ArrayList<EvcData>();
        result.addAll(amdEvcData);
        result.addAll(intelEvcData);
        return result.toArray(new EvcData[0]);
    }

    private EvcData createEvcData(EVCMode mode) {
        EvcData data2 = new EvcData();
        data2.key = mode.key;
        data2.description = mode.summary;
        data2.label = mode.label;
        if (CpuPackage.Vendor.amd.toString().equals(mode.vendor)) {
            data2.category = Util.getLocalizedString("evc.config.enableEvcAmdLabel", new String[0]);
        } else if (CpuPackage.Vendor.intel.toString().equals(mode.vendor)) {
            data2.category = Util.getLocalizedString("evc.config.enableEvcIntelLabel", new String[0]);
        }
        return data2;
    }

    private Capability getCapability(ManagedObjectReference mor) {
        VcService service = VimSessionUtil.getService((String)mor.getServerGuid());
        if (service == null) {
            _logger.error((Object)"Could not retrieve VcService");
            return null;
        }
        ServiceInstance serviceInstance = service.getServiceInstance();
        if (serviceInstance == null) {
            _logger.error((Object)"Could not retrieve service instance");
            return null;
        }
        return serviceInstance.getCapability();
    }
}

