/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.reservation;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.ResourcePoolBaseReservationUsersData;
import com.vmware.vsphere.client.clusterui.model.monitor.reservation.VmBaseReservationUsersData;
import com.vmware.vsphere.client.clusterui.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class ResourcePoolBaseCapacityData
extends IdentifiableQueryBinding {
    public abstract String getRpReservationCapacityFormatted();

    public abstract String getAvailableCapacityFormatted();

    public abstract String getReservedCapacityFormatted();

    protected abstract long getAvailableCapacity();

    protected abstract long getReservedCapacity();

    protected abstract VmBaseReservationUsersData[] getVms();

    protected abstract ResourcePoolBaseReservationUsersData[] getResourcePools();

    public List<Object> getReservationUsers() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.getVms() != null) {
            result.addAll(Arrays.asList(this.getVms()));
        }
        if (this.getResourcePools() != null) {
            result.addAll(Arrays.asList(this.getResourcePools()));
        }
        return result;
    }

    public double getActivePercentage() {
        return Util.getPercentageValue(this.getReservedCapacity(), this.getReservationCapacity());
    }

    protected long getReservationCapacity() {
        return this.getAvailableCapacity() + this.getReservedCapacity();
    }
}

