/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.clusterui.model.monitor.utilization;

import com.vmware.cis.data.api.binding.IdentifiableQueryBinding;
import com.vmware.vim.binding.vim.SharesInfo;
import com.vmware.vsphere.client.clusterui.util.Util;

public abstract class BaseUtilizationData
extends IdentifiableQueryBinding {
    protected abstract Long getLimitValue();

    protected abstract Long getReservationValue();

    protected abstract Integer getStaticEntitlementValue();

    protected abstract Long getResourceSizeValue();

    protected abstract Long getConsummationValue();

    protected abstract Long getOverallDemand();

    protected abstract SharesInfo getSharesInfoValue();

    public double getLimitPercentage() {
        double resultValue = 0.0;
        Long limitValue = this.getLimitValue();
        if (limitValue != null) {
            resultValue = limitValue >= 0L ? Util.getPercentageValue(limitValue, this.getMaxValueNum()) : limitValue.doubleValue();
        }
        return resultValue;
    }

    public double getReservationPercentage() {
        return Util.getPercentageValue(this.getReservationValue(), this.getMaxValueNum());
    }

    public double getWorstCaseAllocationPercentage() {
        return Util.getPercentageValue(this.getStaticEntitlementValue().intValue(), this.getMaxValueNum());
    }

    protected Long getMaxValueNum() {
        long resourceSizeValue = this.getResourceSizeValue() != null ? this.getResourceSizeValue() : 0L;
        long limitValue = this.getLimitValue() != null ? this.getLimitValue() : 0L;
        long consummationValue = this.getConsummationValue() != null ? this.getConsummationValue() : 0L;
        long overallCpuDemandValue = this.getOverallDemand() != null ? this.getOverallDemand() : 0L;
        long reservationValue = this.getReservationValue() != null ? this.getReservationValue() : 0L;
        return Util.max(resourceSizeValue, limitValue, consummationValue, overallCpuDemandValue, reservationValue);
    }
}

