/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.h5.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.license.client.cis.global.ds.LicensingGlobalData;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.util.LicenseScopeUtil;
import com.vmware.license.client.cis.util.LicensingMethodFault;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AssetAvailabilityPropertyProvider {
    private static final String LICENSING_GLOBAL_DATA_TYPE = "LicensingGlobalData";
    private static final String LICENSE_GLOBAL_DATA_PROP = "licensingGlobalData";
    private static final Log _logger = LogFactory.getLog(AssetAvailabilityPropertyProvider.class);
    private QueryService _queryService;

    public AssetAvailabilityPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="HostSystem/isAssignLicenseActionAvailable")
    public Collection<Boolean> getHostIsAssignLicenseActionAvailable(Collection<ManagedObjectReference> collection) {
        return this.getIsAssignLicenseActionAvailable(collection);
    }

    @PropertyProvider(value="ClusterComputeResource/isAssignLicenseActionAvailable")
    public Collection<Boolean> getClusterComputeResourceIsAssignLicenseActionAvailable(Collection<ManagedObjectReference> collection) {
        return this.getIsAssignLicenseActionAvailable(collection);
    }

    @PropertyProvider(value="Folder/isAssignLicenseActionAvailable")
    public Collection<Boolean> getFolderIsAssignLicenseActionAvailable(Collection<ManagedObjectReference> collection) {
        return this.getIsAssignLicenseActionAvailable(collection);
    }

    private Collection<Boolean> getIsAssignLicenseActionAvailable(Collection<ManagedObjectReference> collection) {
        if (collection == null || collection.size() == 0) {
            return null;
        }
        ManagedObjectReference[] managedObjectReferenceArray = collection.toArray(new ManagedObjectReference[0]);
        if (!LicenseScopeUtil.doAssetsHaveSameScope((ManagedObjectReference[])managedObjectReferenceArray)) {
            return Collections.nCopies(collection.size(), false);
        }
        LicenseScope licenseScope = LicenseScopeUtil.getLicenseScopeByMoRef((ManagedObjectReference)managedObjectReferenceArray[0]);
        Boolean bl = this.checkLicensingAdminPrivilege(licenseScope);
        return Collections.nCopies(collection.size(), bl);
    }

    private boolean checkLicensingAdminPrivilege(LicenseScope licenseScope) {
        LicensingGlobalData licensingGlobalData = this.retrieveLicensingGlobalDataForScope(licenseScope);
        if (licensingGlobalData != null) {
            return licensingGlobalData.isLicensingAdminPrivilegeGranted();
        }
        return false;
    }

    private LicensingGlobalData retrieveLicensingGlobalDataForScope(LicenseScope licenseScope) {
        URI uRI = DefaultUriSchemeUtil.createUri((String)LICENSING_GLOBAL_DATA_TYPE, (String)licenseScope.getId());
        ResultSet resultSet = null;
        try {
            resultSet = this._queryService.select(new String[]{LICENSE_GLOBAL_DATA_PROP}).from(new String[]{LICENSING_GLOBAL_DATA_TYPE}).where("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)uRI).fetch();
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof LicensingMethodFault) {
                _logger.error((Object)("The request for license global data failed with error: " + runtimeException.getMessage()));
            }
            throw runtimeException;
        }
        if (resultSet == null || resultSet.getItems() == null || resultSet.getItems().isEmpty()) {
            return null;
        }
        ResourceItem resourceItem = (ResourceItem)resultSet.getItems().get(0);
        return (LicensingGlobalData)resourceItem.get(LICENSE_GLOBAL_DATA_PROP);
    }
}

