/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.h5.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.license.client.cis.util.LicensingMethodFault;
import com.vmware.vim.binding.cis.license.fault.NotFoundFault;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.HashMap;
import java.util.Map;

public final class LicensingAssetPropertyProvider {
    private final QueryService _queryService;
    public static final String PROPERTY = "asset";
    public static final String TARGET_TYPE = "Asset";
    public static final String RELATION = "assets";
    public static final String RESPONSE_PROPERTY_ASSET = "asset";
    public static final String RESPONSE_PROPERTY_ERROR = "notFound";
    public static final String RESPONSE_PROPERTY_OBJECT_TYPE = "managedObjectRef";

    public LicensingAssetPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="HostSystem/asset")
    public Map<String, Object> getHostSystemAssetProperty(ManagedObjectReference managedObjectReference) {
        return this.getAsset(managedObjectReference);
    }

    @PropertyProvider(value="ClusterComputeResource/asset")
    public Map<String, Object> getClusterComputeResourceAssetProperty(ManagedObjectReference managedObjectReference) {
        return this.getAsset(managedObjectReference);
    }

    @PropertyProvider(value="Folder/asset")
    public Map<String, Object> getFolderAssetProperty(ManagedObjectReference managedObjectReference) {
        return this.getAsset(managedObjectReference);
    }

    private Map<String, Object> getAsset(ManagedObjectReference managedObjectReference) {
        if (managedObjectReference == null) {
            return null;
        }
        ResultSet resultSet = null;
        try {
            resultSet = this._queryService.select(new String[]{"asset"}).from(new String[]{TARGET_TYPE}).where(RELATION, PropertyPredicate.ComparisonOperator.EQUAL, (Object)managedObjectReference).fetch();
        }
        catch (Exception exception) {
            Throwable throwable;
            Throwable throwable2 = exception.getCause();
            if (throwable2 instanceof LicensingMethodFault && (throwable = ((LicensingMethodFault)throwable2).getMostInnerCause()) instanceof NotFoundFault) {
                return this.transformResultSet(null, managedObjectReference);
            }
            throw exception;
        }
        return this.transformResultSet(resultSet, managedObjectReference);
    }

    private Map<String, Object> transformResultSet(ResultSet resultSet, ManagedObjectReference managedObjectReference) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (resultSet == null) {
            hashMap.put("asset", null);
            hashMap.put(RESPONSE_PROPERTY_ERROR, true);
            hashMap.put(RESPONSE_PROPERTY_OBJECT_TYPE, managedObjectReference);
            return hashMap;
        }
        if (resultSet.getItems().size() > 0) {
            ResourceItem resourceItem = (ResourceItem)resultSet.getItems().get(0);
            hashMap.put("asset", resourceItem.get("asset"));
            hashMap.put(RESPONSE_PROPERTY_ERROR, false);
            hashMap.put(RESPONSE_PROPERTY_OBJECT_TYPE, managedObjectReference);
        }
        return hashMap;
    }
}

