/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.connection.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vise.security.ClientSessionEndListener;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.h5.autodeploy.connection.EndpointLocator;
import com.vmware.vsphere.client.h5.autodeploy.connection.http.HttpClientConfigFactory;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.VmomiClientFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachingVmomiClientFactory
extends VmomiClientFactory
implements ClientSessionEndListener {
    private static final Log _logger = LogFactory.getLog(CachingVmomiClientFactory.class);
    private final long CACHE_MAX_SIZE = 1000L;
    private final long EXPIRE_INTERVAL_MS = 600000L;
    private final LoadingCache<String, ConcurrentMap<String, Client>> clientsCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(600000L, TimeUnit.MILLISECONDS).recordStats().removalListener((RemovalListener)new RemovalListener<String, ConcurrentMap<String, Client>>(){

        public void onRemoval(RemovalNotification<String, ConcurrentMap<String, Client>> removal) {
            for (Client client : ((ConcurrentMap)removal.getValue()).values()) {
                client.shutdown();
            }
        }
    }).build((CacheLoader)new CacheLoader<String, ConcurrentMap<String, Client>>(){

        public ConcurrentMap<String, Client> load(String clientId) {
            return new ConcurrentHashMap<String, Client>();
        }
    });

    public CachingVmomiClientFactory(EndpointLocator endpointLocator, Map<Class<?>, Class<?>> versionClassMap, HttpClientConfigFactory httpClientConfig) {
        super(endpointLocator, versionClassMap, httpClientConfig);
    }

    public Client getClient(VcService vcService, String clientId) {
        String serverGuid = vcService.getServiceGuid();
        ConcurrentMap clientsPerServiceMap = (ConcurrentMap)this.clientsCache.getUnchecked((Object)clientId);
        Client client = clientsPerServiceMap.putIfAbsent(serverGuid, super.createClient(vcService));
        if (client == null) {
            client = (Client)clientsPerServiceMap.get(serverGuid);
        }
        _logger.debug((Object)this.clientsCache.stats().toString());
        return client;
    }

    public void sessionEnded(String clientId) {
        this.clientsCache.invalidate((Object)clientId);
    }
}

