/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.connection.impl;

import com.google.common.base.Preconditions;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.h5.autodeploy.connection.EndpointLocator;
import com.vmware.vsphere.client.h5.autodeploy.connection.http.HttpClientConfigFactory;
import java.net.URI;
import java.util.Map;

public class VmomiClientFactory {
    private EndpointLocator _endpointLocator;
    private Map<Class<?>, Class<?>> _versionClassMap;
    private HttpClientConfigFactory _httpClientConfig;

    public VmomiClientFactory(EndpointLocator endpointLocator, Map<Class<?>, Class<?>> versionClass, HttpClientConfigFactory httpClientConfig) {
        this._endpointLocator = (EndpointLocator)Preconditions.checkNotNull((Object)endpointLocator);
        this._versionClassMap = (Map)Preconditions.checkNotNull(versionClass);
        this._httpClientConfig = (HttpClientConfigFactory)Preconditions.checkNotNull((Object)httpClientConfig);
    }

    public Client createClient(VcService vcService) {
        URI endpoint = this._endpointLocator.getEndpoint(vcService);
        HttpClientConfiguration httpConfig = this._httpClientConfig.getHttpClientConfig(vcService);
        Class<?> vmodlVersion = this._versionClassMap.get(vcService.getVmodlVersion());
        if (vmodlVersion == null) {
            throw new UnsupportedOperationException("Client API is incompatible with the target VC service");
        }
        return Client.Factory.createClient((URI)endpoint, vmodlVersion, (ClientConfiguration)httpConfig);
    }
}

