/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.fileUpload;

import com.google.common.base.Preconditions;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.h5.autodeploy.connection.EndpointLocator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.KeyStore;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.springframework.web.HttpRequestHandler;

public class FileUploadRequestHandler
implements HttpRequestHandler {
    private static final Log _logger = LogFactory.getLog(FileUploadRequestHandler.class);
    private static final int ONE_MB = 0x100000;
    private static final String VC_SERVICE_GUID_PARAM = "vc_service_guid";
    private final EndpointLocator _endpointLocatior;
    private KeystoreService _keystoreService;

    public FileUploadRequestHandler(EndpointLocator endpointLocatior) {
        this._endpointLocatior = endpointLocatior;
    }

    public void setKeystoreService(KeystoreService keystoreService) {
        this._keystoreService = keystoreService;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String httpMethod = request.getMethod();
        if (httpMethod.equalsIgnoreCase("POST")) {
            this.doPost(request, response);
        } else {
            response.setStatus(404);
            response.setContentType("text/plain");
            try (PrintWriter printWriter = response.getWriter();){
                printWriter.print(httpMethod + " requests not supported.");
            }
        }
    }

    private SSLSocketFactory getSSLSocketFactory() throws Exception {
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(this._keystoreService.getKeyStore()).build();
        SSLSocketFactory socketFactory = sslcontext.getSocketFactory();
        return socketFactory;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String vcServiceGuid = request.getParameter(VC_SERVICE_GUID_PARAM);
        URL url = null;
        HttpsURLConnection connection = null;
        try {
            url = this.getURL(vcServiceGuid);
        }
        catch (Exception e) {
            String errorMessage = "Failed to retrieve url.";
            _logger.error((Object)errorMessage, (Throwable)e);
            this.returnError(response, errorMessage);
            return;
        }
        try {
            connection = this.createConnection(url, request.getContentType(), request.getContentLength());
        }
        catch (Exception e) {
            String errorMessage = "Failed to create connection to url: " + url;
            _logger.error((Object)errorMessage, (Throwable)e);
            this.returnError(response, errorMessage);
            return;
        }
        try (ServletInputStream input = request.getInputStream();
             OutputStream output = connection.getOutputStream();){
            byte[] buffer = new byte[0x100000];
            int length = 0;
            while ((length = input.read(buffer)) > 0) {
                output.write(buffer, 0, length);
                output.flush();
            }
        }
        catch (IOException e) {
            String errorMessage = "Failed to transfer data to url: " + url;
            _logger.error((Object)errorMessage, (Throwable)e);
            this.returnError(response, errorMessage);
            return;
        }
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            response.setStatus(200);
            response.setContentType("text/plain");
            try (PrintWriter printWriter = response.getWriter();){
                printWriter.print("File uploaded successfully.");
            }
        } else {
            String responseMessage = connection.getResponseMessage();
            _logger.error((Object)String.format("HTTP POST to url: %s failed with status code: %s and response message: %s", url, responseCode, responseMessage));
            this.returnError(response, responseMessage);
        }
    }

    private void returnError(HttpServletResponse response, String errorMessage) throws IOException {
        response.setStatus(500);
        response.setContentType("text/plain");
        try (PrintWriter printWriter = response.getWriter();){
            printWriter.print(errorMessage);
        }
    }

    private URL getURL(String vcServiceGuid) throws MalformedURLException {
        Preconditions.checkNotNull((Object)vcServiceGuid, (Object)"VC service GUID is null.");
        VcService vcService = VimSessionUtil.getService((String)vcServiceGuid);
        URI endPointURI = this._endpointLocatior.getEndpoint(vcService);
        Preconditions.checkNotNull((Object)endPointURI, (Object)("Endpoint cannot be found for VC service GUID: " + vcServiceGuid));
        return endPointURI.toURL();
    }

    private HttpsURLConnection createConnection(URL url, String contentType, int contentLength) throws Exception {
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setSSLSocketFactory(this.getSSLSocketFactory());
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-Type", contentType);
        if (contentLength > -1) {
            connection.setFixedLengthStreamingMode(contentLength);
        } else {
            connection.setChunkedStreamingMode(0x100000);
        }
        return connection;
    }
}

