/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.host.impl;

import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.vmware.vim.binding.rbd.PxeProfile;
import com.vmware.vim.binding.rbd.RuleManager;
import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.CustomFieldsManager;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.host.ConnectSpec;
import com.vmware.vim.binding.vim.profile.host.HostProfile;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.h5.autodeploy.AutoDeployService;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.AutoDeployServiceFactory;
import com.vmware.vsphere.client.h5.autodeploy.host.AddDiscoveredHostsSpec;
import com.vmware.vsphere.client.h5.autodeploy.host.Attribute;
import com.vmware.vsphere.client.h5.autodeploy.host.DiscoveredHostIdentifier;
import com.vmware.vsphere.client.h5.autodeploy.host.EditHostImageProfileSpec;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AutoDeployHostMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(AutoDeployHostMutationProvider.class);
    private static final String MACHINE_IDENTITY = "AutoDeploy.MachineIdentity";
    private final AutoDeployServiceFactory _serviceFactory;
    private final QueryExecutor _queryExecutor;
    private final TaskMonitor _taskMonitor;

    public AutoDeployHostMutationProvider(AutoDeployServiceFactory serviceFactory, QueryExecutor queryExecutor, TaskMonitor taskMonitor) {
        this._serviceFactory = (AutoDeployServiceFactory)Preconditions.checkNotNull((Object)serviceFactory);
        this._queryExecutor = (QueryExecutor)Preconditions.checkNotNull((Object)queryExecutor);
        this._taskMonitor = (TaskMonitor)Preconditions.checkNotNull((Object)taskMonitor);
    }

    public OperationResult apply(ManagedObjectReference hostRef, EditHostImageProfileSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = hostRef;
        try {
            Preconditions.checkNotNull((Object)hostRef, (Object)"The host cannot be null.");
            AutoDeployService autoDeployService = this._serviceFactory.getService(hostRef.getServerGuid());
            if (spec.imageProfileToDisassociate != null) {
                PxeProfile pxeProfile = (PxeProfile)autoDeployService.getManagedObject(spec.imageProfileToDisassociate);
                pxeProfile.dissociateEntities(new ManagedObjectReference[]{hostRef});
            }
            if (spec.imageProfileToAssociate != null) {
                RuleManager ruleManager = autoDeployService.getRuleManager();
                String imageProfileName = (String)this._queryExecutor.getProperty((Object)spec.imageProfileToAssociate, "name");
                result.task = ruleManager.applyImageProfile(new ManagedObjectReference[]{hostRef}, imageProfileName, null, spec.skipImageProfileSignatureCheck);
            }
        }
        catch (Exception ex) {
            result.error = ex;
            _logger.error((Object)ex);
        }
        return result;
    }

    public OperationResult[] addMulti(AddDiscoveredHostsSpec[] specs) {
        if (specs.length != 1) {
            _logger.warn((Object)"Received more than one AddDiscoveredHostSpec.");
        }
        AddDiscoveredHostsSpec spec = specs[0];
        Preconditions.checkNotNull((Object)spec.imageProfile, (Object)"The host image profile cannot be null.");
        Preconditions.checkNotNull((Object)spec.location, (Object)"The host location cannot be null.");
        Preconditions.checkNotNull((Object)spec.hostsToAdd, (Object)"Hosts to add cannot be null");
        OperationResult[] result = new OperationResult[spec.hostsToAdd.length];
        for (int i = 0; i < spec.hostsToAdd.length; ++i) {
            DiscoveredHostIdentifier hostId = spec.hostsToAdd[i];
            OperationResult resultForHost = new OperationResult();
            resultForHost.entity = hostId.hostName;
            try {
                Preconditions.checkNotNull((Object)hostId.hostName, (Object)"The host name cannot be null.");
                Preconditions.checkNotNull((Object)hostId.uuid, (Object)"The host UUID cannot be null.");
                ConnectSpec connectSpec = AutoDeployHostMutationProvider.createConnectSpec(hostId);
                Optional<ManagedObjectReference> host = this.addHost(spec.location, connectSpec);
                ManagedObjectReference hostRef = (ManagedObjectReference)host.get();
                resultForHost.task = this.addImageProfile(hostRef, spec.imageProfile, spec.skipImageProfileSignatureCheck);
                if (spec.hostProfile != null) {
                    this.attachHostProfile(hostRef, spec.hostProfile);
                }
                this.addHostAttribute(hostRef, hostId.uuid);
                resultForHost.result = hostRef;
            }
            catch (Exception ex) {
                resultForHost.error = ex;
                _logger.error((Object)ex);
            }
            result[i] = resultForHost;
        }
        return result;
    }

    private Optional<ManagedObjectReference> addHost(ManagedObjectReference location, ConnectSpec connectSpec) throws Exception {
        Optional<ManagedObjectReference> host = null;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)location, (String)"Folder")) {
            host = this.addStandaloneHost(location, connectSpec);
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)location, (String)"Datacenter")) {
            ManagedObjectReference hostFolder = (ManagedObjectReference)this._queryExecutor.getProperty((Object)location, "hostFolder");
            host = this.addStandaloneHost(hostFolder, connectSpec);
        } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)location, (String)"ClusterComputeResource")) {
            host = this.addHostToCluster(location, connectSpec);
        }
        return host;
    }

    private Optional<ManagedObjectReference> addStandaloneHost(ManagedObjectReference folder, ConnectSpec connectSpec) throws Exception {
        Optional host = Optional.absent();
        Folder hostFolder = (Folder)ManagedObjectUtil.getManagedObject((ManagedObjectReference)folder);
        ManagedObjectReference task = hostFolder.addStandaloneHost(connectSpec, null, false, null);
        TaskInfo addHostTaskInfo = this._taskMonitor.monitorTask(task);
        if (TaskInfo.State.success.equals((Object)addHostTaskInfo.state) && addHostTaskInfo.result instanceof ManagedObjectReference) {
            ManagedObjectReference computeResourceRef = (ManagedObjectReference)addHostTaskInfo.result;
            ComputeResource computeResource = (ComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)computeResourceRef);
            ManagedObjectReference[] hosts = (ManagedObjectReference[])Objects.firstNonNull((Object)computeResource.getHost(), (Object)new ManagedObjectReference[0]);
            host = Optional.fromNullable(hosts.length > 0 ? hosts[0] : null);
        }
        return host;
    }

    private Optional<ManagedObjectReference> addHostToCluster(ManagedObjectReference clusterRef, ConnectSpec connectSpec) throws Exception {
        Optional host = null;
        ClusterComputeResource cluster = (ClusterComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)clusterRef);
        ManagedObjectReference task = cluster.addHost(connectSpec, false, null, null);
        TaskInfo addHostTaskInfo = this._taskMonitor.monitorTask(task);
        if (TaskInfo.State.success.equals((Object)addHostTaskInfo.state) && addHostTaskInfo.result instanceof ManagedObjectReference) {
            host = Optional.fromNullable((Object)((ManagedObjectReference)addHostTaskInfo.result));
        }
        return host;
    }

    private ManagedObjectReference addImageProfile(ManagedObjectReference host, URI imageProfile, Boolean skipImageProfileSignatureCheck) throws Exception {
        AutoDeployService autoDeployService = this._serviceFactory.getService(host.getServerGuid());
        RuleManager ruleManager = autoDeployService.getRuleManager();
        String imageProfileName = (String)this._queryExecutor.getProperty((Object)imageProfile, "name");
        ManagedObjectReference task = ruleManager.applyImageProfile(new ManagedObjectReference[]{host}, imageProfileName, null, skipImageProfileSignatureCheck);
        return task;
    }

    private void attachHostProfile(ManagedObjectReference host, ManagedObjectReference hostProfile) throws Exception {
        HostProfile profile = (HostProfile)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostProfile);
        profile.associateEntities(new ManagedObjectReference[]{host});
    }

    private static ConnectSpec createConnectSpec(DiscoveredHostIdentifier hostId) {
        ConnectSpec connectSpec = new ConnectSpec();
        connectSpec.hostName = hostId.hostName;
        return connectSpec;
    }

    private void addHostAttribute(ManagedObjectReference hostRef, String uuid) throws Exception {
        CustomFieldsManager.FieldDef[] fieldDefs;
        CustomFieldsManager fieldManager = this.getCustomFieldManager(hostRef.getServerGuid());
        String value = String.format("%s=%s", Attribute.UUID.getKey(), uuid);
        for (CustomFieldsManager.FieldDef def : fieldDefs = fieldManager.getField()) {
            if (!MACHINE_IDENTITY.equals(def.getName())) continue;
            fieldManager.setField(hostRef, def.getKey(), value);
        }
    }

    private CustomFieldsManager getCustomFieldManager(String serverGuid) throws Exception {
        VcService service = VimSessionUtil.getService((String)serverGuid);
        ServiceInstance instance = service.getServiceInstance();
        ServiceInstanceContent content = instance.getContent();
        ManagedObjectReference fieldManagerRef = content.getCustomFieldsManager();
        CustomFieldsManager fieldManager = (CustomFieldsManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)fieldManagerRef);
        return fieldManager;
    }
}

