/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.impl;

import com.google.common.base.Preconditions;
import com.vmware.vim.binding.rbd.HostOps;
import com.vmware.vim.binding.rbd.PxeProfileManager;
import com.vmware.vim.binding.rbd.RuleManager;
import com.vmware.vim.binding.rbd.ScriptManager;
import com.vmware.vim.binding.rbd.ServiceContent;
import com.vmware.vim.binding.rbd.ServiceInstance;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vsphere.client.h5.autodeploy.AutoDeployService;
import com.vmware.vsphere.client.h5.autodeploy.util.VlsiUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AutoDeployServiceImpl
implements AutoDeployService {
    private static final Log _logger = LogFactory.getLog(AutoDeployServiceImpl.class);
    private final Client _client;
    private final String SERVICE_INSTANCE_TYPE = "RbdServiceInstance";
    private final String SERVICE_INSTANCE_VALUE = "ServiceInstance";
    private String _vcServiceGuid;

    public AutoDeployServiceImpl(Client client, String vcServiceGuid) {
        this._client = (Client)Preconditions.checkNotNull((Object)client);
        this._vcServiceGuid = vcServiceGuid;
    }

    @Override
    public <T extends ManagedObject> T getManagedObject(ManagedObjectReference moRef) {
        Class<T> typeClass = this.getBindingClass(moRef.getType());
        T stub = VlsiUtil.createStub(typeClass, moRef, this._client, this.getClass().getClassLoader());
        return stub;
    }

    @Override
    public ServiceInstance getServiceInstance() {
        Class typeClass = this.getBindingClass("RbdServiceInstance");
        ManagedObjectReference serviceInstanceRef = new ManagedObjectReference("RbdServiceInstance", "ServiceInstance");
        ServiceInstance serviceInstance = (ServiceInstance)VlsiUtil.createStub(typeClass, serviceInstanceRef, this._client, this.getClass().getClassLoader());
        return serviceInstance;
    }

    @Override
    public ServiceContent getServiceContent() {
        ServiceInstance serviceInstance = this.getServiceInstance();
        ServiceContent serviceContent = serviceInstance.getContent();
        return serviceContent;
    }

    @Override
    public RuleManager getRuleManager() {
        ServiceContent serviceContent = this.getServiceContent();
        if (serviceContent == null) {
            return null;
        }
        ManagedObjectReference ruleManagerRef = serviceContent.getRuleManager();
        return (RuleManager)this.getManagedObject(ruleManagerRef);
    }

    @Override
    public HostOps getHostOps() {
        ServiceContent serviceContent = this.getServiceContent();
        if (serviceContent == null) {
            return null;
        }
        ManagedObjectReference hostOpsRef = serviceContent.getHostOps();
        return (HostOps)this.getManagedObject(hostOpsRef);
    }

    @Override
    public PxeProfileManager getPxeProfileManager() {
        ServiceContent serviceContent = this.getServiceContent();
        if (serviceContent == null) {
            return null;
        }
        ManagedObjectReference pxeProfileManagerRef = serviceContent.getPxeManager();
        return (PxeProfileManager)this.getManagedObject(pxeProfileManagerRef);
    }

    @Override
    public ScriptManager getScriptManager() {
        ServiceContent serviceContent = this.getServiceContent();
        if (serviceContent == null) {
            return null;
        }
        ManagedObjectReference managerRef = serviceContent.getScriptManager();
        return (ScriptManager)this.getManagedObject(managerRef);
    }

    private <T> Class<T> getBindingClass(String managedObjectType) {
        VmodlTypeMap typeMap = VmodlTypeMap.Factory.getTypeMap();
        VmodlType vmodlType = typeMap.getVmodlType(managedObjectType);
        Class bindingClass = vmodlType.getTypeClass();
        return bindingClass;
    }

    @Override
    public void close() {
        this._client.shutdown();
    }
}

