/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.impl;

import com.google.common.base.Preconditions;
import com.vmware.vim.binding.imagebuilder.DepotManager;
import com.vmware.vim.binding.imagebuilder.ImageBuilder;
import com.vmware.vim.binding.imagebuilder.ImageProfileEngine;
import com.vmware.vim.binding.imagebuilder.ServiceInstance;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.exception.ConnectionException;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vsphere.client.h5.autodeploy.ImageBuilderService;
import com.vmware.vsphere.client.h5.autodeploy.util.VlsiUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageBuilderServiceImpl
implements ImageBuilderService {
    private static final Log _logger = LogFactory.getLog(ImageBuilderServiceImpl.class);
    private final Client _client;
    private final String CONNECTION_ERROR = "Cannot establish connection to ImageBuilder service associated with VC with serverGuid=%s.";
    private final ManagedObjectReference _serviceInstanceRef = new ManagedObjectReference("ImageBuilderServiceInstance", "ServiceInstance");
    private String _vcServiceGuid;

    public ImageBuilderServiceImpl(Client client, String vcServiceGuid) {
        this._client = (Client)Preconditions.checkNotNull((Object)client);
        this._vcServiceGuid = vcServiceGuid;
    }

    @Override
    public <T extends ManagedObject> T getManagedObject(ManagedObjectReference moRef) {
        Class<T> typeClass = this.getBindingClass(moRef.getType());
        T stub = VlsiUtil.createStub(typeClass, moRef, this._client, this.getClass().getClassLoader());
        return stub;
    }

    @Override
    public ServiceInstance getServiceInstance() {
        Class typeClass = this.getBindingClass(this._serviceInstanceRef.getType());
        ServiceInstance serviceInstance = (ServiceInstance)VlsiUtil.createStub(typeClass, this._serviceInstanceRef, this._client, this.getClass().getClassLoader());
        return serviceInstance;
    }

    @Override
    public DepotManager getDepotManager() {
        ServiceInstance serviceInstance = this.getServiceInstance();
        DepotManager depotManager = null;
        try {
            ManagedObjectReference depotManagerRef = serviceInstance.queryDepotManager();
            depotManager = (DepotManager)this.getManagedObject(depotManagerRef);
        }
        catch (ConnectionException ex) {
            _logger.info((Object)String.format("Cannot establish connection to ImageBuilder service associated with VC with serverGuid=%s.", this._vcServiceGuid), (Throwable)ex);
        }
        return depotManager;
    }

    @Override
    public ImageBuilder getImageBuilder() {
        ServiceInstance serviceInstance = this.getServiceInstance();
        ImageBuilder imageBuilder = null;
        try {
            ManagedObjectReference imageBuilderRef = serviceInstance.queryImageBuilder();
            imageBuilder = (ImageBuilder)this.getManagedObject(imageBuilderRef);
        }
        catch (ConnectionException ex) {
            _logger.info((Object)String.format("Cannot establish connection to ImageBuilder service associated with VC with serverGuid=%s.", this._vcServiceGuid), (Throwable)ex);
        }
        return imageBuilder;
    }

    @Override
    public ImageProfileEngine getImageProfileEngine() {
        ServiceInstance serviceInstance = this.getServiceInstance();
        ImageProfileEngine imageProfileEngine = null;
        try {
            ManagedObjectReference imageProfileEngineRef = serviceInstance.queryImageProfileEngine();
            imageProfileEngine = (ImageProfileEngine)this.getManagedObject(imageProfileEngineRef);
        }
        catch (ConnectionException ex) {
            _logger.info((Object)String.format("Cannot establish connection to ImageBuilder service associated with VC with serverGuid=%s.", this._vcServiceGuid), (Throwable)ex);
        }
        return imageProfileEngine;
    }

    private <T> Class<T> getBindingClass(String managedObjectType) {
        VmodlTypeMap typeMap = VmodlTypeMap.Factory.getTypeMap();
        VmodlType vmodlType = typeMap.getVmodlType(managedObjectType);
        Class bindingClass = vmodlType.getTypeClass();
        return bindingClass;
    }

    @Override
    public void close() {
        this._client.shutdown();
    }
}

