/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.impl;

import com.google.common.collect.Sets;
import com.vmware.vim.binding.imagebuilder.DepotManager;
import com.vmware.vim.binding.imagebuilder.fault.NotFound;
import com.vmware.vim.binding.imagebuilder.pkg.ImageProfile;
import com.vmware.vim.binding.imagebuilder.pkg.VibPackageSpec;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vsphere.client.h5.autodeploy.ImageBuilderService;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.ImageBuilderServiceFactory;
import com.vmware.vsphere.client.h5.autodeploy.impl.AdDataProviderAdapterBase;
import com.vmware.vsphere.client.h5.autodeploy.impl.DerivedProperty;
import com.vmware.vsphere.client.h5.autodeploy.impl.RelatedProperty;
import com.vmware.vsphere.client.h5.autodeploy.impl.VibPackageDataProviderAdapter;
import com.vmware.vsphere.client.h5.autodeploy.util.AutoDeployUtil;
import com.vmware.vsphere.client.h5.autodeploy.util.CommonReferenceUtil;
import com.vmware.vsphere.client.h5.autodeploy.util.DepotReferenceUtil;
import com.vmware.vsphere.client.h5.autodeploy.util.ImageProfileReferenceUtil;
import com.vmware.vsphere.client.h5.autodeploy.util.VibPackageReferenceUtil;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="imagebuilder:ImageProfile")
public class ImageProfileDataProviderAdapter
extends AdDataProviderAdapterBase {
    public static final String NAME_PROPERTY = "name";
    public static final String ACCEPTANCE_LEVEL_PROPERTY = "acceptanceLevel";
    public static final String VENDOR_PROPERTY = "vendor";
    public static final String LAST_MODIFIED_PROPERTY = "lastModified";
    public static final String DESCRIPTION_PROPERY = "description";
    public static final String VIB_LIST_PROPERTY = "vibList";
    public static final String IS_EDITABLE_PROPERTY = "isEditable";
    public static final String VC_REF = "vcRef";
    public static final String DEPOT_REF = "depotRef";
    public static final String RAW_OBJECT_PROPERY = "rawObject";
    private static final Log _logger = LogFactory.getLog(ImageProfileDataProviderAdapter.class);
    private final QueryExecutor _queryExecutor;
    private final ImageBuilderServiceFactory _imageBuilderServiceFactory;
    private final ObjectReferenceService _objectReferenceService;

    protected ImageProfileInfo[] getEmptyResult() {
        return new ImageProfileInfo[0];
    }

    private static boolean shouldHandleConstraintForType(Constraint c) {
        return c.targetType == null || c.targetType.equalsIgnoreCase("imagebuilder:ImageProfile");
    }

    private static URI createImageProfileRef(URI depotRef, ImageProfile imageProfile) {
        String vcGuid = DepotReferenceUtil.getVcGuid(depotRef);
        String depotUrl = DepotReferenceUtil.getDepotUrl(depotRef);
        String imageProfileId = imageProfile.profileId;
        return ImageProfileReferenceUtil.createRef(vcGuid, depotUrl, imageProfileId);
    }

    public ImageProfileDataProviderAdapter(QueryExecutor queryExecutor, ImageBuilderServiceFactory imageBuilderServiceFactory, ObjectReferenceService objectReferenceService) {
        super(queryExecutor);
        this._queryExecutor = queryExecutor;
        this._imageBuilderServiceFactory = imageBuilderServiceFactory;
        this._objectReferenceService = objectReferenceService;
    }

    @Override
    protected Set<String> initBaseProperties() {
        return Sets.newHashSet((Object[])new String[]{NAME_PROPERTY, ACCEPTANCE_LEVEL_PROPERTY, VENDOR_PROPERTY, LAST_MODIFIED_PROPERTY, DESCRIPTION_PROPERY, VIB_LIST_PROPERTY, IS_EDITABLE_PROPERTY, VC_REF, DEPOT_REF, RAW_OBJECT_PROPERY});
    }

    @Override
    protected Map<String, DerivedProperty> initDerivedProperties() {
        HashMap<String, DerivedProperty> result = new HashMap<String, DerivedProperty>();
        return result;
    }

    @Override
    protected Map<String, RelatedProperty> initRelatedProperties() {
        HashMap<String, RelatedProperty> result = new HashMap<String, RelatedProperty>();
        result.put("grantedPrivileges", new RelatedProperty("grantedPrivileges", VC_REF));
        return result;
    }

    @Override
    protected Object[] filterObjects(RelationalConstraint c) {
        if (!ImageProfileDataProviderAdapter.shouldHandleConstraintForType((Constraint)c)) {
            return this.getEmptyResult();
        }
        if ("imageProfiles".equals(c.relation)) {
            if (!(c.constraintOnRelatedObject instanceof ObjectIdentityConstraint)) {
                return this.getEmptyResult();
            }
            ObjectIdentityConstraint oic = (ObjectIdentityConstraint)c.constraintOnRelatedObject;
            if (!this.isDepotRef(oic.target)) {
                return this.getEmptyResult();
            }
            URI depotRef = (URI)oic.target;
            String vcGuid = DepotReferenceUtil.getVcGuid(depotRef);
            String depotUrl = DepotReferenceUtil.getDepotUrl(depotRef);
            ImageBuilderService imageBuilderService = this._imageBuilderServiceFactory.getService(vcGuid);
            DepotManager depotManager = imageBuilderService.getDepotManager();
            DepotManager.ImageProfileFilterSpec imageProfileFilterSpec = AutoDeployUtil.createEmptyImageProfileFilterSpec();
            imageProfileFilterSpec.matchDepotUrl = new String[]{depotUrl};
            ImageProfile[] imageProfiles = depotManager.queryProfiles(imageProfileFilterSpec, Boolean.valueOf(true));
            if (imageProfiles == null) {
                return this.getEmptyResult();
            }
            Object[] result = new ImageProfileInfo[imageProfiles.length];
            for (int i = 0; i < imageProfiles.length; ++i) {
                result[i] = new ImageProfileInfo(depotRef, imageProfiles[i]);
            }
            return result;
        }
        return this.getEmptyResult();
    }

    @Override
    protected Object[] filterObjects(ObjectIdentityConstraint c) {
        if (!ImageProfileDataProviderAdapter.shouldHandleConstraintForType((Constraint)c)) {
            return this.getEmptyResult();
        }
        if (!this.isImageProfileRef(c.target)) {
            return this.getEmptyResult();
        }
        URI imageProfileRef = (URI)c.target;
        URI depotRef = ImageProfileReferenceUtil.getDepotRef(imageProfileRef);
        String vcGuid = ImageProfileReferenceUtil.getVcGuid(imageProfileRef);
        String depotUrl = ImageProfileReferenceUtil.getDepotUrl(imageProfileRef);
        String targetImageProfileId = ImageProfileReferenceUtil.getImageProfileId(imageProfileRef);
        ImageBuilderService imageBuilderService = this._imageBuilderServiceFactory.getService(vcGuid);
        DepotManager depotManager = imageBuilderService.getDepotManager();
        DepotManager.ImageProfileFilterSpec imageProfileFilterSpec = AutoDeployUtil.createEmptyImageProfileFilterSpec();
        imageProfileFilterSpec.matchDepotUrl = new String[]{depotUrl};
        ImageProfile[] imageProfiles = depotManager.queryProfiles(imageProfileFilterSpec, Boolean.valueOf(true));
        if (imageProfiles != null) {
            for (int i = 0; i < imageProfiles.length; ++i) {
                ImageProfile imageProfile = imageProfiles[i];
                if (!imageProfile.profileId.equals(targetImageProfileId)) continue;
                return new ImageProfileInfo[]{new ImageProfileInfo(depotRef, imageProfile)};
            }
        }
        return this.getEmptyResult();
    }

    @Override
    protected Map<String, Object[]> retrieveBaseProperties(Set<String> basePropertyNames, Object[] sourceObjectRefs) {
        assert (sourceObjectRefs instanceof ImageProfileInfo[]);
        ImageProfileInfo[] imageProfileInfos = (ImageProfileInfo[])sourceObjectRefs;
        HashMap<String, Object[]> valuesByProperty = new HashMap<String, Object[]>();
        for (String basePropertyName : basePropertyNames) {
            Object[] values = new Object[imageProfileInfos.length];
            block25: for (int i = 0; i < imageProfileInfos.length; ++i) {
                ImageProfileInfo imageProfileInfo = imageProfileInfos[i];
                ImageProfile imageProfile = imageProfileInfo.imageProfile;
                switch (basePropertyName) {
                    case "name": {
                        values[i] = imageProfile.name;
                        continue block25;
                    }
                    case "acceptanceLevel": {
                        values[i] = imageProfile.acceptanceLevel;
                        continue block25;
                    }
                    case "vendor": {
                        values[i] = imageProfile.vendor;
                        continue block25;
                    }
                    case "lastModified": {
                        values[i] = imageProfile.whenLastModified;
                        continue block25;
                    }
                    case "description": {
                        values[i] = imageProfile.description;
                        continue block25;
                    }
                    case "vibList": {
                        values[i] = this.getReferencesToVibs(imageProfile, DepotReferenceUtil.getVcGuid(imageProfileInfo.depotRef));
                        continue block25;
                    }
                    case "isEditable": {
                        values[i] = !imageProfile.read_only;
                        continue block25;
                    }
                    case "rawObject": {
                        values[i] = imageProfile;
                        continue block25;
                    }
                    case "vcRef": {
                        values[i] = DepotReferenceUtil.getVcRef(imageProfileInfo.depotRef);
                        continue block25;
                    }
                    case "depotRef": {
                        values[i] = imageProfileInfo.depotRef;
                        continue block25;
                    }
                    default: {
                        _logger.warn((Object)("Unknown ImageProfile property: " + basePropertyName));
                    }
                }
            }
            valuesByProperty.put(basePropertyName, values);
        }
        return valuesByProperty;
    }

    @Override
    protected Object sourceObjectToReference(Object sourceObject) {
        assert (sourceObject instanceof ImageProfileInfo);
        ImageProfileInfo imageProfileInfo = (ImageProfileInfo)sourceObject;
        return ImageProfileDataProviderAdapter.createImageProfileRef(imageProfileInfo.depotRef, imageProfileInfo.imageProfile);
    }

    private URI[] getReferencesToVibs(ImageProfile profile, String vcGuid) {
        VibPackageSpec[] vibs;
        DepotManager dm = this._imageBuilderServiceFactory.getService(vcGuid).getDepotManager();
        DepotManager.VibPackageFilterSpec filterSpec = VibPackageDataProviderAdapter.createEmptyVibPackageFilterSpec();
        filterSpec.matchImageProfile = new String[]{profile.profileId};
        try {
            vibs = dm.queryPackages(filterSpec);
        }
        catch (NotFound e) {
            throw new RuntimeException("Error while querying packages", e);
        }
        URI[] result = new URI[vibs.length];
        for (int i = 0; i < vibs.length; ++i) {
            result[i] = VibPackageReferenceUtil.createRef(vcGuid, vibs[i].Guid);
        }
        return result;
    }

    private boolean isDepotRef(Object object) {
        return CommonReferenceUtil.isReferenceOfType(object, "imagebuilder:Depot", this._objectReferenceService);
    }

    private boolean isImageProfileRef(Object object) {
        return CommonReferenceUtil.isReferenceOfType(object, "imagebuilder:ImageProfile", this._objectReferenceService);
    }

    private static class ImageProfileInfo {
        final URI depotRef;
        final ImageProfile imageProfile;

        ImageProfileInfo(URI depotRef, ImageProfile imageProfile) {
            this.depotRef = depotRef;
            this.imageProfile = imageProfile;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ImageProfileInfo o = (ImageProfileInfo)other;
            return this.depotRef.equals(o.depotRef) && this.imageProfile.profileId.equals(o.imageProfile.profileId);
        }

        public int hashCode() {
            return 17 * this.depotRef.hashCode() + 31 * this.imageProfile.profileId.hashCode();
        }
    }
}

