/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.impl;

import com.google.common.base.Preconditions;
import com.vmware.vim.binding.imagebuilder.DepotManager;
import com.vmware.vim.binding.imagebuilder.DepotSpec;
import com.vmware.vim.binding.imagebuilder.ImageBuilder;
import com.vmware.vim.binding.imagebuilder.ImageProfileEngine;
import com.vmware.vim.binding.imagebuilder.fault.CannotAccessFile;
import com.vmware.vim.binding.imagebuilder.fault.CannotAccessNetwork;
import com.vmware.vim.binding.imagebuilder.fault.DatabaseError;
import com.vmware.vim.binding.imagebuilder.fault.FileAlreadyExists;
import com.vmware.vim.binding.imagebuilder.fault.InvalidDepot;
import com.vmware.vim.binding.imagebuilder.fault.InvalidFormat;
import com.vmware.vim.binding.imagebuilder.fault.InvalidState;
import com.vmware.vim.binding.imagebuilder.fault.NotFound;
import com.vmware.vim.binding.imagebuilder.fault.ProfileAlreadyExists;
import com.vmware.vim.binding.imagebuilder.fault.ProfileReadOnly;
import com.vmware.vim.binding.imagebuilder.pkg.ComponentSpec;
import com.vmware.vim.binding.imagebuilder.pkg.ImageProfile;
import com.vmware.vim.binding.imagebuilder.pkg.VibPackageSpec;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vsphere.client.h5.autodeploy.ImageBuilderService;
import com.vmware.vsphere.client.h5.autodeploy.connection.impl.ImageBuilderServiceFactory;
import com.vmware.vsphere.client.h5.autodeploy.imageProfile.CreateImageProfileSpec;
import com.vmware.vsphere.client.h5.autodeploy.imageProfile.DeleteImageProfileSpec;
import com.vmware.vsphere.client.h5.autodeploy.imageProfile.EditImageProfileSpec;
import com.vmware.vsphere.client.h5.autodeploy.imageProfile.ExportImageProfileSpec;
import com.vmware.vsphere.client.h5.autodeploy.imageProfile.ImageProfileBuilder;
import com.vmware.vsphere.client.h5.autodeploy.imageProfile.ImageProfileNameValidateSpec;
import com.vmware.vsphere.client.h5.autodeploy.imageProfile.ImageProfileValidationData;
import com.vmware.vsphere.client.h5.autodeploy.imageProfile.ImageProfileVibValidationSpec;
import com.vmware.vsphere.client.h5.autodeploy.imageProfile.MoveProfileSpec;
import com.vmware.vsphere.client.h5.autodeploy.util.AutoDeployUtil;
import com.vmware.vsphere.client.h5.autodeploy.util.DepotReferenceUtil;
import com.vmware.vsphere.client.h5.autodeploy.util.ImageProfileReferenceUtil;
import java.net.URI;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageProfileMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(ImageProfileMutationProvider.class);
    private final ImageBuilderServiceFactory _ibServiceFactory;
    private final QueryExecutor _queryExecutor;

    public ImageProfileMutationProvider(ImageBuilderServiceFactory ibServiceFactory, QueryExecutor queryExecutor) {
        this._ibServiceFactory = ibServiceFactory;
        this._queryExecutor = queryExecutor;
    }

    public ValidationResult validate(ImageProfileNameValidateSpec spec) {
        ValidationResult result = new ValidationResult();
        String vcGuid = spec.vcRef.getServerGuid();
        ImageBuilderService ibService = this._ibServiceFactory.getService(vcGuid);
        DepotManager.ImageProfileFilterSpec filterSpec = AutoDeployUtil.createEmptyImageProfileFilterSpec();
        filterSpec.matchName = new String[]{spec.name};
        ImageProfile[] nameSearchResult = ibService.getDepotManager().queryProfiles(filterSpec, Boolean.valueOf(true));
        if (nameSearchResult == null) {
            result.result = true;
        } else {
            result.result = false;
            if (spec.editedProfileId != null) {
                String profileGuid = ImageProfileReferenceUtil.getImageProfileId(spec.editedProfileId);
                for (ImageProfile ip : nameSearchResult) {
                    if (!ip.profileId.equals(profileGuid)) continue;
                    result.result = true;
                    break;
                }
            }
        }
        return result;
    }

    public ValidationResult validate(ImageProfileVibValidationSpec spec) {
        ValidationResult result = new ValidationResult();
        ImageProfile p = this.constructImageProfile(spec);
        ImageProfileEngine ipe = this._ibServiceFactory.getService(spec.vcRef.getServerGuid()).getImageProfileEngine();
        try {
            ImageProfileEngine.Problem[] issues = ipe.validate(p, ImageProfileMutationProvider.getDefaultValidationOptions());
            result.result = ImageProfileMutationProvider.transformValidationData(issues);
        }
        catch (NotFound e) {
            result.error = e;
        }
        assert (result.result == null ^ result.error == null);
        return result;
    }

    public OperationResult add(CreateImageProfileSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = spec.depot;
        String vcGuid = DepotReferenceUtil.getVcGuid(spec.depot);
        ImageProfile profileToAdd = this.constructImageProfile(spec);
        DepotManager dm = this._ibServiceFactory.getService(vcGuid).getDepotManager();
        DepotSpec targetDepotSpec = AutoDeployUtil.findDepotSpec(dm, DepotReferenceUtil.getDepotUrl(spec.depot));
        try {
            ImageProfile addedProfile = dm.addProfile(profileToAdd, targetDepotSpec, Boolean.valueOf(false));
            result.result = ImageProfileReferenceUtil.createRef(vcGuid, targetDepotSpec.depotIndexUrl, addedProfile.profileId);
        }
        catch (DatabaseError | InvalidDepot | ProfileAlreadyExists e) {
            result.error = e;
        }
        return result;
    }

    public OperationResult apply(URI imageProfile, EditImageProfileSpec spec) {
        ImageProfile existingProfile;
        OperationResult result = new OperationResult();
        result.entity = imageProfile;
        String vcGuid = ImageProfileReferenceUtil.getVcGuid(imageProfile);
        DepotManager dm = this._ibServiceFactory.getService(vcGuid).getDepotManager();
        try {
            existingProfile = (ImageProfile)this._queryExecutor.getProperty((Object)imageProfile, "rawObject");
        }
        catch (Exception e) {
            result.error = e;
            return result;
        }
        ImageProfile editedProfile = this.constructImageProfile(existingProfile, spec);
        URI profileLocation = ImageProfileReferenceUtil.getDepotRef(imageProfile);
        assert (profileLocation != null);
        DepotSpec depotSpec = AutoDeployUtil.findDepotSpec(dm, DepotReferenceUtil.getDepotUrl(profileLocation));
        try {
            dm.addProfile(editedProfile, depotSpec, Boolean.valueOf(true));
        }
        catch (DatabaseError | InvalidDepot | ProfileAlreadyExists e) {
            result.error = e;
            result.result = false;
            return result;
        }
        result.result = true;
        return result;
    }

    public OperationResult apply(URI imageProfile, MoveProfileSpec spec) {
        OperationResult result = new OperationResult();
        String vcGuid = ImageProfileReferenceUtil.getVcGuid(imageProfile);
        String profileId = ImageProfileReferenceUtil.getImageProfileId(imageProfile);
        String originalDepotUrl = ImageProfileReferenceUtil.getDepotUrl(imageProfile);
        DepotManager dm = this._ibServiceFactory.getService(vcGuid).getDepotManager();
        DepotSpec newDepot = AutoDeployUtil.findDepotSpec(dm, DepotReferenceUtil.getDepotUrl(spec.targetDepot));
        try {
            dm.moveImageProfile(profileId, newDepot);
        }
        catch (InvalidDepot | NotFound | ProfileReadOnly e) {
            result.entity = imageProfile;
            result.error = e;
            result.result = null;
            return result;
        }
        result.entity = DepotReferenceUtil.createRef(vcGuid, originalDepotUrl);
        result.result = ImageProfileReferenceUtil.createRef(vcGuid, newDepot.depotIndexUrl, profileId);
        return result;
    }

    public OperationResult apply(URI imageProfile, ExportImageProfileSpec spec) {
        ImageProfile profile;
        OperationResult result = new OperationResult();
        Preconditions.checkNotNull((Object)((Object)spec.exportedImageType));
        ImageBuilderService ibs = this._ibServiceFactory.getService(ImageProfileReferenceUtil.getVcGuid(imageProfile));
        DepotManager dm = ibs.getDepotManager();
        DepotManager.ImageProfileFilterSpec filterSpec = AutoDeployUtil.createEmptyImageProfileFilterSpec();
        filterSpec.matchGuid = new String[]{ImageProfileReferenceUtil.getImageProfileId(imageProfile)};
        try {
            profile = dm.queryProfiles(filterSpec, Boolean.valueOf(false))[0];
        }
        catch (Exception e) {
            result.error = e;
            return result;
        }
        try {
            if (spec.exportedImageType == ExportImageProfileSpec.ImageType.ISO) {
                ImageBuilder ib = ibs.getImageBuilder();
                ImageBuilder.IsoCustomisationSpec isoSpec = new ImageBuilder.IsoCustomisationSpec();
                isoSpec.force = false;
                isoSpec.noinstaller = spec.skipInstaller;
                isoSpec.noacceptancecheck = spec.skipAcceptanceCheck;
                result.task = ib.createIso(profile, isoSpec);
            } else if (spec.exportedImageType == ExportImageProfileSpec.ImageType.ZIP) {
                ImageProfileEngine ipe = ibs.getImageProfileEngine();
                ImageProfileEngine.BundleExportCustomisationSpec bundleSpec = new ImageProfileEngine.BundleExportCustomisationSpec();
                bundleSpec.force = false;
                bundleSpec.noacceptancecheck = spec.skipAcceptanceCheck;
                result.task = ipe.exportProfile(profile, bundleSpec);
            }
        }
        catch (CannotAccessFile | CannotAccessNetwork | FileAlreadyExists | InvalidFormat | InvalidState | NotFound e) {
            result.error = e;
        }
        assert (result.task != null ^ result.error != null);
        return result;
    }

    public OperationResult remove(URI imageProfile, DeleteImageProfileSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = imageProfile;
        String vcGuid = ImageProfileReferenceUtil.getVcGuid(imageProfile);
        DepotManager dm = this._ibServiceFactory.getService(vcGuid).getDepotManager();
        try {
            dm.removeProfile(ImageProfileReferenceUtil.getImageProfileId(imageProfile));
            result.result = true;
        }
        catch (NotFound | ProfileReadOnly e) {
            result.result = false;
            result.error = e;
        }
        return result;
    }

    private ImageProfile constructImageProfile(ImageProfileVibValidationSpec s) {
        ComponentSpec[] vibList = this.retrieveVibs(s.vibList);
        ImageProfileBuilder builder = new ImageProfileBuilder();
        builder.acceptanceLevel(s.profileAcceptanceLevel.name()).vibList(vibList);
        return builder.build();
    }

    private ImageProfile constructImageProfile(CreateImageProfileSpec s) {
        ImageProfileBuilder builder = new ImageProfileBuilder();
        ComponentSpec[] vibList = this.retrieveVibs(s.vibList);
        builder.name(s.name).vendor(s.vendor).description(s.description).acceptanceLevel(s.acceptanceLevel.name()).vibList(vibList);
        return builder.build();
    }

    private ImageProfile constructImageProfile(ImageProfile existingProfile, EditImageProfileSpec s) {
        ImageProfileBuilder builder = new ImageProfileBuilder(existingProfile);
        ComponentSpec[] vibList = this.retrieveVibs(s.vibList);
        builder.name(s.name).vendor(s.vendor).description(s.description).acceptanceLevel(s.acceptanceLevel.name()).vibList(vibList);
        return builder.build();
    }

    private ComponentSpec[] retrieveVibs(URI[] refs) {
        PropertyValue[] queryResults = null;
        try {
            queryResults = this._queryExecutor.getProperty((Object[])refs, "rawObject");
        }
        catch (Exception e) {
            _logger.error((Object)"Unable to retrieve software packages", (Throwable)e);
            return null;
        }
        if (queryResults == null || queryResults.length != refs.length) {
            return null;
        }
        ComponentSpec[] result = new ComponentSpec[refs.length];
        for (int i = 0; i < refs.length; ++i) {
            assert ("rawObject".equals(queryResults[i].propertyName));
            result[i] = (VibPackageSpec)queryResults[i].value;
        }
        return result;
    }

    private static ImageProfileEngine.ValidationOptionsSpec getDefaultValidationOptions() {
        ImageProfileEngine.ValidationOptionsSpec result = new ImageProfileEngine.ValidationOptionsSpec();
        return result;
    }

    private static ImageProfileValidationData transformValidationData(ImageProfileEngine.Problem[] problems) {
        ImageProfileValidationData result = new ImageProfileValidationData();
        if (problems == null) {
            return result;
        }
        ArrayList<String> notBootable = new ArrayList<String>();
        ArrayList<String> packageDependencies = new ArrayList<String>();
        ArrayList<String> packageConflicts = new ArrayList<String>();
        ArrayList<String> packageObsoletions = new ArrayList<String>();
        ArrayList<String> acceptanceLevel = new ArrayList<String>();
        ArrayList<String> extensibilityRules = new ArrayList<String>();
        ArrayList<String> overlayProblems = new ArrayList<String>();
        for (ImageProfileEngine.Problem p : problems) {
            if (p instanceof ImageProfileEngine.ProfileNotBootable) {
                notBootable.add(p.getMessage());
                continue;
            }
            if (p instanceof ImageProfileEngine.MissingDependency) {
                packageDependencies.add(p.getMessage());
                continue;
            }
            if (p instanceof ImageProfileEngine.PackageConflicts) {
                packageConflicts.add(p.getMessage());
                continue;
            }
            if (p instanceof ImageProfileEngine.PackageObsoleted) {
                packageObsoletions.add(p.getMessage());
                continue;
            }
            if (p instanceof ImageProfileEngine.BadAcceptanceLevel) {
                acceptanceLevel.add(p.getMessage());
                continue;
            }
            if (p instanceof ImageProfileEngine.ExtensibilityRuleViolation) {
                extensibilityRules.add(p.getMessage());
                continue;
            }
            if (!(p instanceof ImageProfileEngine.FileConflicts)) continue;
            overlayProblems.add(p.getMessage());
        }
        result.notBootableMessages = notBootable.toArray(new String[0]);
        result.dependenciesUnfulfilled = packageDependencies.toArray(new String[0]);
        result.packageConflicts = packageConflicts.toArray(new String[0]);
        result.packageObsoletions = packageObsoletions.toArray(new String[0]);
        result.acceptanceLevelProblems = acceptanceLevel.toArray(new String[0]);
        result.extensibilityProblems = extensibilityRules.toArray(new String[0]);
        result.overlayProblems = overlayProblems.toArray(new String[0]);
        return result;
    }
}

