/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.autodeploy.util;

import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class CommonReferenceUtil {
    public static boolean isReferenceOfType(Object ref, String type, ObjectReferenceService objectReferenceService) {
        assert (type != null);
        if (ref == null || !(ref instanceof URI)) {
            return false;
        }
        String uriType = objectReferenceService.getResourceObjectType(ref);
        return type.equals(uriType);
    }

    public static String getIdSegmentDecoded(URI uri, int idSegmentIndex) {
        assert (uri != null);
        String[] segments = DefaultUriSchemeUtil.getIdSegments((URI)uri);
        if (segments.length <= idSegmentIndex) {
            return null;
        }
        return CommonReferenceUtil.decodeString(segments[idSegmentIndex]);
    }

    public static String decodeString(String str) {
        if (str == null || str.equals("null")) {
            return null;
        }
        try {
            return URLDecoder.decode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String encodeString(String str) {
        if (str == null) {
            return "null";
        }
        try {
            return URLEncoder.encode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

