/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.af.interop;

import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.WinReg;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.SystemUtils;

public abstract class NativeAdapter {
    private static boolean winRegistryValueExists(String key, String value) {
        return Advapi32Util.registryKeyExists(WinReg.HKEY_LOCAL_MACHINE, key) && Advapi32Util.registryValueExists(WinReg.HKEY_LOCAL_MACHINE, key, value);
    }

    static {
        String propName = "jna.library.path";
        String LINUX_VMDIR_LIB64_PATH = "/usr/lib/vmware-vmafd/lib64";
        String LINUX_LIKEWISE_LIB64_PATH = "/opt/likewise/lib64";
        String WIN_REG_VMDIR_PATH = "SOFTWARE\\VMWare, Inc.\\VMware Directory Services";
        String WIN_REG_VMAFD_PATH = "SOFTWARE\\VMWare, Inc.\\VMware afd Services";
        String WIN_REG_INSTALL_KEY = "InstallPath";
        String WIN_VMWARE_CIS_VMDIRD_PATH = "C:" + File.separator + "Program Files" + File.separator + "VMware" + File.separator + "CIS" + File.separator + "vmdird";
        String WIN_VMWARE_CIS_VMAFD_PATH = "C:" + File.separator + "Program Files" + File.separator + "VMware" + File.separator + "CIS" + File.separator + "vmafdd";
        List<String> paths = null;
        if (SystemUtils.IS_OS_LINUX) {
            paths = Arrays.asList("/usr/lib/vmware-vmafd/lib64", "/opt/likewise/lib64");
        } else if (SystemUtils.IS_OS_WINDOWS) {
            if (NativeAdapter.winRegistryValueExists("SOFTWARE\\VMWare, Inc.\\VMware Directory Services", "InstallPath")) {
                WIN_VMWARE_CIS_VMDIRD_PATH = Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, "SOFTWARE\\VMWare, Inc.\\VMware Directory Services", "InstallPath");
            }
            if (NativeAdapter.winRegistryValueExists("SOFTWARE\\VMWare, Inc.\\VMware afd Services", "InstallPath")) {
                WIN_VMWARE_CIS_VMAFD_PATH = Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, "SOFTWARE\\VMWare, Inc.\\VMware afd Services", "InstallPath");
            }
            paths = Arrays.asList(WIN_VMWARE_CIS_VMDIRD_PATH, WIN_VMWARE_CIS_VMAFD_PATH);
        } else {
            throw new IllegalStateException("Only Windows and Linux platforms are supported");
        }
        for (String pathString : paths) {
            Path path = Paths.get(pathString, new String[0]);
            if (!Files.notExists(path, new LinkOption[0])) continue;
            throw new IllegalStateException("Path \"" + pathString + "\" does not exist");
        }
        String propValue = System.getProperty("jna.library.path");
        StringBuilder jnalibpath = new StringBuilder(propValue == null ? "" : propValue);
        for (String path : paths) {
            File libDir = new File(path);
            if (!libDir.exists() || !libDir.isDirectory()) continue;
            if (jnalibpath.length() > 0) {
                jnalibpath.append(File.pathSeparator);
            }
            jnalibpath.append(path);
        }
        propValue = jnalibpath.substring(0);
        if (!propValue.isEmpty()) {
            System.setProperty("jna.library.path", propValue);
        }
    }
}

