/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.hardware.ciminfo;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateParserAndFormatter {
    private static final Log logger = LogFactory.getLog(DateParserAndFormatter.class);
    private static final String INPUT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String OUTPUT_DATE_FORMAT = "MM/dd/yyyy hh:mm aa";
    private final String rawTimestamp;

    public DateParserAndFormatter(String rawTimestamp) {
        this.rawTimestamp = rawTimestamp;
    }

    public String parseAndFormat() {
        Date parsedDate = this.parseRawTimestamp(this.rawTimestamp);
        String formattedTime = this.formatTimestamp(parsedDate);
        return formattedTime != null ? formattedTime : this.rawTimestamp;
    }

    public long getTimestamp() {
        Date parsedDate = this.parseRawTimestamp(this.rawTimestamp);
        return parsedDate.getTime();
    }

    private Date parseRawTimestamp(String rawTimestamp) {
        SimpleDateFormat inputFormat = new SimpleDateFormat(INPUT_DATE_FORMAT);
        Date parsedDate = null;
        try {
            parsedDate = inputFormat.parse(rawTimestamp);
        }
        catch (ParseException e) {
            logger.warn((Object)("Failed to parse date: " + rawTimestamp), (Throwable)e);
        }
        return parsedDate;
    }

    private String formatTimestamp(Date parsedDate) {
        SimpleDateFormat outputFormat = new SimpleDateFormat(OUTPUT_DATE_FORMAT);
        return parsedDate != null ? outputFormat.format(parsedDate) : null;
    }
}

