/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.hardware.ciminfo;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.HostCimInfoXmlReader;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.SensorFactory;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.ServiceEventLogFactory;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.HostCimData;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HostCimInfoPropertyProvider
implements PropertyProviderBean {
    private static final Log logger = LogFactory.getLog(HostCimInfoPropertyProvider.class);
    private QueryExecutor _queryExecutor;

    public HostCimInfoPropertyProvider(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    @type(value="HostSystem")
    public HostCimData getHardwareStatus(ManagedObjectReference hostRef) throws Exception {
        String rawCimXmlData = this.getHardwareStatusData(hostRef);
        HostCimData cimData = null;
        if (rawCimXmlData != null) {
            HostCimInfoXmlReader reader = new HostCimInfoXmlReader(rawCimXmlData, new SensorFactory(), new ServiceEventLogFactory());
            cimData = reader.parse();
        }
        return cimData;
    }

    @type(value="HostSystem")
    public String getHardwareStatusXml(ManagedObjectReference hostRef) throws Exception {
        String rawCimXmlData = this.getHardwareStatusData(hostRef);
        Document document = this.parseAndNormalizeXml(rawCimXmlData);
        String xmlString = this.transformAndFormatXmlToString(document);
        return xmlString;
    }

    private String getHardwareStatusData(ManagedObjectReference hostRef) throws Exception {
        OperationResult operationResult = this.getHardwareStatusOperationResult(hostRef);
        String rawCimXmlData = "";
        if (operationResult == null || operationResult.error != null || operationResult.result == null) {
            logger.error((Object)"Cannot read cim host data.");
        } else {
            rawCimXmlData = (String)operationResult.result;
        }
        return rawCimXmlData;
    }

    private OperationResult getHardwareStatusOperationResult(ManagedObjectReference hostRef) throws Exception {
        PropertyValue[] response = this._queryExecutor.getProperty(new Object[]{hostRef}, "cimHostData");
        return (OperationResult)response[0].value;
    }

    private Document parseAndNormalizeXml(String rawCimXmlData) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(rawCimXmlData)));
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = (NodeList)xPath.evaluate("//text()[normalize-space()='']", document, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            node.getParentNode().removeChild(node);
        }
        return document;
    }

    private String transformAndFormatXmlToString(Document document) throws TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        StreamResult result = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(document);
        transformer.transform(source, result);
        return result.getWriter().toString();
    }
}

