/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.hardware.ciminfo.impl;

import com.vmware.vim.binding.vim.host.BIOSInfo;
import com.vmware.vim.binding.vim.host.HealthStatusSystem;
import com.vmware.vim.binding.vim.host.NumericSensorInfo;
import com.vmware.vim.binding.vim.host.SystemEventInfo;
import com.vmware.vim.binding.vim.host.SystemIdentificationInfo;
import com.vmware.vim.binding.vim.host.SystemInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.CimMessageReader;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.DateParserAndFormatter;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.BiosData;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.ChassisData;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.HealthStatus;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.HostCimData;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.HostHardwareHealthData;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.Sensor;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.SensorComparator;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.SystemEventData;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.details.SensorValueParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostHardwareHealthUtil {
    private static final String SERVICE_TAG = "ServiceTag";
    private static final String ASSET_TAG = "AssetTag";
    private static final String ASSET_TAG_REPORTING_STRING = "Asset Tag: ";
    private static final String NAME_DELIM = "---";
    private static final Log logger = LogFactory.getLog(HostHardwareHealthUtil.class);
    private static final Map<String, String> baseUnitsMap = new HashMap<String, String>();
    private static final Map<String, String> rateUnitsMap = new HashMap<String, String>();

    static HostCimData createHostCimData(HostHardwareHealthData hostHardwareHealthData) {
        HostCimData hostCimData = new HostCimData();
        hostCimData.bios = HostHardwareHealthUtil.createBiosData(hostHardwareHealthData.biosInfo);
        hostCimData.chassis = HostHardwareHealthUtil.createChassisData(hostHardwareHealthData.systemInfo);
        HashMap<Long, Long> sensorNumberSelCountMap = new HashMap<Long, Long>();
        hostCimData.systemEventLog = HostHardwareHealthUtil.createSystemEventLog(hostHardwareHealthData.healthStatusSystem, sensorNumberSelCountMap);
        hostCimData.sensors = HostHardwareHealthUtil.buildSensors(hostHardwareHealthData.numericSensorsInfo, hostCimData, sensorNumberSelCountMap, (ManagedObjectReference)hostHardwareHealthData.provider);
        return hostCimData;
    }

    private static BiosData createBiosData(BIOSInfo biosInfo) {
        BiosData biosData = new BiosData();
        if (biosInfo != null) {
            biosData.manufacturer = biosInfo.getVendor();
            biosData.version = biosInfo.getBiosVersion();
        }
        return biosData;
    }

    private static List<ChassisData> createChassisData(SystemInfo systemInfo) {
        ChassisData chassisData = new ChassisData();
        chassisData.model = systemInfo.getModel();
        chassisData.tag = systemInfo.getUuid();
        Object[] sysIdentificationInfos = systemInfo.getOtherIdentifyingInfo();
        if (ArrayUtils.isNotEmpty((Object[])sysIdentificationInfos)) {
            for (Object sysIdentificationInfo : sysIdentificationInfos) {
                if (SERVICE_TAG.equalsIgnoreCase(((SystemIdentificationInfo)sysIdentificationInfo).identifierType.getKey())) {
                    chassisData.serialNumber = sysIdentificationInfo.getIdentifierValue();
                    continue;
                }
                if (!ASSET_TAG.equalsIgnoreCase(((SystemIdentificationInfo)sysIdentificationInfo).identifierType.getKey())) continue;
                chassisData.otherInfo = ASSET_TAG_REPORTING_STRING + sysIdentificationInfo.getIdentifierValue();
            }
        }
        return Collections.singletonList(chassisData);
    }

    private static List<SystemEventData> createSystemEventLog(ManagedObjectReference healthStatusSystemRef, Map<Long, Long> sensorNumberSelCountMap) {
        ArrayList<SystemEventData> systemEventLog = new ArrayList<SystemEventData>();
        try {
            HealthStatusSystem healthStatusSystem = (HealthStatusSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)healthStatusSystemRef);
            Object[] hostSystemEventInfo = healthStatusSystem.FetchSystemEventLog();
            if (ArrayUtils.isNotEmpty((Object[])hostSystemEventInfo)) {
                for (Object sysEventInfo : hostSystemEventInfo) {
                    String id = String.valueOf(sysEventInfo.getSelType());
                    String message = sysEventInfo.getMessage();
                    String rawTimestamp = sysEventInfo.getWhen();
                    String formattedTimestamp = new DateParserAndFormatter(rawTimestamp).parseAndFormat();
                    HostHardwareHealthUtil.updateSensorNumberSelCount(sensorNumberSelCountMap, (SystemEventInfo)sysEventInfo);
                    SystemEventData systemEventData = new SystemEventData(id, message, formattedTimestamp);
                    systemEventLog.add(systemEventData);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"Can't get system event log data", (Throwable)e);
        }
        return systemEventLog;
    }

    private static void updateSensorNumberSelCount(Map<Long, Long> sensorNumberSelCountMap, SystemEventInfo sysEventInfo) {
        Long sensorNumber = sysEventInfo.getSensorNumber();
        Long sensorNumberSelCount = sensorNumberSelCountMap.get(sensorNumber);
        if (sensorNumberSelCount == null) {
            sensorNumberSelCount = 0L;
        }
        Long l = sensorNumberSelCount;
        Long l2 = sensorNumberSelCount = Long.valueOf(sensorNumberSelCount + 1L);
        sensorNumberSelCountMap.put(sensorNumber, sensorNumberSelCount);
    }

    private static List<Sensor> buildSensors(NumericSensorInfo[] numericSensorsInfo, HostCimData hostCimData, Map<Long, Long> sensorNumberSelCountMap, ManagedObjectReference hostRef) {
        ArrayList<Sensor> sensors = null;
        boolean is66VcOrLater = VcServiceUtil.is66VcOrLaterByServerGuid((String)hostRef.getServerGuid());
        if (ArrayUtils.isNotEmpty((Object[])numericSensorsInfo)) {
            sensors = new ArrayList<Sensor>(numericSensorsInfo.length);
            int id = 0;
            for (NumericSensorInfo sensorInfo : numericSensorsInfo) {
                Sensor sensor = new Sensor();
                sensor.id = Integer.toString(id);
                sensor.sensorId = sensorInfo.getId();
                sensor.sensorType = StringUtils.capitalize((String)sensorInfo.getSensorType());
                String name = sensorInfo.getName();
                if (name.contains(NAME_DELIM)) {
                    String[] nameArr = name.split(NAME_DELIM);
                    name = nameArr[0].trim();
                }
                sensor.name = name;
                sensor.healthStatus = HostHardwareHealthUtil.getHealthState(sensorInfo);
                String reading = Long.valueOf(sensorInfo.getCurrentReading()).toString();
                String baseUnit = HostHardwareHealthUtil.parseBaseUnitLabel(HostHardwareHealthUtil.baseUnitsToUI(sensorInfo.getBaseUnits()));
                String rateUnit = HostHardwareHealthUtil.parseRateUnitLabel(HostHardwareHealthUtil.rateUnitsToUI(sensorInfo.getRateUnits()));
                String modifier = Integer.valueOf(sensorInfo.getUnitModifier()).toString();
                sensor.reading = HostHardwareHealthUtil.convertValue(reading, baseUnit, rateUnit, modifier);
                String timestamp = sensorInfo.getTimeStamp();
                if (timestamp != null) {
                    sensor.timestamp = new DateParserAndFormatter(sensorInfo.getTimeStamp()).getTimestamp();
                }
                sensor.selEntries = HostHardwareHealthUtil.getSelEntriesCount(sensorInfo, sensorNumberSelCountMap, is66VcOrLater);
                sensors.add(sensor);
                if (sensor.hasWarning()) {
                    ++hostCimData.sensorCounts.warnings;
                } else if (sensor.hasAlert()) {
                    ++hostCimData.sensorCounts.alerts;
                }
                ++hostCimData.sensorCounts.all;
                if (!sensor.healthStatus.isNormal()) {
                    hostCimData.alertsAndWarnings.add(sensor);
                }
                ++id;
            }
            Collections.sort(sensors, new SensorComparator());
        }
        return sensors;
    }

    private static Long getSelEntriesCount(NumericSensorInfo sensorInfo, Map<Long, Long> sensorNumberSelCountMap, boolean is66VcOrLater) {
        String sensorNumber;
        Long selEntriesCount;
        String[] sensorIdParts;
        if (is66VcOrLater) {
            Long selEntriesCount2 = sensorNumberSelCountMap.get(sensorInfo.getSensorNumber());
            if (selEntriesCount2 != null) {
                return selEntriesCount2;
            }
        } else if (sensorInfo.getId() != null && (sensorIdParts = sensorInfo.getId().split("\\.")).length > 0 && (selEntriesCount = sensorNumberSelCountMap.get(Long.valueOf(sensorNumber = sensorIdParts[sensorIdParts.length - 1]))) != null) {
            return selEntriesCount;
        }
        return 0L;
    }

    private static String baseUnitsToUI(String unit) {
        String baseUnitKey = baseUnitsMap.get(unit.toLowerCase());
        if (baseUnitKey == null) {
            baseUnitKey = "0";
        }
        return baseUnitKey;
    }

    private static String rateUnitsToUI(String unit) {
        if (unit == null) {
            return "";
        }
        String rateUnitKey = rateUnitsMap.get(unit.toLowerCase());
        if (rateUnitKey == null) {
            rateUnitKey = "0";
        }
        return rateUnitKey;
    }

    private static HealthStatus getHealthState(NumericSensorInfo sensor) {
        if (sensor == null || sensor.getHealthState() == null || sensor.getHealthState().getKey() == null) {
            return HealthStatus.HEALTH_STATUS_UNKNOWN;
        }
        String healthState = sensor.getHealthState().getKey();
        if (healthState.equalsIgnoreCase(NumericSensorInfo.HealthState.green.name())) {
            return HealthStatus.HEALTH_STATUS_OK;
        }
        if (healthState.equalsIgnoreCase(NumericSensorInfo.HealthState.yellow.name())) {
            return HealthStatus.HEALTH_STATUS_WARNING;
        }
        if (healthState.equalsIgnoreCase(NumericSensorInfo.HealthState.red.name())) {
            return HealthStatus.HEALTH_STATUS_ALERT;
        }
        return HealthStatus.HEALTH_STATUS_UNKNOWN;
    }

    public static String convertValue(String value, String baseUnit, String rateUnit, String modifier) {
        String newValue = new SensorValueParser().parseValueWithModifier(value, modifier);
        newValue = newValue + (StringUtils.isNotEmpty((String)baseUnit) ? " " + baseUnit : "");
        newValue = newValue + (StringUtils.isNotEmpty((String)rateUnit) ? " " + rateUnit : "");
        return newValue;
    }

    public static String parseBaseUnitLabel(String value) {
        return CimMessageReader.getName("baseunits_" + value);
    }

    public static String parseRateUnitLabel(String value) {
        return CimMessageReader.getName("rateunits_" + value);
    }

    static {
        baseUnitsMap.put("", "");
        baseUnitsMap.put("degrees c", "2");
        baseUnitsMap.put("degrees f", "3");
        baseUnitsMap.put("degrees k", "4");
        baseUnitsMap.put("volts", "5");
        baseUnitsMap.put("amps", "6");
        baseUnitsMap.put("watts", "7");
        baseUnitsMap.put("rpm", "19");
        baseUnitsMap.put("joules", "8");
        baseUnitsMap.put("coulombs", "9");
        baseUnitsMap.put("va", "10");
        baseUnitsMap.put("percentage", "65");
        baseUnitsMap.put("nits", "11");
        baseUnitsMap.put("lumen", "12");
        baseUnitsMap.put("lux", "13");
        baseUnitsMap.put("candela", "14");
        baseUnitsMap.put("kpa", "15");
        baseUnitsMap.put("psi", "16");
        baseUnitsMap.put("newton", "17");
        baseUnitsMap.put("cfm", "18");
        baseUnitsMap.put("hz", "20");
        baseUnitsMap.put("microsecond", "");
        baseUnitsMap.put("millisecond", "");
        baseUnitsMap.put("second", "21");
        baseUnitsMap.put("minute", "22");
        baseUnitsMap.put("hour", "23");
        baseUnitsMap.put("day", "24");
        baseUnitsMap.put("week", "25");
        baseUnitsMap.put("mil", "26");
        baseUnitsMap.put("inches", "27");
        baseUnitsMap.put("feet", "28");
        baseUnitsMap.put("cu in", "29");
        baseUnitsMap.put("cu feet", "30");
        baseUnitsMap.put("mm", "");
        baseUnitsMap.put("cm", "");
        baseUnitsMap.put("m", "31");
        baseUnitsMap.put("cu cm", "");
        baseUnitsMap.put("cu m", "33");
        baseUnitsMap.put("liters", "34");
        baseUnitsMap.put("fluid ounce", "35");
        baseUnitsMap.put("radians", "36");
        baseUnitsMap.put("steradians", "37");
        baseUnitsMap.put("revolutions", "38");
        baseUnitsMap.put("cycles", "39");
        baseUnitsMap.put("gravities", "40");
        baseUnitsMap.put("ounce", "41");
        baseUnitsMap.put("pound", "42");
        baseUnitsMap.put("ft-lb", "43");
        baseUnitsMap.put("oz-in", "44");
        baseUnitsMap.put("gauss", "45");
        baseUnitsMap.put("gilberts", "46");
        baseUnitsMap.put("henry", "47");
        baseUnitsMap.put("millihenry", "");
        baseUnitsMap.put("farad", "48");
        baseUnitsMap.put("microfarad", "");
        baseUnitsMap.put("ohms", "59");
        baseUnitsMap.put("siemens", "50");
        baseUnitsMap.put("mole", "51");
        baseUnitsMap.put("becquerel", "52");
        baseUnitsMap.put("ppm", "53");
        baseUnitsMap.put("reserved", "");
        baseUnitsMap.put("decibels", "54");
        baseUnitsMap.put("dba", "55");
        baseUnitsMap.put("dbc", "56");
        baseUnitsMap.put("gray", "57");
        baseUnitsMap.put("sievert", "58");
        baseUnitsMap.put("color temp deg k", "59");
        baseUnitsMap.put("bit", "60");
        baseUnitsMap.put("kilobit", "");
        baseUnitsMap.put("megabit", "");
        baseUnitsMap.put("gigabit", "");
        baseUnitsMap.put("byte", "61");
        baseUnitsMap.put("kilobyte", "");
        baseUnitsMap.put("megabyte", "");
        baseUnitsMap.put("gigabyte", "");
        baseUnitsMap.put("word", "62");
        baseUnitsMap.put("dword", "63");
        baseUnitsMap.put("qword", "64");
        baseUnitsMap.put("line", "");
        baseUnitsMap.put("hit", "");
        baseUnitsMap.put("miss", "");
        baseUnitsMap.put("retry", "");
        baseUnitsMap.put("reset", "");
        baseUnitsMap.put("overflow", "");
        baseUnitsMap.put("underrun", "");
        baseUnitsMap.put("collision", "");
        baseUnitsMap.put("packets", "");
        baseUnitsMap.put("messages", "");
        baseUnitsMap.put("characters", "");
        baseUnitsMap.put("error", "");
        baseUnitsMap.put("correctable error", "");
        baseUnitsMap.put("uncorrectable error", "");
        rateUnitsMap.put("", "");
        rateUnitsMap.put("per microsecond", "1");
        rateUnitsMap.put("per millisecond", "2");
        rateUnitsMap.put("per second", "3");
        rateUnitsMap.put("per minute", "4");
        rateUnitsMap.put("per hour", "5");
        rateUnitsMap.put("per day", "6");
        rateUnitsMap.put("per week", "7");
        rateUnitsMap.put("per month", "8");
        rateUnitsMap.put("per year", "9");
    }
}

