/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.details;

import com.vmware.vsphere.client.h5.host.hardware.ciminfo.CimMessageReader;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.model.SensorDetails;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.details.SensorDetailsFactory;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.details.SensorUnitParser;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.details.SensorValueParser;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.types.SensorConstants;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Node;

abstract class AbstractSensorDetailsFactory
implements SensorDetailsFactory {
    protected final Node node;
    protected final SensorValueParser valueParser;
    protected final SensorUnitParser unitParser;

    AbstractSensorDetailsFactory(Node node) {
        this.node = node;
        this.valueParser = new SensorValueParser();
        this.unitParser = new SensorUnitParser();
    }

    @Override
    public SensorDetails parseDetails() {
        String label = this.parseAndFormatLabel();
        String value = this.parseAndFormatValue();
        return new SensorDetails(label, value);
    }

    private String parseAndFormatLabel() {
        String labelKey = this.parseFullLabelKey();
        return CimMessageReader.getLabel(labelKey, this.getPropertyLabel());
    }

    private String parseAndFormatValue() {
        String rawValue = this.parseValue();
        String valueUnit = this.parseUnitKey();
        return this.returnValidValueOrEmptyString(rawValue, valueUnit);
    }

    protected String parseFullLabelKey() {
        String typePrefixLabel = this.getTypePrefix();
        String classLabel = this.getClassLabel();
        String propertyLabel = this.getPropertyLabel();
        return this.createFullLabelKey(typePrefixLabel, classLabel, propertyLabel);
    }

    protected abstract String getPropertyLabel();

    protected abstract String parseValue();

    protected abstract String parseUnitKey();

    protected abstract String getTypePrefix();

    protected abstract String getClassLabel();

    private String returnValidValueOrEmptyString(String rawValue, String valueUnit) {
        if (StringUtils.isNotEmpty((String)rawValue)) {
            return CimMessageReader.getMessage("quantityFormat", rawValue, valueUnit);
        }
        return CimMessageReader.getMessage("quantityFormatNone");
    }

    private String createFullLabelKey(String typePrefixLabel, String classLabel, String propertyLabel) {
        String fullLabel = SensorConstants.Details.CURRENT_STATE.getLabel().equals(propertyLabel) ? SensorConstants.Details.CURRENT_STATE.getLabel() : typePrefixLabel + "_" + classLabel + "_" + propertyLabel;
        return fullLabel;
    }
}

