/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.details;

import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.details.DefaultSensorDetailsFactory;
import com.vmware.vsphere.client.h5.host.hardware.ciminfo.sensors.types.SensorConstants;
import org.w3c.dom.Node;

class NetworkSensorDetailsFactory
extends DefaultSensorDetailsFactory {
    private static final String NETWORK_LABEL_PREFIX = "network";

    NetworkSensorDetailsFactory(Node node) {
        super(node);
    }

    @Override
    protected String parseValue() {
        String parsedValue;
        String propertyLabel = this.getPropertyLabel();
        SensorConstants.Details property = SensorConstants.Details.findByLabel(propertyLabel);
        String rawValue = super.parseValue();
        switch (property) {
            case ENABLED_STATE: {
                String prefix = SensorConstants.Details.ENABLED_STATE.getLabel();
                parsedValue = this.valueParser.parseKeyValue(prefix, rawValue);
                break;
            }
            case NETWORK_ADDRESS: {
                parsedValue = this.valueParser.parseMacAddresses(rawValue);
                break;
            }
            default: {
                parsedValue = rawValue;
            }
        }
        return parsedValue;
    }

    @Override
    protected String getTypePrefix() {
        return NETWORK_LABEL_PREFIX;
    }
}

