/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.model;

import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.vim.binding.vim.host.ImageConfigManager;
import com.vmware.vim.binding.vim.host.SoftwarePackage;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.host.model.SoftwarePackageData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

@QueryBinding(value="HostSystem")
public class HostSoftwarePackageDataModel {
    @Property(value="HostSystem/configManager/imageConfigManager")
    public transient ManagedObjectReference imageConfigManagerMor;

    public SoftwarePackageData[] getHostSoftwarePackages() throws Exception {
        SoftwarePackage[] softwarePackages;
        ImageConfigManager manager = (ImageConfigManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)this.imageConfigManagerMor);
        ArrayList<SoftwarePackageData> softwarePackageDataList = new ArrayList<SoftwarePackageData>();
        if (manager != null && (softwarePackages = manager.fetchSoftwarePackages()) != null) {
            for (SoftwarePackage softwarePackage : softwarePackages) {
                SoftwarePackageData currentModel = new SoftwarePackageData(softwarePackage);
                softwarePackageDataList.add(currentModel);
            }
        }
        Collections.sort(softwarePackageDataList, new Comparator<SoftwarePackageData>(){

            @Override
            public int compare(SoftwarePackageData o1, SoftwarePackageData o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return softwarePackageDataList.toArray(new SoftwarePackageData[0]);
    }
}

