/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.host.model;

import com.vmware.vim.binding.vim.host.SoftwarePackage;
import com.vmware.vise.util.FormatUtil;
import java.io.Serializable;
import java.util.Calendar;

public final class SoftwarePackageData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String _name;
    private final String _version;
    private final String _vendor;
    private final String _acceptanceLevel;
    private final String _description;
    private final String _installDate;
    private final long _installDateInMillis;

    public SoftwarePackageData(SoftwarePackage softwarePackage) {
        this._name = softwarePackage.getName();
        this._version = softwarePackage.getVersion();
        this._acceptanceLevel = softwarePackage.getAcceptanceLevel();
        this._description = softwarePackage.getDescription();
        this._vendor = softwarePackage.getVendor();
        Calendar creationDate = softwarePackage.getCreationDate();
        this._installDateInMillis = creationDate.getTimeInMillis();
        this._installDate = FormatUtil.getDateTimeFormatted((Object)creationDate);
    }

    public String getName() {
        return this._name;
    }

    public String getVersion() {
        return this._version;
    }

    public String getVendor() {
        return this._vendor;
    }

    public String getAcceptanceLevel() {
        return this._acceptanceLevel;
    }

    public String getInstallDateFormatted() {
        return this._installDate;
    }

    public String getDescription() {
        return this._description;
    }

    public long getInstallDateInMillis() {
        return this._installDateInMillis;
    }
}

