/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.ssl;

import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.client.http.impl.ThumbprintTrustManager;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.http.HttpClient;
import com.vmware.vise.util.http.HttpClientFactory;
import com.vmware.vise.util.http.NoOpTrustManager;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.reflection.ReflectionUtil;
import com.vmware.vise.util.security.CertificateUtil;
import com.vmware.vise.vim.commons.ssl.SslThumbprintVerifier;
import com.vmware.vise.vim.commons.util.VecsUtil;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.PrivateKeyDetails;
import org.apache.http.conn.ssl.PrivateKeyStrategy;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;

@NotThreadSafe
public class SSLBuilder {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final long TRUST_MANAGER_FACTORY_INIT_THRESHOLD_NANOS = TimeUnit.MILLISECONDS.toNanos(100L);
    private static final long TRUST_MANAGER_WARN_INVOCATION_THRESHOLD_NANOS = TimeUnit.MILLISECONDS.toNanos(2000L);
    private static final long TRUST_MANAGER_INFO_INVOCATION_THRESHOLD_NANOS = TimeUnit.MILLISECONDS.toNanos(1000L);
    private static final long TRUST_MANAGER_DEBUG_INVOCATION_THRESHOLD_NANOS = TimeUnit.MILLISECONDS.toNanos(500L);
    private static final long KEY_MANAGER_FACTORY_INIT_THRESHOLD_NANOS = TimeUnit.MILLISECONDS.toNanos(100L);
    private static final TrustManager[] EMPTY_TRUST_MANAGER_ARRAY = new TrustManager[0];
    @Nonnull
    private String _protocol = "TLSv1.2";
    private SecureRandom _secureRandom;
    private String[] _enabledProtocols;
    private String[] _enabledCipherSuites;
    private String[] _thumbprints;
    private String _thumbprintAlgorithm = "SHA-1";
    private Map<KeyStore, TrustStrategy> _trustStores;
    private KeyStore _keyStore;
    private char[] _keyStorePassword;
    private CertStore _crlCertStore;
    private boolean _performCrlValidation = true;
    private PrivateKeyStrategy _privateKeyAliasStrategy;
    private Integer _socketReadTimeout = null;
    private Integer _socketConnectionTimeout = null;
    private SSLContext _sslContext;
    private SSLSocketFactory _sslSocketFactory;
    private HostnameVerifier _hostnameVerifier;

    public SSLBuilder sslConfigurationProvider(@Nonnull SSLConfigurationProvider sSLConfigurationProvider) {
        String string = sSLConfigurationProvider.getProtocol();
        if (!StringUtil.isNullOrWhitespace((String)string)) {
            this._protocol = string;
        }
        this._enabledProtocols = sSLConfigurationProvider.getEnabledProtocols();
        this._enabledCipherSuites = sSLConfigurationProvider.getEnabledCipherSuites();
        return this;
    }

    public SSLBuilder useTLS() {
        this._protocol = "TLS";
        return this;
    }

    public SSLBuilder useSSL() {
        this._protocol = "SSL";
        return this;
    }

    public SSLBuilder protocol(@Nonnull String string) {
        Validate.isTrue((!StringUtil.isNullOrWhitespace((String)string) ? 1 : 0) != 0, (String)("Invalid protocol: '" + string + "'"));
        this._protocol = string;
        return this;
    }

    public SSLBuilder secureRandom(@Nonnull SecureRandom secureRandom) {
        Validate.notNull((Object)secureRandom);
        this._secureRandom = secureRandom;
        return this;
    }

    public SSLBuilder enabledProtocols(@Nonnull String[] stringArray) {
        ValidationUtil.noNullOrWhitespaceElements((String[])stringArray, (boolean)false);
        this._enabledProtocols = stringArray;
        return this;
    }

    public SSLBuilder enabledCipherSuites(@Nonnull String[] stringArray) {
        ValidationUtil.noNullOrWhitespaceElements((String[])stringArray, (boolean)false);
        this._enabledCipherSuites = stringArray;
        return this;
    }

    public SSLBuilder thumbprint(@Nonnull String string) {
        Validate.isTrue((!StringUtil.isNullOrWhitespace((String)string) ? 1 : 0) != 0, (String)"the thumbprint is null or whitespace");
        this._thumbprints = new String[]{string};
        return this;
    }

    public SSLBuilder thumbprints(@Nonnull String[] stringArray) {
        ValidationUtil.noNullOrWhitespaceElements((String[])stringArray, (boolean)false);
        this._thumbprints = stringArray;
        return this;
    }

    public SSLBuilder thumbprintAlgorithm(@Nonnull String string) {
        Validate.isTrue((!StringUtil.isNullOrWhitespace((String)string) ? 1 : 0) != 0, (String)"the algorithm is null or whitespace");
        this._thumbprintAlgorithm = string;
        return this;
    }

    public SSLBuilder addTrustStore(@Nonnull KeyStore keyStore) {
        return this.addTrustStore(keyStore, null);
    }

    public SSLBuilder addTrustStore(@Nonnull KeyStore keyStore, @Nullable TrustStrategy trustStrategy) {
        Validate.notNull((Object)keyStore);
        if (this._trustStores == null) {
            this._trustStores = new HashMap<KeyStore, TrustStrategy>();
        }
        this._trustStores.put(keyStore, trustStrategy);
        return this;
    }

    public SSLBuilder addTrustedCertificate(@Nonnull String string) throws UnsupportedEncodingException, CertificateException {
        Validate.notEmpty((String)string);
        Certificate certificate = CertificateUtil.generateCertificate((String)string);
        return this.addTrustedCertificate(certificate);
    }

    public SSLBuilder addTrustedCertificate(Certificate certificate) throws CertificateException {
        Validate.notNull((Object)certificate);
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null);
            keyStore.setEntry("defaultAlias", new KeyStore.TrustedCertificateEntry(certificate), null);
            return this.addTrustStore(keyStore);
        }
        catch (Exception exception) {
            throw new CertificateException("Error when creating a temporary keystore", exception);
        }
    }

    public SSLBuilder keyStore(@Nonnull KeyStore keyStore, @Nullable char[] cArray) {
        Validate.notNull((Object)keyStore);
        this._keyStore = keyStore;
        this._keyStorePassword = cArray;
        return this;
    }

    public SSLBuilder privateKeyAliasStrategy(@Nonnull PrivateKeyStrategy privateKeyStrategy) {
        Validate.notNull((Object)privateKeyStrategy);
        this._privateKeyAliasStrategy = privateKeyStrategy;
        return this;
    }

    public SSLBuilder crlCertStore(@Nonnull CertStore certStore) {
        Validate.notNull((Object)certStore);
        this._crlCertStore = certStore;
        return this;
    }

    public SSLBuilder skipCrlValidation() {
        this._performCrlValidation = false;
        return this;
    }

    public SSLBuilder socketReadTimeout(int n) {
        this._socketReadTimeout = n;
        return this;
    }

    public SSLBuilder socketTimeout(int n) {
        return this.socketReadTimeout(n);
    }

    public SSLBuilder socketConnectionTimeout(int n) {
        this._socketConnectionTimeout = n;
        return this;
    }

    public SSLBuilder sslContext(@Nullable SSLContext sSLContext) {
        this._sslContext = sSLContext;
        return this;
    }

    public SSLBuilder sslSocketFactory(@Nullable SSLSocketFactory sSLSocketFactory) {
        this._sslSocketFactory = sSLSocketFactory;
        return this;
    }

    public SSLBuilder sslHostnameVerifier(@Nullable HostnameVerifier hostnameVerifier) {
        this._hostnameVerifier = hostnameVerifier;
        return this;
    }

    @Nonnull
    public SSLContextAndHostnameVerifier buildSSLContext() throws SSLException {
        SSLContextAndHostnameVerifier sSLContextAndHostnameVerifier = this.doBuildSSLContext();
        return sSLContextAndHostnameVerifier;
    }

    @Nonnull
    public SSLContext buildAllowAllSSLContext() throws SSLException {
        try {
            SSLContext sSLContext = SSLContext.getInstance(this._protocol);
            sSLContext.init(null, new TrustManager[]{new NoOpTrustManager()}, this._secureRandom);
            return sSLContext;
        }
        catch (Exception exception) {
            throw new SSLException("Failed to create an SSLContext", exception);
        }
    }

    @Nonnull
    public SSLSocketFactoryAndHostnameVerifier buildSSLSocketFactory() throws SSLException {
        Object object;
        SSLContext sSLContext = this._sslContext;
        HostnameVerifier hostnameVerifier = null;
        if (sSLContext == null) {
            object = this.buildSSLContext();
            sSLContext = ((SSLContextAndHostnameVerifier)object).getSslContext();
            hostnameVerifier = ((SSLContextAndHostnameVerifier)object).getHostnameVerifier();
        }
        object = this.doBuildSSLSocketFactory(sSLContext);
        return new SSLSocketFactoryAndHostnameVerifier((SSLSocketFactory)object, hostnameVerifier);
    }

    @Nonnull
    public SSLSocketFactory buildAllowAllSSLSocketFactory() throws SSLException {
        SSLContext sSLContext = this.buildAllowAllSSLContext();
        SSLSocketFactory sSLSocketFactory = this.doBuildSSLSocketFactory(sSLContext);
        return sSLSocketFactory;
    }

    @Nonnull
    public HttpClient buildHttpClient() throws SSLException {
        try {
            return this.doBuildHttpClient(this._sslContext, this._sslSocketFactory, this._hostnameVerifier, false);
        }
        catch (SSLException sSLException) {
            throw sSLException;
        }
        catch (Exception exception) {
            throw new SSLException("Failed to build an HttpClient", exception);
        }
    }

    @Nonnull
    public HttpClient buildAllowAllHttpClient() throws SSLException {
        SSLSocketFactory sSLSocketFactory = this.buildAllowAllSSLSocketFactory();
        HttpClient httpClient = HttpClientFactory.getInstance();
        httpClient.setSSLSocketFactory((Object)sSLSocketFactory);
        httpClient.setHostnameVerifier((Object)SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        return httpClient;
    }

    @Nonnull
    public HttpClient buildHttpClientIgnoreErrors() {
        try {
            return this.doBuildHttpClient(this._sslContext, this._sslSocketFactory, this._hostnameVerifier, true);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nonnull
    private HttpClient doBuildHttpClient(@Nullable SSLContext sSLContext, @Nullable SSLSocketFactory sSLSocketFactory, @Nullable HostnameVerifier hostnameVerifier, boolean bl) throws SSLException {
        HttpClient httpClient;
        block8: {
            httpClient = HttpClientFactory.getInstance();
            try {
                if (sSLSocketFactory == null) {
                    if (sSLContext == null) {
                        SSLContextAndHostnameVerifier sSLContextAndHostnameVerifier = this.doBuildSSLContext();
                        sSLContext = sSLContextAndHostnameVerifier.getSslContext();
                        if (hostnameVerifier == null) {
                            hostnameVerifier = sSLContextAndHostnameVerifier.getHostnameVerifier();
                        }
                    }
                    sSLSocketFactory = this.doBuildSSLSocketFactory(sSLContext);
                }
                if (hostnameVerifier == null) {
                    hostnameVerifier = SSLConnectionSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER;
                }
                httpClient.setSSLSocketFactory((Object)sSLSocketFactory);
                httpClient.setHostnameVerifier((Object)hostnameVerifier);
                if (this._socketReadTimeout != null) {
                    httpClient.setSocketReadTimeout(this._socketReadTimeout.intValue());
                }
                if (this._socketConnectionTimeout != null) {
                    httpClient.setSocketConnectionTimeout(this._socketConnectionTimeout.intValue());
                }
            }
            catch (Exception exception) {
                _logger.error((Object)"Failed to initialize the HttpClient", (Throwable)exception);
                if (bl) break block8;
                throw new SSLException("Failed to initialize the HttpClient", exception);
            }
        }
        return httpClient;
    }

    @Nonnull
    private SSLSocketFactory doBuildSSLSocketFactory(@Nonnull SSLContext sSLContext) {
        final SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
        if (this._enabledProtocols == null && this._enabledCipherSuites == null && this._socketReadTimeout == null) {
            return sSLSocketFactory;
        }
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(SSLSocketFactory.class);
        enhancer.setCallback((Callback)new MethodInterceptor(){

            public Object intercept(Object object, Method method, Object[] objectArray, MethodProxy methodProxy) throws Throwable {
                Object object2 = methodProxy.invoke((Object)sSLSocketFactory, objectArray);
                if ("createSocket".equals(method.getName()) && object2 instanceof SSLSocket) {
                    SSLSocket sSLSocket = (SSLSocket)object2;
                    if (SSLBuilder.this._enabledProtocols != null) {
                        sSLSocket.setEnabledProtocols(SSLBuilder.this._enabledProtocols);
                    }
                    if (SSLBuilder.this._enabledCipherSuites != null) {
                        sSLSocket.setEnabledCipherSuites(SSLBuilder.this._enabledCipherSuites);
                    }
                    if (SSLBuilder.this._socketReadTimeout != null) {
                        sSLSocket.setSoTimeout(SSLBuilder.this._socketReadTimeout);
                    }
                }
                return object2;
            }
        });
        enhancer.setClassLoader(SSLBuilder.class.getClassLoader());
        SSLSocketFactory sSLSocketFactory2 = (SSLSocketFactory)enhancer.create();
        return sSLSocketFactory2;
    }

    private SSLContextAndHostnameVerifier doBuildSSLContext() throws SSLException {
        try {
            Object object;
            TrustManager[] trustManagerArray;
            SSLContext sSLContext = SSLContext.getInstance(this._protocol);
            ThumbprintTrustManager thumbprintTrustManager = null;
            ThumbprintTrustManager.HostnameVerifier hostnameVerifier = null;
            if (this._thumbprints == null || this._thumbprints.length == 0) {
                trustManagerArray = this.createTrustManagers();
            } else {
                TrustStrategy trustStrategy;
                Object object2;
                if (this._trustStores != null) {
                    if (this._trustStores.size() > 1) {
                        throw new IllegalStateException("When using thumbprints, no more than one trust store is allowed, but " + this._trustStores.size() + " are specified");
                    }
                    object2 = this._trustStores.entrySet().iterator().next();
                    object = (KeyStore)object2.getKey();
                    trustStrategy = (TrustStrategy)object2.getValue();
                } else {
                    object = null;
                    trustStrategy = null;
                }
                object2 = new SslThumbprintVerifier();
                ((SslThumbprintVerifier)object2).setThumbprints(this._thumbprints);
                CertStore certStore = this.getCrlCertStore();
                thumbprintTrustManager = new ThumbprintTrustManager((KeyStore)object, certStore, (ThumbprintVerifier)object2, this._thumbprintAlgorithm);
                hostnameVerifier = new ThumbprintTrustManager.HostnameVerifier(thumbprintTrustManager);
                X509TrustManager x509TrustManager = SSLBuilder.buildProfilingProxyFor(thumbprintTrustManager, X509TrustManager.class);
                if (trustStrategy != null) {
                    x509TrustManager = new TrustManagerDelegate(x509TrustManager, trustStrategy, null);
                }
                trustManagerArray = new TrustManager[]{x509TrustManager};
            }
            object = this.createKeyManagers();
            sSLContext.init((KeyManager[])object, trustManagerArray, this._secureRandom);
            return new SSLContextAndHostnameVerifier(sSLContext, (HostnameVerifier)hostnameVerifier);
        }
        catch (Exception exception) {
            throw new SSLException("Failed to create an SSLContext", exception);
        }
    }

    private TrustManager[] createTrustManagers() throws NoSuchAlgorithmException, KeyStoreException {
        if (this._trustStores == null) {
            return null;
        }
        if (this._trustStores.size() == 1) {
            Map.Entry<KeyStore, TrustStrategy> entry = this._trustStores.entrySet().iterator().next();
            KeyStore keyStore = entry.getKey();
            TrustStrategy trustStrategy = entry.getValue();
            CertStore certStore = this.getCrlCertStore();
            return SSLBuilder.createTrustManagers(keyStore, trustStrategy, certStore);
        }
        HashSet hashSet = new HashSet();
        for (Map.Entry<KeyStore, TrustStrategy> entry : this._trustStores.entrySet()) {
            CertStore certStore;
            TrustStrategy trustStrategy;
            KeyStore keyStore = entry.getKey();
            TrustManager[] trustManagerArray = SSLBuilder.createTrustManagers(keyStore, trustStrategy = entry.getValue(), certStore = this.getCrlCertStore());
            if (trustManagerArray == null) continue;
            Collections.addAll(hashSet, trustManagerArray);
        }
        if (hashSet.size() == 0) {
            return null;
        }
        TrustManager[] trustManagerArray = hashSet.toArray(EMPTY_TRUST_MANAGER_ARRAY);
        return trustManagerArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TrustManager[] createTrustManagers(KeyStore keyStore, TrustStrategy trustStrategy, CertStore certStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX");
        long l = System.nanoTime();
        try {
            trustManagerFactory.init(keyStore);
        }
        finally {
            long l2 = System.nanoTime() - l;
            if (l2 > TRUST_MANAGER_FACTORY_INIT_THRESHOLD_NANOS) {
                _logger.warn((Object)("TrustManagerFactory initialization took too long: " + StringUtil.getGroupByThreeDecimalFormat().format(l2) + " nanos"));
            }
        }
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        if (trustManagerArray != null && (trustStrategy != null || certStore != null)) {
            for (int i = 0; i < trustManagerArray.length; ++i) {
                TrustManager trustManager = trustManagerArray[i];
                if (!(trustManager instanceof X509TrustManager)) continue;
                X509TrustManager x509TrustManager = SSLBuilder.buildProfilingProxyFor((X509TrustManager)trustManager, X509TrustManager.class);
                CRLRetriever cRLRetriever = null;
                if (certStore != null) {
                    cRLRetriever = SSLBuilder.buildProfilingProxyFor(new CertStoreWrapper(certStore), CRLRetriever.class);
                }
                trustManagerArray[i] = new TrustManagerDelegate(x509TrustManager, trustStrategy, cRLRetriever);
            }
        }
        return trustManagerArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyManager[] createKeyManagers() throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException {
        if (this._keyStore == null) {
            return null;
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("PKIX");
        long l = System.nanoTime();
        try {
            keyManagerFactory.init(this._keyStore, this._keyStorePassword);
        }
        finally {
            long l2 = System.nanoTime() - l;
            if (l2 > KEY_MANAGER_FACTORY_INIT_THRESHOLD_NANOS) {
                _logger.warn((Object)("KeyManagerFactory initialization took too long: " + StringUtil.getGroupByThreeDecimalFormat().format(l2) + " nanos"));
            }
        }
        KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
        if (keyManagerArray != null && this._privateKeyAliasStrategy != null) {
            for (int i = 0; i < keyManagerArray.length; ++i) {
                KeyManager keyManager = keyManagerArray[i];
                if (!(keyManager instanceof X509KeyManager)) continue;
                X509KeyManager x509KeyManager = SSLBuilder.buildProfilingProxyFor((X509KeyManager)keyManager, X509KeyManager.class);
                keyManagerArray[i] = new KeyManagerDelegate(x509KeyManager, this._privateKeyAliasStrategy);
            }
        }
        return keyManagerArray;
    }

    @Nullable
    private CertStore getCrlCertStore() {
        if (!this._performCrlValidation) {
            return null;
        }
        if (this._crlCertStore != null) {
            return this._crlCertStore;
        }
        CertStore certStore = VecsUtil.getVecsCrlCertStore();
        return certStore;
    }

    private static <T> T buildProfilingProxyFor(T t, Class<? super T> clazz) {
        if (TRUST_MANAGER_WARN_INVOCATION_THRESHOLD_NANOS <= 0L) {
            return t;
        }
        Object object = ReflectionUtil.buildProfilingProxyFor(t, clazz, (long)TRUST_MANAGER_WARN_INVOCATION_THRESHOLD_NANOS, (long)TRUST_MANAGER_INFO_INVOCATION_THRESHOLD_NANOS, (long)TRUST_MANAGER_DEBUG_INVOCATION_THRESHOLD_NANOS);
        return (T)object;
    }

    private static class CertStoreWrapper
    implements CRLRetriever {
        private final CertStore _certStore;

        public CertStoreWrapper(CertStore certStore) {
            assert (certStore != null);
            this._certStore = certStore;
        }

        @Override
        public Collection<? extends CRL> getCRLs(CRLSelector cRLSelector) throws CertStoreException {
            return this._certStore.getCRLs(cRLSelector);
        }
    }

    public static interface CRLRetriever {
        public Collection<? extends CRL> getCRLs(CRLSelector var1) throws CertStoreException;
    }

    public static class SSLSocketFactoryAndHostnameVerifier {
        @Nonnull
        private final SSLSocketFactory _sslSocketFactory;
        @Nullable
        private final HostnameVerifier _hostnameVerifier;

        public SSLSocketFactoryAndHostnameVerifier(@Nonnull SSLSocketFactory sSLSocketFactory, @Nullable HostnameVerifier hostnameVerifier) {
            Validate.notNull((Object)sSLSocketFactory);
            this._sslSocketFactory = sSLSocketFactory;
            this._hostnameVerifier = hostnameVerifier;
        }

        @Nonnull
        public SSLSocketFactory getSslSocketFactory() {
            return this._sslSocketFactory;
        }

        @Nullable
        public HostnameVerifier getHostnameVerifier() {
            return this._hostnameVerifier;
        }
    }

    public static class SSLContextAndHostnameVerifier {
        @Nonnull
        private final SSLContext _sslContext;
        @Nullable
        private final HostnameVerifier _hostnameVerifier;

        public SSLContextAndHostnameVerifier(@Nonnull SSLContext sSLContext, @Nullable HostnameVerifier hostnameVerifier) {
            Validate.notNull((Object)sSLContext);
            this._sslContext = sSLContext;
            this._hostnameVerifier = hostnameVerifier;
        }

        @Nonnull
        public SSLContext getSslContext() {
            return this._sslContext;
        }

        @Nullable
        public HostnameVerifier getHostnameVerifier() {
            return this._hostnameVerifier;
        }
    }

    static class KeyManagerDelegate
    implements X509KeyManager {
        private final X509KeyManager _keyManager;
        private final PrivateKeyStrategy _aliasStrategy;

        KeyManagerDelegate(X509KeyManager x509KeyManager, PrivateKeyStrategy privateKeyStrategy) {
            this._keyManager = x509KeyManager;
            this._aliasStrategy = privateKeyStrategy;
        }

        @Override
        public String[] getClientAliases(String string, Principal[] principalArray) {
            return this._keyManager.getClientAliases(string, principalArray);
        }

        @Override
        public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
            HashMap<String, PrivateKeyDetails> hashMap = new HashMap<String, PrivateKeyDetails>();
            for (String string : stringArray) {
                String[] stringArray2 = this._keyManager.getClientAliases(string, principalArray);
                if (stringArray2 == null) continue;
                for (String string2 : stringArray2) {
                    X509Certificate[] x509CertificateArray = this._keyManager.getCertificateChain(string2);
                    hashMap.put(string2, new PrivateKeyDetails(string, x509CertificateArray));
                }
            }
            return this._aliasStrategy.chooseAlias(hashMap, socket);
        }

        @Override
        public String[] getServerAliases(String string, Principal[] principalArray) {
            return this._keyManager.getServerAliases(string, principalArray);
        }

        @Override
        public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
            HashMap<String, PrivateKeyDetails> hashMap = new HashMap<String, PrivateKeyDetails>();
            String[] stringArray = this._keyManager.getServerAliases(string, principalArray);
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    X509Certificate[] x509CertificateArray = this._keyManager.getCertificateChain(string2);
                    PrivateKeyDetails privateKeyDetails = new PrivateKeyDetails(string, x509CertificateArray);
                    hashMap.put(string2, privateKeyDetails);
                }
            }
            return this._aliasStrategy.chooseAlias(hashMap, socket);
        }

        @Override
        public X509Certificate[] getCertificateChain(String string) {
            return this._keyManager.getCertificateChain(string);
        }

        @Override
        public PrivateKey getPrivateKey(String string) {
            return this._keyManager.getPrivateKey(string);
        }
    }

    static class TrustManagerDelegate
    implements X509TrustManager {
        @Nonnull
        private final X509TrustManager _trustManager;
        @Nullable
        private final TrustStrategy _trustStrategy;
        @Nullable
        private final CRLRetriever _crlRetriever;

        TrustManagerDelegate(@Nonnull X509TrustManager x509TrustManager, @Nullable TrustStrategy trustStrategy, @Nullable CRLRetriever cRLRetriever) {
            this._trustManager = x509TrustManager;
            this._trustStrategy = trustStrategy;
            this._crlRetriever = cRLRetriever;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this._trustManager.checkClientTrusted(x509CertificateArray, string);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            if (this._trustStrategy == null || !this._trustStrategy.isTrusted(x509CertificateArray, string)) {
                this.validateCertChainWithCrl(x509CertificateArray);
                this._trustManager.checkServerTrusted(x509CertificateArray, string);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this._trustManager.getAcceptedIssuers();
        }

        private void validateCertChainWithCrl(X509Certificate[] x509CertificateArray) throws CertificateException {
            if (this._crlRetriever == null) {
                return;
            }
            try {
                for (X509Certificate x509Certificate : x509CertificateArray) {
                    X509CRLSelector x509CRLSelector = new X509CRLSelector();
                    x509CRLSelector.setCertificateChecking(x509Certificate);
                    Collection<? extends CRL> collection = this._crlRetriever.getCRLs(x509CRLSelector);
                    for (CRL cRL : collection) {
                        if (!cRL.isRevoked(x509Certificate)) continue;
                        StringBuilder stringBuilder = new StringBuilder(200);
                        stringBuilder.append("The certificate is revoked\nCert Issuer DN=").append(x509Certificate.getIssuerDN()).append("\nCert Subject DN=").append(x509Certificate.getSubjectDN());
                        if (cRL instanceof X509CRL) {
                            X509CRL x509CRL = (X509CRL)cRL;
                            stringBuilder.append("\nCRL Issuer DN=").append(x509CRL.getIssuerDN()).append("\nCRL date=").append(x509CRL.getThisUpdate());
                        }
                        throw new CertificateException(stringBuilder.toString());
                    }
                }
            }
            catch (CertStoreException certStoreException) {
                throw new CertificateException("Failed to validate a certificate against CRL", certStoreException);
            }
        }
    }
}

