/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.sso;

import com.google.common.collect.ImmutableMap;
import com.vmware.sso.tokenmgmt.SsoDomain;
import com.vmware.sso.tokenmgmt.TokenAcquisitionResult;
import com.vmware.sso.tokenmgmt.TokenEx;
import com.vmware.sso.tokenmgmt.TokenException;
import com.vmware.sso.tokenmgmt.TokenManager;
import com.vmware.sso.tokenmgmt.TokenProvider;
import com.vmware.sso.tokenmgmt.impl.NonAcquiringTokenManager;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.util.session.SessionUtil;
import java.security.PrivateKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;

public class AuthSessionUtil {
    public static final String SSO_TOKEN_PRIVATE_KEY = "SSO_TOKEN_PRIVATE_KEY";
    public static final String SSO_TOKEN_MANAGER = "SSO_TOKEN_MANAGER";

    @Deprecated
    public static SamlToken getSsoToken() {
        return AuthSessionUtil.getSsoToken((HttpSession)null);
    }

    public static SamlToken getSsoToken(@Nonnull SsoDomain ssoDomain) {
        return AuthSessionUtil.getSsoToken(ssoDomain, (HttpSession)null);
    }

    public static TokenEx getSsoTokenEx(@Nonnull SsoDomain ssoDomain) {
        return AuthSessionUtil.getSsoTokenEx(ssoDomain, (HttpSession)null);
    }

    @Deprecated
    public static SamlToken getSsoToken(HttpSession httpSession) {
        return AuthSessionUtil.getSsoToken(SsoDomain.getLocal(), httpSession);
    }

    @Nullable
    public static SamlToken getSsoToken(@Nonnull SsoDomain ssoDomain, @Nullable HttpSession httpSession) {
        TokenEx tokenEx = AuthSessionUtil.getSsoTokenEx(ssoDomain, httpSession);
        if (tokenEx != null) {
            return tokenEx.getToken();
        }
        return null;
    }

    @Nullable
    public static TokenEx getSsoTokenEx(@Nonnull SsoDomain ssoDomain, @Nullable HttpSession httpSession) {
        TokenProvider tokenProvider = (TokenProvider)SessionUtil.getData((String)SSO_TOKEN_MANAGER, (HttpSession)httpSession);
        if (tokenProvider == null) {
            return null;
        }
        try {
            TokenEx tokenEx = tokenProvider.getTokenForSsoDomain(ssoDomain);
            return tokenEx;
        }
        catch (TokenException tokenException) {
            return null;
        }
    }

    @Deprecated
    public static SamlToken getSsoToken(String string) {
        return AuthSessionUtil.getSsoToken(SsoDomain.getLocal(), string);
    }

    @Nullable
    public static SamlToken getSsoToken(@Nonnull SsoDomain ssoDomain, @Nonnull String string) {
        TokenEx tokenEx = AuthSessionUtil.getSsoTokenEx(ssoDomain, string);
        if (tokenEx != null) {
            return tokenEx.getToken();
        }
        return null;
    }

    @Nullable
    public static TokenEx getSsoTokenEx(@Nonnull SsoDomain ssoDomain, @Nonnull String string) {
        Validate.notNull((Object)ssoDomain);
        Validate.notNull((Object)string);
        TokenProvider tokenProvider = (TokenProvider)SessionUtil.getData((String)SSO_TOKEN_MANAGER, (String)string);
        if (tokenProvider == null) {
            return null;
        }
        try {
            TokenEx tokenEx = tokenProvider.getTokenForSsoDomain(ssoDomain);
            return tokenEx;
        }
        catch (TokenException tokenException) {
            return null;
        }
    }

    @Nullable
    public static TokenProvider getSsoTokenProvider() {
        return AuthSessionUtil.getSsoTokenProvider((HttpSession)null);
    }

    @Nullable
    public static TokenProvider getSsoTokenProvider(@Nullable HttpSession httpSession) {
        TokenProvider tokenProvider = (TokenProvider)SessionUtil.getData((String)SSO_TOKEN_MANAGER, (HttpSession)httpSession);
        return tokenProvider;
    }

    @Nullable
    public static TokenProvider getSsoTokenProvider(@Nullable String string) {
        TokenProvider tokenProvider = (TokenProvider)SessionUtil.getData((String)SSO_TOKEN_MANAGER, (String)string);
        return tokenProvider;
    }

    @Nonnull
    public static Map<SsoDomain, SamlToken> getAllSsoTokens() {
        return AuthSessionUtil.getAllSsoTokens((HttpSession)null);
    }

    @Nonnull
    public static Map<SsoDomain, TokenEx> getAllSsoTokenExs() {
        return AuthSessionUtil.getAllSsoTokenExs((HttpSession)null);
    }

    @Nonnull
    public static Map<SsoDomain, SamlToken> getAllSsoTokens(@Nullable HttpSession httpSession) {
        String string = SessionUtil.getClientId((HttpSession)httpSession);
        if (string == null) {
            return Collections.emptyMap();
        }
        return AuthSessionUtil.getAllSsoTokens(string);
    }

    @Nonnull
    public static Map<SsoDomain, TokenEx> getAllSsoTokenExs(@Nullable HttpSession httpSession) {
        String string = SessionUtil.getClientId((HttpSession)httpSession);
        if (string == null) {
            return Collections.emptyMap();
        }
        return AuthSessionUtil.getAllSsoTokenExs(string);
    }

    @Nonnull
    public static Map<SsoDomain, SamlToken> getAllSsoTokens(@Nonnull String string) {
        TokenProvider tokenProvider = (TokenProvider)SessionUtil.getData((String)SSO_TOKEN_MANAGER, (String)string);
        if (tokenProvider == null) {
            return Collections.emptyMap();
        }
        HashMap<SsoDomain, SamlToken> hashMap = new HashMap<SsoDomain, SamlToken>();
        Collection collection = tokenProvider.getAllTokens();
        for (TokenAcquisitionResult tokenAcquisitionResult : collection) {
            TokenEx tokenEx = (TokenEx)tokenAcquisitionResult.getTokenEx().orElse(null);
            if (tokenEx == null) continue;
            SsoDomain ssoDomain = tokenAcquisitionResult.getSsoDomain();
            hashMap.put(ssoDomain, tokenEx.getToken());
        }
        if (hashMap.isEmpty()) {
            return Collections.emptyMap();
        }
        return ImmutableMap.copyOf(hashMap);
    }

    @Nonnull
    public static Map<SsoDomain, TokenEx> getAllSsoTokenExs(@Nonnull String string) {
        TokenProvider tokenProvider = (TokenProvider)SessionUtil.getData((String)SSO_TOKEN_MANAGER, (String)string);
        if (tokenProvider == null) {
            return Collections.emptyMap();
        }
        HashMap<SsoDomain, TokenEx> hashMap = new HashMap<SsoDomain, TokenEx>();
        Collection collection = tokenProvider.getAllTokens();
        for (TokenAcquisitionResult tokenAcquisitionResult : collection) {
            TokenEx tokenEx = (TokenEx)tokenAcquisitionResult.getTokenEx().orElse(null);
            if (tokenEx == null) continue;
            SsoDomain ssoDomain = tokenAcquisitionResult.getSsoDomain();
            hashMap.put(ssoDomain, tokenEx);
        }
        if (hashMap.isEmpty()) {
            return Collections.emptyMap();
        }
        return ImmutableMap.copyOf(hashMap);
    }

    @Deprecated
    public static void setSsoToken(SamlToken samlToken) {
        AuthSessionUtil.setSsoToken(samlToken, (HttpSession)null);
    }

    public static void setSsoToken(@Nonnull SsoDomain ssoDomain, @Nonnull SsoDomain ssoDomain2, SamlToken samlToken) {
        AuthSessionUtil.setSsoToken(ssoDomain, ssoDomain2, samlToken, (HttpSession)null);
    }

    @Deprecated
    public static void setSsoToken(SamlToken samlToken, HttpSession httpSession) {
        SsoDomain ssoDomain = SsoDomain.getLocal();
        AuthSessionUtil.setSsoToken(ssoDomain, ssoDomain, samlToken, httpSession);
    }

    public static void setSsoToken(@Nonnull SsoDomain ssoDomain, @Nonnull SsoDomain ssoDomain2, @Nonnull SamlToken samlToken, @Nullable HttpSession httpSession) {
        String string;
        if (httpSession == null) {
            httpSession = SessionUtil.getHttpSession();
        }
        if ((string = SessionUtil.getClientId((HttpSession)httpSession)) == null) {
            return;
        }
        AuthSessionUtil.setSsoToken(ssoDomain, ssoDomain2, samlToken, string);
    }

    @Deprecated
    public static void setSsoToken(SamlToken samlToken, String string) {
        SsoDomain ssoDomain = SsoDomain.getLocal();
        AuthSessionUtil.setSsoToken(ssoDomain, ssoDomain, samlToken, string);
    }

    public static void setSsoToken(@Nonnull SsoDomain ssoDomain, @Nonnull SsoDomain ssoDomain2, @Nonnull SamlToken samlToken, @Nonnull String string) {
        TokenManager tokenManager;
        Validate.notNull((Object)string);
        TokenManager tokenManager2 = (TokenManager)SessionUtil.getData((String)SSO_TOKEN_MANAGER, (String)string);
        if (tokenManager2 == null && (tokenManager = (TokenManager)SessionUtil.setDataIfAbsent((String)SSO_TOKEN_MANAGER, (Object)(tokenManager2 = new NonAcquiringTokenManager()), (String)string)) != null) {
            tokenManager2 = tokenManager;
        }
        tokenManager2.setTokenForSsoDomain(ssoDomain, ssoDomain2, samlToken);
    }

    public static PrivateKey getSsoTokenPrivateKey() {
        return AuthSessionUtil.getSsoTokenPrivateKey((HttpSession)null);
    }

    public static void setSsoTokenPrivateKey(PrivateKey privateKey) {
        AuthSessionUtil.setSsoTokenPrivateKey(privateKey, (HttpSession)null);
    }

    public static PrivateKey getSsoTokenPrivateKey(HttpSession httpSession) {
        return (PrivateKey)SessionUtil.getData((String)SSO_TOKEN_PRIVATE_KEY, (HttpSession)httpSession);
    }

    public static void setSsoTokenPrivateKey(PrivateKey privateKey, HttpSession httpSession) {
        SessionUtil.setData((String)SSO_TOKEN_PRIVATE_KEY, (Object)privateKey, (HttpSession)httpSession);
    }

    public static PrivateKey getSsoTokenPrivateKey(String string) {
        return (PrivateKey)SessionUtil.getData((String)SSO_TOKEN_PRIVATE_KEY, (String)string);
    }

    public static void setSsoTokenPrivateKey(PrivateKey privateKey, String string) {
        SessionUtil.setData((String)SSO_TOKEN_PRIVATE_KEY, (Object)privateKey, (String)string);
    }
}

