/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.vmomi;

import com.google.common.annotations.VisibleForTesting;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.common.ProtocolBinding;
import com.vmware.vim.vmomi.client.ext.InvocationContext;
import com.vmware.vim.vmomi.client.ext.InvocationInterceptor;
import com.vmware.vim.vmomi.client.ext.RequestContextProvider;
import com.vmware.vim.vmomi.client.ext.ResultInterceptor;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vise.util.ExceptionUtil;
import com.vmware.vise.util.OpIdUtil;
import com.vmware.vise.util.logging.LogUtil;
import com.vmware.vise.util.reflection.ReflectionUtil;
import com.vmware.vise.vim.commons.internal.Config;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpIdAwareClientFactory {
    private static final Log _logger = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final Log _opIdLogger = LogUtil.getOpIdLogger();
    static final String ATTR_NAME_INVOCATION_START_NANOS = "#VLSI_INVOCATION_START#";
    static final String ATTR_NAME_INVOCATION_END_NANOS = "#VLSI_INVOCATION_END#";
    static final String ATTR_NAME_METHOD_SIGNATURE = "#METHOD_SIGNATURE#";

    public static Client createClient(URI uRI, Class<?> clazz) {
        return OpIdAwareClientFactory.createClient(uRI, clazz, (ClientConfiguration)HttpClientConfiguration.Factory.newInstance());
    }

    public static Client createClient(URI uRI, Class<?> clazz, ClientConfiguration clientConfiguration) {
        return OpIdAwareClientFactory.createClient(uRI, clazz, VmodlContext.getContext(), clientConfiguration);
    }

    public static Client createClient(URI uRI, Class<?> clazz, VmodlContext vmodlContext, ClientConfiguration clientConfiguration) {
        Object object = clientConfiguration.getRequestContextProvider();
        object = object == null ? new OpIdRequestContextProvider() : new ChainingOpIdRequestContextProvider((RequestContextProvider)object);
        clientConfiguration.setRequestContextProvider(object);
        Object object2 = clientConfiguration.getInvocationInterceptor();
        object2 = object2 == null ? new OpIdInvocationInterceptor(uRI) : new ChainingOpIdInvocationInterceptor((InvocationInterceptor)object2);
        clientConfiguration.setInvocationInterceptor(object2);
        Object object3 = clientConfiguration.getResulInterceptor();
        object3 = object3 == null ? new OpIdResultInterceptor(uRI) : new ChainingOpIdResultInterceptor((ResultInterceptor)object3, uRI);
        clientConfiguration.setResultInterceptor(object3);
        Client client = Client.Factory.createClient((URI)uRI, clazz, (VmodlContext)vmodlContext, (ClientConfiguration)clientConfiguration);
        return client;
    }

    @Nullable
    private static String getRequestUriForLogging(@Nullable URI uRI, @Nullable InvocationContext invocationContext) {
        ProtocolBinding protocolBinding;
        String string;
        String string2 = string = uRI != null ? uRI.toASCIIString() : null;
        if (string == null && invocationContext != null && (protocolBinding = invocationContext.getBinding()) != null) {
            string = protocolBinding.getEndpointUri().toASCIIString() + " (binding)";
        }
        return string;
    }

    public static void appendHostAndPortData(@Nonnull StringBuilder stringBuilder, @Nonnull InvocationContext invocationContext) {
        Object object;
        InetSocketAddress inetSocketAddress = invocationContext.getLocalAddress();
        if (inetSocketAddress != null) {
            object = inetSocketAddress.getHostString() + ":" + inetSocketAddress.getPort();
            stringBuilder.append(", local host:port=").append((String)object);
        }
        if ((object = invocationContext.getRemoteAddress()) != null) {
            String string = ((InetSocketAddress)object).getHostString() + ":" + ((InetSocketAddress)object).getPort();
            stringBuilder.append(", remote host:port=").append(string);
        }
    }

    @VisibleForTesting
    static class ChainingOpIdResultInterceptor
    implements ResultInterceptor {
        private final ResultInterceptor _delegate;
        private final URI _endpointUri;

        public ChainingOpIdResultInterceptor(@Nonnull ResultInterceptor resultInterceptor, @Nullable URI uRI) {
            assert (resultInterceptor != null);
            this._delegate = resultInterceptor;
            this._endpointUri = uRI;
        }

        public Object handleReturnVal(Object object, InvocationContext invocationContext) {
            Object object2 = this._delegate.handleReturnVal(object, invocationContext);
            OpIdResultInterceptor.logInvocationCompletion(invocationContext, null, this._endpointUri);
            return object2;
        }

        public Exception handleSoapFault(Exception exception, InvocationContext invocationContext) {
            Exception exception2 = this._delegate.handleSoapFault(exception, invocationContext);
            OpIdResultInterceptor.logInvocationCompletion(invocationContext, exception, this._endpointUri);
            return exception2;
        }

        public Exception handleException(Exception exception, InvocationContext invocationContext) {
            Exception exception2 = this._delegate.handleException(exception, invocationContext);
            OpIdResultInterceptor.logInvocationCompletion(invocationContext, exception, this._endpointUri);
            return exception2;
        }
    }

    @VisibleForTesting
    static class OpIdResultInterceptor
    implements ResultInterceptor {
        private static final AtomicLong COUNTER_OF_LOGGING_ERRORS = new AtomicLong(0L);
        @Nullable
        private volatile URI _endpointUri;

        public OpIdResultInterceptor(@Nullable URI uRI) {
            this._endpointUri = uRI;
        }

        public Object handleReturnVal(Object object, InvocationContext invocationContext) {
            OpIdResultInterceptor.logInvocationCompletion(invocationContext, null, this._endpointUri);
            return object;
        }

        public Exception handleSoapFault(Exception exception, InvocationContext invocationContext) {
            OpIdResultInterceptor.logInvocationCompletion(invocationContext, exception, this._endpointUri);
            return exception;
        }

        public Exception handleException(Exception exception, InvocationContext invocationContext) {
            OpIdResultInterceptor.logInvocationCompletion(invocationContext, exception, this._endpointUri);
            return exception;
        }

        private static void logInvocationCompletion(@Nullable InvocationContext invocationContext, @Nullable Throwable throwable, @Nullable URI uRI) {
            block21: {
                if (invocationContext == null) {
                    return;
                }
                try {
                    boolean bl;
                    Object object;
                    Object object2 = OpIdRequestContextProvider.getOpId(invocationContext);
                    if (object2 == null) {
                        return;
                    }
                    long l = -1L;
                    Long l2 = (Long)invocationContext.getInvocationContextObject(OpIdAwareClientFactory.ATTR_NAME_INVOCATION_START_NANOS);
                    if (l2 != null) {
                        long l3;
                        object = (Long)invocationContext.getInvocationContextObject(OpIdAwareClientFactory.ATTR_NAME_INVOCATION_END_NANOS);
                        if (object != null) {
                            l3 = (Long)object;
                        } else {
                            l3 = System.nanoTime();
                            invocationContext.putInvocationContextObject(OpIdAwareClientFactory.ATTR_NAME_INVOCATION_END_NANOS, (Object)l3);
                        }
                        l = TimeUnit.NANOSECONDS.toMillis(l3 - l2);
                    }
                    object = invocationContext.getMethod().getMethod();
                    boolean bl2 = false;
                    boolean bl3 = bl = throwable != null;
                    if (!bl) {
                        bl2 = Config.VMOMI_INVOCATION_TIME_THRESHOLD_IN_MILLIS >= 0L && l > 0L && l > Config.VMOMI_INVOCATION_TIME_THRESHOLD_IN_MILLIS && OpIdUtil.shouldSlowInvocationBeLogged((Method)object);
                        boolean bl4 = bl = bl2 || _opIdLogger.isDebugEnabled();
                    }
                    if (!bl) {
                        return;
                    }
                    String string = (String)invocationContext.getInvocationContextObject(OpIdAwareClientFactory.ATTR_NAME_METHOD_SIGNATURE);
                    if (string == null) {
                        string = ReflectionUtil.getBasicSignatureInfo((Method)object);
                    }
                    StringBuilder stringBuilder = new StringBuilder().append("Invocation of '").append(string);
                    String string2 = OpIdAwareClientFactory.getRequestUriForLogging(uRI, invocationContext);
                    if (string2 != null) {
                        stringBuilder.append(" to URI ").append(string2);
                    }
                    stringBuilder.append(" for opId '").append(object2);
                    if (throwable != null) {
                        stringBuilder.append("' failed in ").append(l).append(" ms");
                        OpIdAwareClientFactory.appendHostAndPortData(stringBuilder, invocationContext);
                        if (_opIdLogger.isDebugEnabled()) {
                            _opIdLogger.error((Object)stringBuilder.toString(), throwable);
                        } else {
                            if ((throwable = ExceptionUtil.unwrap((Throwable)throwable)) != null) {
                                stringBuilder.append(", error: ").append(throwable);
                            }
                            _opIdLogger.error((Object)stringBuilder.toString());
                        }
                    } else if (bl2) {
                        stringBuilder.append("' took too long: ").append(l).append(" ms");
                        OpIdAwareClientFactory.appendHostAndPortData(stringBuilder, invocationContext);
                        _opIdLogger.warn((Object)stringBuilder);
                    } else {
                        LogUtil.LogLevel logLevel = OpIdUtil.determineLogLevelFor((Log)_opIdLogger, (Method)object);
                        if (logLevel == LogUtil.LogLevel.OFF) {
                            return;
                        }
                        stringBuilder.append("' completed in ").append(l).append(" ms");
                        OpIdAwareClientFactory.appendHostAndPortData(stringBuilder, invocationContext);
                        if (logLevel == LogUtil.LogLevel.TRACE) {
                            _opIdLogger.trace((Object)stringBuilder);
                        } else {
                            _opIdLogger.debug((Object)stringBuilder);
                        }
                    }
                }
                catch (Exception exception) {
                    if (COUNTER_OF_LOGGING_ERRORS.getAndIncrement() % 500L != 0L) break block21;
                    _logger.error((Object)"Failed to log opId invocation completion", (Throwable)exception);
                }
            }
        }
    }

    @VisibleForTesting
    static class ChainingOpIdInvocationInterceptor
    implements InvocationInterceptor {
        private InvocationInterceptor _delegate;

        public ChainingOpIdInvocationInterceptor(@Nonnull InvocationInterceptor invocationInterceptor) {
            assert (invocationInterceptor != null);
            this._delegate = invocationInterceptor;
        }

        public void beginInvocation(InvocationContext invocationContext) {
            this._delegate.beginInvocation(invocationContext);
            OpIdInvocationInterceptor.putSystemNanoTimeIntoInvocationContext(invocationContext, OpIdAwareClientFactory.ATTR_NAME_INVOCATION_START_NANOS);
        }

        public void completeInvocation(InvocationContext invocationContext, boolean bl) {
            this._delegate.completeInvocation(invocationContext, bl);
            Object object = invocationContext.getInvocationContextObject(OpIdAwareClientFactory.ATTR_NAME_INVOCATION_END_NANOS);
            if (object == null) {
                OpIdInvocationInterceptor.putSystemNanoTimeIntoInvocationContext(invocationContext, OpIdAwareClientFactory.ATTR_NAME_INVOCATION_END_NANOS);
            }
        }
    }

    @VisibleForTesting
    static class OpIdInvocationInterceptor
    implements InvocationInterceptor {
        private static final AtomicLong COUNTER_OF_LOGGING_ERRORS = new AtomicLong(0L);
        @Nullable
        private final URI _endpointUri;

        public OpIdInvocationInterceptor(@Nullable URI uRI) {
            this._endpointUri = uRI;
        }

        public void beginInvocation(InvocationContext invocationContext) {
            this.logInvocationStart(invocationContext);
            OpIdInvocationInterceptor.putSystemNanoTimeIntoInvocationContext(invocationContext, OpIdAwareClientFactory.ATTR_NAME_INVOCATION_START_NANOS);
        }

        public void completeInvocation(InvocationContext invocationContext, boolean bl) {
            OpIdInvocationInterceptor.putSystemNanoTimeIntoInvocationContext(invocationContext, OpIdAwareClientFactory.ATTR_NAME_INVOCATION_END_NANOS);
        }

        public static void putSystemNanoTimeIntoInvocationContext(@Nonnull InvocationContext invocationContext, @Nonnull String string) {
            assert (invocationContext != null);
            assert (string != null);
            long l = System.nanoTime();
            invocationContext.putInvocationContextObject(string, (Object)l);
        }

        private void logInvocationStart(@Nonnull InvocationContext invocationContext) {
            block5: {
                try {
                    if (!_opIdLogger.isDebugEnabled()) {
                        return;
                    }
                    Object object = OpIdRequestContextProvider.getOpId(invocationContext);
                    if (object == null) {
                        return;
                    }
                    String string = null;
                    Method method = invocationContext.getMethod().getMethod();
                    string = ReflectionUtil.getBasicSignatureInfo((Method)method);
                    invocationContext.putInvocationContextObject(OpIdAwareClientFactory.ATTR_NAME_METHOD_SIGNATURE, (Object)string);
                    StringBuilder stringBuilder = new StringBuilder(200);
                    stringBuilder.append("Invoking method '").append(string).append('\'');
                    String string2 = OpIdAwareClientFactory.getRequestUriForLogging(this._endpointUri, invocationContext);
                    if (string2 != null) {
                        stringBuilder.append(" to URI ").append(string2);
                    }
                    stringBuilder.append(" for opId '").append(object).append("'  (").append(this.getClass().getName()).append(')');
                    _opIdLogger.debug((Object)stringBuilder);
                }
                catch (Exception exception) {
                    if (COUNTER_OF_LOGGING_ERRORS.getAndIncrement() % 500L != 0L) break block5;
                    _logger.error((Object)"Failed to log opId invocation completion", (Throwable)exception);
                }
            }
        }
    }

    @VisibleForTesting
    static class ChainingOpIdRequestContextProvider
    implements RequestContextProvider {
        private final RequestContextProvider _delegate;

        public ChainingOpIdRequestContextProvider(@Nonnull RequestContextProvider requestContextProvider) {
            assert (requestContextProvider != null);
            this._delegate = requestContextProvider;
        }

        public RequestContext getRequestContext(InvocationContext invocationContext) {
            RequestContext requestContext = this._delegate.getRequestContext(invocationContext);
            if (requestContext == null) {
                return OpIdRequestContextProvider.createOpIdRequestContext(invocationContext);
            }
            OpIdRequestContextProvider.addOpIdToContexts(requestContext, invocationContext);
            return requestContext;
        }
    }

    @VisibleForTesting
    static class OpIdRequestContextProvider
    implements RequestContextProvider {
        OpIdRequestContextProvider() {
        }

        public RequestContext getRequestContext(InvocationContext invocationContext) {
            RequestContext requestContext = OpIdRequestContextProvider.createOpIdRequestContext(invocationContext);
            return requestContext;
        }

        public static RequestContext createOpIdRequestContext(InvocationContext invocationContext) {
            RequestContext requestContext = invocationContext.getStubRequestContext();
            Object object = requestContext == null ? new RequestContextImpl() : requestContext.clone();
            OpIdRequestContextProvider.addOpIdToContexts(object, invocationContext);
            return object;
        }

        public static void addOpIdToContexts(@Nonnull RequestContext requestContext, @Nullable InvocationContext invocationContext) {
            assert (requestContext != null);
            Object object = requestContext.get((Object)"operationID");
            if (object == null) {
                object = OpIdUtil.generateOpId();
                requestContext.put((Object)"operationID", object);
            }
            if (invocationContext != null) {
                invocationContext.putInvocationContextObject("operationID", object);
            }
        }

        public static Object getOpId(@Nullable InvocationContext invocationContext) {
            if (invocationContext == null) {
                return null;
            }
            Object object = invocationContext.getInvocationContextObject("operationID");
            return object;
        }
    }
}

