/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.commons.vmomi;

import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vise.util.logging.LogUtil;
import com.vmware.vise.vim.commons.vmomi.VmomiFutureInvocationCallback;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;

public class VmomiFutureWrapper<T>
implements Future<T> {
    private static final Log _opIdLogger = LogUtil.getOpIdLogger();
    private volatile VmomiFutureInvocationCallback.VmomiFutureInvocationContext<T> _context;
    private final VmomiFutureInvocationCallback<T> _callback;
    private final AtomicBoolean _alreadyInvokedCallback = new AtomicBoolean(false);

    public VmomiFutureWrapper(@Nonnull Future<T> future, @Nonnull ManagedObject managedObject, @Nonnull Method method, @Nullable Object[] objectArray, @Nullable VmomiFutureInvocationCallback<T> vmomiFutureInvocationCallback) {
        this._context = new VmomiFutureInvocationCallback.VmomiFutureInvocationContext<T>(future, managedObject, method, objectArray);
        this._callback = vmomiFutureInvocationCallback;
    }

    private void invokeCallback() {
        if (this._callback == null) {
            return;
        }
        boolean bl = this._alreadyInvokedCallback.compareAndSet(false, true);
        if (bl) {
            VmomiFutureInvocationCallback.VmomiFutureInvocationContext<T> vmomiFutureInvocationContext = this._callback.invocationDone(this._context);
            this._context = vmomiFutureInvocationContext;
        }
    }

    public boolean cancel(boolean bl) {
        String string = this.getOpIdFromRequestContext();
        _opIdLogger.warn((Object)("Canceling invocation of method " + this._context.getMethod() + " for opId " + string));
        boolean bl2 = this._context.getFuture().cancel(bl);
        this.invokeCallback();
        return bl2;
    }

    public boolean isCancelled() {
        return this._context.getFuture().isCancelled();
    }

    public boolean isDone() {
        return this._context.getFuture().isDone();
    }

    public T get() throws InterruptedException, ExecutionException {
        return (T)this._context.getFuture().get();
    }

    public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this._context.getFuture().get(l, timeUnit);
    }

    public void set(T t) {
        try {
            this._context.getFuture().set(t);
        }
        finally {
            this.invokeCallback();
        }
    }

    public void set() {
        try {
            this._context.getFuture().set();
        }
        finally {
            this.invokeCallback();
        }
    }

    public void setException(Exception exception) {
        try {
            this._context.getFuture().setException(exception);
        }
        finally {
            this.invokeCallback();
        }
    }

    @Nullable
    private String getOpIdFromRequestContext() {
        Stub stub = (Stub)this._context.getManagedObject();
        RequestContext requestContext = stub._getRequestContext();
        String string = (String)requestContext.get((Object)"operationID");
        return string;
    }
}

