/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.core.io;

import java.util.HashSet;
import java.util.Set;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.util.NumberUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberConverter
implements GenericConverter {
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        Number numberValue = (Number)source;
        if (numberValue == null) {
            return Double.NaN;
        }
        if (numberValue.equals(Double.NaN)) {
            return null;
        }
        if (!sourceType.getType().equals(targetType.getType())) {
            return NumberUtils.convertNumberToTargetClass((Number)numberValue, (Class)targetType.getObjectType());
        }
        return source;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        HashSet<GenericConverter.ConvertiblePair> convertibleTypes = new HashSet<GenericConverter.ConvertiblePair>();
        convertibleTypes.add(new GenericConverter.ConvertiblePair(Number.class, Number.class));
        return convertibleTypes;
    }
}

