/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.security3;

import flex.messaging.MessageException;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.messages.ErrorMessage;
import flex.messaging.messages.Message;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.flex.core.ExceptionTranslator;
import org.springframework.flex.http.AmfHttpMessageConverter;
import org.springframework.flex.security3.SecurityExceptionTranslator;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexAuthenticationEntryPoint
extends Http403ForbiddenEntryPoint {
    private static final Log log = LogFactory.getLog(FlexAuthenticationEntryPoint.class);
    private static final ExceptionTranslator DEFAULT_TRANSLATOR = new SecurityExceptionTranslator();
    private final AmfHttpMessageConverter converter = new AmfHttpMessageConverter();
    private final MediaType amfMediaType = new MediaType("application", "x-amf");
    private Set<ExceptionTranslator> exceptionTranslators;

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        if (CollectionUtils.isEmpty(this.exceptionTranslators)) {
            this.exceptionTranslators = Collections.singleton(DEFAULT_TRANSLATOR);
        }
        ServletServerHttpRequest inputMessage = new ServletServerHttpRequest(request);
        ServletServerHttpResponse outputMessage = new ServletServerHttpResponse(response);
        if (!this.converter.canRead(Object.class, inputMessage.getHeaders().getContentType())) {
            super.commence(request, response, authException);
        }
        ActionMessage deserializedInput = null;
        try {
            deserializedInput = (ActionMessage)this.converter.read(ActionMessage.class, (HttpInputMessage)inputMessage);
        }
        catch (HttpMessageNotReadableException ex) {
            log.info((Object)"Authentication failure detected, but request could not be read as AMF.", (Throwable)ex);
            super.commence(request, response, authException);
            return;
        }
        if (deserializedInput instanceof ActionMessage) {
            for (ExceptionTranslator translator : this.exceptionTranslators) {
                if (!translator.handles(authException.getClass())) continue;
                MessageException result = translator.translate((Throwable)authException);
                ErrorMessage err = result.createErrorMessage();
                MessageBody body = deserializedInput.getBody(0);
                Message amfInputMessage = body.getDataAsMessage();
                err.setCorrelationId(amfInputMessage.getMessageId());
                err.setDestination(amfInputMessage.getDestination());
                err.setClientId(amfInputMessage.getClientId());
                ActionMessage responseMessage = new ActionMessage();
                responseMessage.setVersion(deserializedInput.getVersion());
                MessageBody responseBody = new MessageBody();
                responseMessage.addBody(responseBody);
                responseBody.setData((Object)err);
                responseBody.setTargetURI(body.getResponseURI());
                responseBody.setReplyMethod("/onStatus");
                this.converter.write(responseMessage, this.amfMediaType, (HttpOutputMessage)outputMessage);
                response.flushBuffer();
                return;
            }
        }
        super.commence(request, response, authException);
    }

    public Set<ExceptionTranslator> getExceptionTranslators() {
        return this.exceptionTranslators;
    }

    public void setExceptionTranslators(Set<ExceptionTranslator> exceptionTranslators) {
        this.exceptionTranslators = exceptionTranslators;
    }
}

