/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl;

import com.vmware.opsmgmt.client.commons.util.ManagedObjectTypes;
import com.vmware.opsmgmt.client.event.impl.BaseEventProcessor;
import com.vmware.opsmgmt.client.event.impl.EventsTransformer;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.TaskEvent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.event.ClientEventInfo;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.mixed.ManagedEntityParentLocator;
import com.vmware.vsphere.client.task.TaskSearchHelper;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ClientEventProcessor
extends BaseEventProcessor {
    private final ManagedEntityParentLocator _locator;
    private final DataService _dataService;
    private final TaskSearchHelper _taskSearchHelper;

    public ClientEventProcessor(ManagedEntityParentLocator managedEntityParentLocator, DataService dataService, DataServiceExtensionRegistry dataServiceExtensionRegistry, TaskSearchHelper taskSearchHelper) {
        super(dataServiceExtensionRegistry);
        this._locator = managedEntityParentLocator;
        this._dataService = dataService;
        this._taskSearchHelper = taskSearchHelper;
    }

    @Override
    protected TypeInfo getTypeInfo() {
        TypeInfo typeInfo = new TypeInfo();
        typeInfo.type = BaseEventProcessor.EVENT_TYPE;
        typeInfo.properties = new String[]{"info", "taskInfoName", "contextSensitiveMessage"};
        return typeInfo;
    }

    @Override
    protected List<ResultItem> processEventsResult(Map<ManagedObjectReference, List<Event>> map, List<MethodFault> list, QuerySpec querySpec) {
        ManagedObjectReference managedObjectReference;
        ArrayList<ClientEventInfo> arrayList = new ArrayList<ClientEventInfo>();
        for (Map.Entry<ManagedObjectReference, List<Event>> object2 : map.entrySet()) {
            managedObjectReference = object2.getValue();
            ClientEventInfo[] clientEventInfoArray = new ClientEventInfo[]{};
            try {
                for (ClientEventInfo exception : clientEventInfoArray = EventsTransformer.transformToClientEvents(this._dataService, managedObjectReference.toArray(new Event[managedObjectReference.size()]), object2.getKey().getServerGuid(), this._locator, list)) {
                    arrayList.add(exception);
                }
            }
            catch (Exception exception) {
                list.add(MixedUtil.getMethodFault((Throwable)exception));
            }
        }
        ArrayList arrayList2 = new ArrayList();
        HashSet<String> hashSet = new HashSet<String>();
        for (PropertySpec arrayList3 : querySpec.resourceSpec.propertySpecs) {
            if (!arrayList3.type.equals(EVENT_TYPE)) continue;
            hashSet.addAll(Arrays.asList(arrayList3.propertyNames));
        }
        managedObjectReference = this.getContextObjectFromQuery(querySpec);
        for (ClientEventInfo clientEventInfo : arrayList) {
            Object object;
            ClientEventInfo exception;
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            if (hashSet.contains("info")) {
                object = this.createPropertyValue("info", clientEventInfo);
                arrayList3.add(object);
            }
            if (hashSet.contains("taskInfoName")) {
                object = this.getTaskInfoName(clientEventInfo);
                exception = this.createPropertyValue("taskInfoName", object);
                arrayList3.add(exception);
            }
            if (hashSet.contains("contextSensitiveMessage")) {
                object = this.getContextSensitiveMessage(clientEventInfo, managedObjectReference);
                exception = this.createPropertyValue("contextSensitiveMessage", object);
                arrayList3.add(exception);
            }
            object = new ResultItem();
            object.properties = arrayList3.toArray(new PropertyValue[arrayList3.size()]);
            try {
                object.resourceObject = new URI("TODO:" + clientEventInfo.key + clientEventInfo.serverGuid);
            }
            catch (Exception exception2) {
                list.add(MixedUtil.getMethodFault((Throwable)exception2));
                continue;
            }
            arrayList2.add(object);
        }
        return arrayList2;
    }

    private ManagedObjectReference getContextObjectFromQuery(QuerySpec querySpec) {
        for (PropertySpec propertySpec : querySpec.resourceSpec.propertySpecs) {
            if (!propertySpec.type.equals(EVENT_TYPE)) continue;
            for (ParameterSpec parameterSpec : propertySpec.parameters) {
                if (!parameterSpec.propertyName.equals("contextObject")) continue;
                return (ManagedObjectReference)parameterSpec.parameter;
            }
        }
        return null;
    }

    private String getContextSensitiveMessage(ClientEventInfo clientEventInfo, ManagedObjectReference managedObjectReference) {
        if (managedObjectReference == null) {
            if (clientEventInfo.eventDetail == null) {
                return clientEventInfo.fullFormattedMessage;
            }
            return clientEventInfo.eventDetail.fullFormat;
        }
        String string = "";
        ManagedObjectTypes managedObjectTypes = ManagedObjectTypes.getValueOf((String)managedObjectReference.getType());
        switch (managedObjectTypes) {
            case VIRTUAL_MACHINE: {
                string = clientEventInfo.eventDetail.formatOnVm;
                break;
            }
            case HOST: {
                string = clientEventInfo.eventDetail.formatOnHost;
                break;
            }
            case COMPUTE_RESOURCE: {
                string = clientEventInfo.eventDetail.formatOnComputeResource;
                break;
            }
            case DATACENTER: {
                string = clientEventInfo.eventDetail.formatOnDatacenter;
                break;
            }
            case DATASTORE: {
                string = clientEventInfo.eventDetail.formatOnDatacenter;
                break;
            }
        }
        if (StringUtil.isNullOrEmpty((String)string)) {
            return clientEventInfo.eventDetail.fullFormat;
        }
        return string;
    }

    private String getTaskInfoName(ClientEventInfo clientEventInfo) {
        if (clientEventInfo.isTaskEvent.booleanValue()) {
            TaskEvent taskEvent = (TaskEvent)clientEventInfo.serverEvent;
            if (taskEvent.info != null) {
                return this._taskSearchHelper.getTaskDescription(taskEvent.info);
            }
        }
        return null;
    }

    private PropertyValue createPropertyValue(String string, Object object) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.propertyName = string;
        propertyValue.value = object;
        return propertyValue;
    }
}

