/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl;

import com.vmware.opsmgmt.client.commons.vmomi.CompletionFuture;
import com.vmware.opsmgmt.client.commons.vmomi.FutureCompletionService;
import com.vmware.opsmgmt.client.event.impl.EventFilter;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventFilterSpec;
import com.vmware.vim.binding.vim.event.EventHistoryCollector;
import com.vmware.vim.binding.vim.event.EventManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventProvider {
    private static final String VIRTUAL_CENTER_TYPE = "Folder";
    private static final String VIRTUAL_CENTER_VALUE = "group-d1";
    private static final Log _logger = LogFactory.getLog(EventProvider.class);
    private final EventFilter filter;
    private final List<VcService> services;
    final FutureCompletionService<ManagedObjectReference, ManagedObjectReference> completionCollectorService = new FutureCompletionService();
    final FutureCompletionService<Event[], EventHistoryCollector> completionEventService = new FutureCompletionService();
    private Map<EventHistoryCollector, CollectorState> collectors;

    public EventProvider(List<VcService> list, EventFilter eventFilter) {
        this.filter = eventFilter;
        this.services = list;
    }

    public ConsolidatedEvents collect() {
        this.callServicesAsync();
        return this.handleServicesAsync();
    }

    private void callServicesAsync() {
        CompletionFuture completionFuture = null;
        for (VcService vcService : this.services) {
            ManagedObjectReference managedObjectReference;
            try {
                ServiceInstanceContent serviceInstanceContent = vcService.getServiceInstanceContent();
                completionFuture = this.completionCollectorService.create((Object)serviceInstanceContent.eventManager);
                managedObjectReference = (EventManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceInstanceContent.eventManager);
                EventFilterSpec eventFilterSpec = this.removeVcNameFromUserList(this.filter.eventFilterSpec, vcService);
                managedObjectReference.createCollector(eventFilterSpec, (Future)completionFuture);
            }
            catch (Exception exception) {
                if (completionFuture == null) {
                    managedObjectReference = new ManagedObjectReference();
                    managedObjectReference.setValue(VIRTUAL_CENTER_VALUE);
                    managedObjectReference.setType(VIRTUAL_CENTER_TYPE);
                    managedObjectReference.setServerGuid(vcService.getServiceGuid());
                    completionFuture = this.completionCollectorService.create((Object)managedObjectReference);
                }
                completionFuture.setException(exception);
            }
        }
    }

    private ConsolidatedEvents handleServicesAsync() {
        ConsolidatedEvents consolidatedEvents;
        CompletionFuture completionFuture = null;
        this.collectors = new IdentityHashMap<EventHistoryCollector, CollectorState>();
        HashMap<Object, Exception> hashMap = new HashMap<Object, Exception>();
        while (this.completionCollectorService.hasNext()) {
            try {
                completionFuture = this.completionCollectorService.next();
                consolidatedEvents = (ManagedObjectReference)completionFuture.get();
                EventHistoryCollector eventHistoryCollector = (EventHistoryCollector)ManagedObjectUtil.getManagedObject((ManagedObjectReference)consolidatedEvents);
                this.collectors.put(eventHistoryCollector, new CollectorState(this.filter.count, this.filter.requestedPage));
                this.callCollectorAsync(eventHistoryCollector);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (ExecutionException executionException) {
                hashMap.put(completionFuture.getContext(), (Exception)executionException.getCause());
            }
            catch (Exception exception) {
                _logger.error((Object)exception);
                hashMap.put(completionFuture.getContext(), exception);
            }
        }
        consolidatedEvents = this.handleCollectorAsync();
        consolidatedEvents.errors.putAll(hashMap);
        return new ConsolidatedEvents(consolidatedEvents.events, consolidatedEvents.errors);
    }

    private void callCollectorAsync(EventHistoryCollector eventHistoryCollector) {
        CompletionFuture completionFuture = null;
        try {
            CollectorState collectorState = this.collectors.get(eventHistoryCollector);
            eventHistoryCollector.setLatestPageSize(collectorState.getPageSize());
            completionFuture = this.completionEventService.create((Object)eventHistoryCollector);
            eventHistoryCollector.reset();
            eventHistoryCollector.getLatestPage((Future)completionFuture);
        }
        catch (RuntimeException runtimeException) {
            completionFuture.setException((Exception)runtimeException);
        }
    }

    private ConsolidatedEvents handleCollectorAsync() {
        ConsolidatedEvents consolidatedEvents;
        HashMap<ManagedObjectReference, Exception> hashMap = new HashMap<ManagedObjectReference, Exception>();
        while (this.completionEventService.hasNext()) {
            consolidatedEvents = this.completionEventService.next();
            EventHistoryCollector eventHistoryCollector = (EventHistoryCollector)consolidatedEvents.getContext();
            CollectorState collectorState = this.collectors.get(eventHistoryCollector);
            try {
                Event[] eventArray = (Event[])consolidatedEvents.get();
                boolean bl = collectorState.update(eventArray);
                if (!bl) continue;
                consolidatedEvents = this.completionEventService.create((Object)eventHistoryCollector);
                eventHistoryCollector.readPrev(collectorState.getPageSize(), (Future)consolidatedEvents);
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (ExecutionException executionException) {
                hashMap.put(eventHistoryCollector._getRef(), (Exception)executionException.getCause());
            }
        }
        consolidatedEvents = this.getConsolidatedEvents();
        consolidatedEvents.errors.putAll(hashMap);
        this.releaseCollectors();
        return consolidatedEvents;
    }

    private void releaseCollectors() {
        for (EventHistoryCollector eventHistoryCollector : this.collectors.keySet()) {
            try {
                eventHistoryCollector.remove();
            }
            catch (Exception exception) {
                _logger.error((Object)("Error removing history collector: " + exception.getMessage()));
            }
        }
        this.collectors.clear();
    }

    private ConsolidatedEvents getConsolidatedEvents() {
        HashMap<ManagedObjectReference, List<Event>> hashMap = new HashMap<ManagedObjectReference, List<Event>>();
        HashMap<ManagedObjectReference, Exception> hashMap2 = new HashMap<ManagedObjectReference, Exception>();
        for (Map.Entry<EventHistoryCollector, CollectorState> entry : this.collectors.entrySet()) {
            EventHistoryCollector eventHistoryCollector = entry.getKey();
            CollectorState collectorState = entry.getValue();
            if (!collectorState.getEvents().isEmpty()) {
                hashMap.put(eventHistoryCollector._getRef(), collectorState.getEvents());
            }
            if (collectorState.getException() == null) continue;
            hashMap2.put(eventHistoryCollector._getRef(), collectorState.getException());
        }
        return new ConsolidatedEvents(hashMap, hashMap2);
    }

    private EventFilterSpec removeVcNameFromUserList(EventFilterSpec eventFilterSpec, VcService vcService) {
        EventFilterSpec eventFilterSpec2 = eventFilterSpec;
        if (eventFilterSpec.userName != null && eventFilterSpec.userName.userList != null && eventFilterSpec.userName.userList.length != 0) {
            byte[] byArray = ObjectUtil.toByteArray((Object)eventFilterSpec);
            eventFilterSpec2 = (EventFilterSpec)ObjectUtil.fromByteArray((byte[])byArray);
            String string = VcServiceUtil.getServiceName((String)vcService.getServiceGuid()) + "\\";
            for (int i = 0; i < eventFilterSpec2.userName.userList.length; ++i) {
                String string2 = eventFilterSpec2.userName.userList[i];
                if (!string2.startsWith(string)) continue;
                eventFilterSpec2.userName.userList[i] = string2.substring(string.length());
            }
        }
        return eventFilterSpec2;
    }

    private static class CollectorState {
        private static final int MAX_PAGE_SIZE = 1000;
        private final int maxResults;
        private final int requestedPage;
        private int loadedPages;
        private List<Event> loadedEvents;
        private Exception exception;

        public CollectorState(int n, int n2) {
            if (n == -1 && n2 != 0) {
                throw new IllegalArgumentException("Max number of events requested with a non zero currentPage argument.");
            }
            this.maxResults = n == -1 ? Integer.MAX_VALUE : n;
            this.requestedPage = n2;
            this.loadedPages = 0;
            this.loadedEvents = new ArrayList<Event>();
        }

        public boolean update(Event[] eventArray) {
            if (eventArray == null) {
                return false;
            }
            if (this.requestedPage > this.loadedPages) {
                ++this.loadedPages;
                return true;
            }
            int n = this.getPageSize();
            this.loadedEvents.addAll(Arrays.asList(eventArray));
            if (this.loadedEvents.size() > this.maxResults) {
                this.loadedEvents = this.loadedEvents.subList(0, this.maxResults);
            }
            if (this.loadedEvents.size() == this.maxResults) {
                return false;
            }
            return eventArray.length >= n;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }

        public int getPageSize() {
            int n = this.maxResults - this.loadedEvents.size();
            return Math.min(n, 1000);
        }

        public List<Event> getEvents() {
            return this.loadedEvents;
        }
    }

    static class ConsolidatedEvents {
        final Map<ManagedObjectReference, List<Event>> events;
        final Map<ManagedObjectReference, Exception> errors;

        ConsolidatedEvents(Map<ManagedObjectReference, List<Event>> map, Map<ManagedObjectReference, Exception> map2) {
            this.events = map;
            this.errors = map2;
        }
    }
}

