/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dscluster;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.cluster.Action;
import com.vmware.vim.binding.vim.cluster.Recommendation;
import com.vmware.vim.binding.vim.storageDrs.HbrDiskMigrationAction;
import com.vmware.vim.binding.vim.storageDrs.StorageMigrationAction;
import com.vmware.vim.binding.vim.vm.RelocateSpec;
import com.vmware.vim.binding.vim.vm.device.VirtualDisk;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.drs.RecommendationsService;
import com.vmware.vsphere.client.drs.model.DatastoreMonitorTargetData;
import com.vmware.vsphere.client.drs.model.MonitorTargetData;
import com.vmware.vsphere.client.drs.model.RecommendationData;
import com.vmware.vsphere.client.dscluster.model.SdrsRecommendationListItemData;
import com.vmware.vsphere.client.dscluster.model.SdrsVmTargetData;
import com.vmware.vsphere.client.dscluster.util.ModelPropertyRetrievalUtil;
import com.vmware.vsphere.client.dscluster.util.SdrsActionHistoryUtil;
import com.vmware.vsphere.client.dscluster.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SdrsRecommendationsService {
    private static final Log _logger = LogFactory.getLog(SdrsRecommendationsService.class);
    private static final String STORAGE_MIGRATION_ACTION_ICON = "vx-icon-vmDisk";
    private final QueryBindingService _queryBindingService;
    private final RecommendationsService _recommendationsService;

    public SdrsRecommendationsService(QueryBindingService queryBindingService, RecommendationsService recommendationsService) {
        this._queryBindingService = queryBindingService;
        this._recommendationsService = recommendationsService;
    }

    public SdrsRecommendationListItemData[] getRecommendationListData(Recommendation[] recommendations) throws Exception {
        if (ArrayUtil.isNullOrEmpty((Object[])recommendations)) {
            return new SdrsRecommendationListItemData[0];
        }
        ArrayList<SdrsRecommendationListItemData> result = new ArrayList<SdrsRecommendationListItemData>();
        List recommendationsData = this._recommendationsService.getRecommendationListItems(recommendations);
        HashSet<ManagedObjectReference> targets = new HashSet<ManagedObjectReference>();
        for (RecommendationData recommendation : recommendationsData) {
            targets.addAll(Arrays.asList(recommendation.targetObjects));
        }
        Map vmPropsByRef = ModelPropertyRetrievalUtil.getObjectProperties(this._queryBindingService, targets.toArray(new ManagedObjectReference[0]), VirtualMachine.class.getSimpleName(), SdrsVmTargetData.class);
        Map datastorePropsByRef = ModelPropertyRetrievalUtil.getObjectProperties(this._queryBindingService, targets.toArray(new ManagedObjectReference[0]), Datastore.class.getSimpleName(), DatastoreMonitorTargetData.class);
        HashMap<Object, MonitorTargetData> objPropsByRef = new HashMap<Object, MonitorTargetData>();
        objPropsByRef.putAll(vmPropsByRef);
        objPropsByRef.putAll(datastorePropsByRef);
        for (RecommendationData item : recommendationsData) {
            SdrsRecommendationListItemData listItem = this.getSdrsRecommendationListItemData(item, objPropsByRef);
            result.add(listItem);
        }
        return result.toArray(new SdrsRecommendationListItemData[0]);
    }

    private SdrsRecommendationListItemData getSdrsRecommendationListItemData(RecommendationData recommendationData, Map<Object, MonitorTargetData> objPropsByRef) {
        SdrsRecommendationListItemData listItem = new SdrsRecommendationListItemData();
        String formatRecString = this.getRecommendationText(recommendationData.action, objPropsByRef);
        listItem.recommendationData = recommendationData;
        listItem.recommendationText = formatRecString;
        listItem.targets = SdrsActionHistoryUtil.getTargetObjectsData(objPropsByRef, recommendationData.targetObjects);
        listItem.warningText = this.getWarningText(recommendationData.parentRecommendation);
        listItem.image = this.getImage(recommendationData.action);
        this.setUtilizationData(recommendationData.action, listItem);
        return listItem;
    }

    private String getRecommendationText(Action action, Map<Object, MonitorTargetData> objPropsByRef) {
        String actionText = null;
        if (action instanceof StorageMigrationAction) {
            StorageMigrationAction storageMigrationAction = (StorageMigrationAction)action;
            String vmDiskNames = this.getVmDisksFromAction(storageMigrationAction, objPropsByRef);
            if (StringUtil.isNullOrEmpty((String)vmDiskNames)) {
                actionText = Util.getLocalizedString("sdrs.recommendationList.migrateStorageWithNoVmDisks", new String[0]);
            } else {
                actionText = Util.getLocalizedString("sdrs.recommendationList.migrateStorageWithVmDisks", vmDiskNames);
                actionText = actionText + Util.getLocalizedString("sdrs.recommendationList.migrateStorageWithVmDisksFormat", new String[0]);
            }
        } else if (action instanceof HbrDiskMigrationAction) {
            HbrDiskMigrationAction hbrDiskMigrationAction = (HbrDiskMigrationAction)action;
            int numOfReplicaDisks = hbrDiskMigrationAction.diskIds.length;
            String vmName = hbrDiskMigrationAction.collectionName;
            actionText = numOfReplicaDisks > 1 ? Util.getLocalizedString("sdrs.recommendationList.migrateHbrReplicaDiskPlural", Integer.toString(numOfReplicaDisks), vmName) : Util.getLocalizedString("sdrs.recommendationList.migrateHbrReplicaDisk", Integer.toString(numOfReplicaDisks), vmName);
        } else {
            _logger.warn((Object)("Unknown SDRS recommendation action found - " + action));
        }
        return actionText;
    }

    private String getVmDisksFromAction(StorageMigrationAction action, Map<Object, MonitorTargetData> objDetailsByRef) {
        if (action.vm == null || action.relocateSpec == null) {
            return null;
        }
        RelocateSpec.DiskLocator[] relocateSpecDisks = action.relocateSpec.disk;
        SdrsVmTargetData vmData = (SdrsVmTargetData)objDetailsByRef.get(action.vm);
        VirtualDisk[] currentVmDisks = vmData.getVirtualDisks();
        String diskNames = "";
        String diskNamesSeparator = Util.getLocalizedString("sdrs.recommendationList.vmVirtualDisksNameSeparator", new String[0]);
        if (relocateSpecDisks != null && currentVmDisks != null) {
            for (RelocateSpec.DiskLocator locator : relocateSpecDisks) {
                for (VirtualDisk disk : currentVmDisks) {
                    if (locator.diskId != disk.key || disk.deviceInfo == null) continue;
                    diskNames = diskNames + disk.deviceInfo.label + diskNamesSeparator;
                }
            }
        }
        return diskNames;
    }

    private String getWarningText(Recommendation recommendation) {
        String warningText = null;
        if (recommendation.warningText != null) {
            warningText = recommendation.warningDetails != null && recommendation.warningDetails.getMessage() != null ? recommendation.warningDetails.getMessage() : recommendation.warningText;
        }
        return warningText;
    }

    private String getImage(Action action) {
        if (action instanceof StorageMigrationAction) {
            return STORAGE_MIGRATION_ACTION_ICON;
        }
        return null;
    }

    private void setUtilizationData(Action action, SdrsRecommendationListItemData item) {
        if (action instanceof StorageMigrationAction) {
            StorageMigrationAction sdrsAction = (StorageMigrationAction)action;
            item.spaceUtilSrcBefore = sdrsAction.spaceUtilSrcBefore.floatValue();
            item.spaceUtilSrcAfter = sdrsAction.spaceUtilSrcAfter.floatValue();
            item.spaceUtilDstBefore = sdrsAction.spaceUtilDstBefore.floatValue();
            item.spaceUtilDstAfter = sdrsAction.spaceUtilDstAfter.floatValue();
            item.ioLatencySrcBefore = sdrsAction.ioLatencySrcBefore.floatValue();
            item.ioLatencyDstBefore = sdrsAction.ioLatencyDstBefore.floatValue();
        } else if (action instanceof HbrDiskMigrationAction) {
            HbrDiskMigrationAction sdrsAction = (HbrDiskMigrationAction)action;
            item.spaceUtilSrcBefore = sdrsAction.spaceUtilSrcBefore.floatValue();
            item.spaceUtilSrcAfter = sdrsAction.spaceUtilSrcAfter.floatValue();
            item.spaceUtilDstBefore = sdrsAction.spaceUtilDstBefore.floatValue();
            item.spaceUtilDstAfter = sdrsAction.spaceUtilDstAfter.floatValue();
            item.ioLatencySrcBefore = sdrsAction.ioLatencySrcBefore.floatValue();
            item.ioLatencyDstBefore = sdrsAction.ioLatencyDstBefore.floatValue();
        }
    }
}

