/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dscluster.util;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.cluster.DrsFaults;
import com.vmware.vim.binding.vim.fault.CannotAccessNetwork;
import com.vmware.vim.binding.vim.fault.CannotPlaceWithoutPrerequisiteMoves;
import com.vmware.vim.binding.vim.fault.FaultToleranceAntiAffinityViolated;
import com.vmware.vim.binding.vim.fault.FaultTolerancePrimaryPowerOnNotAttempted;
import com.vmware.vim.binding.vim.fault.InsufficientStorageSpace;
import com.vmware.vim.binding.vim.fault.InvalidDatastoreState;
import com.vmware.vim.binding.vim.fault.NoCompatibleDatastore;
import com.vmware.vim.binding.vim.fault.NoCompatibleHost;
import com.vmware.vim.binding.vim.fault.NoConnectedDatastore;
import com.vmware.vim.binding.vim.fault.NoDiskSpace;
import com.vmware.vim.binding.vim.fault.RuleViolation;
import com.vmware.vim.binding.vim.fault.StorageDrsCannotMoveDiskInMultiWriterMode;
import com.vmware.vim.binding.vim.fault.StorageDrsCannotMoveFTVm;
import com.vmware.vim.binding.vim.fault.StorageDrsCannotMoveIndependentDisk;
import com.vmware.vim.binding.vim.fault.StorageDrsCannotMoveManuallyPlacedSwapFile;
import com.vmware.vim.binding.vim.fault.StorageDrsCannotMoveManuallyPlacedVm;
import com.vmware.vim.binding.vim.fault.StorageDrsCannotMoveSharedDisk;
import com.vmware.vim.binding.vim.fault.StorageDrsCannotMoveTemplate;
import com.vmware.vim.binding.vim.fault.StorageDrsCannotMoveVmInUserFolder;
import com.vmware.vim.binding.vim.fault.StorageDrsCannotMoveVmWithMountedCDROM;
import com.vmware.vim.binding.vim.fault.StorageDrsCannotMoveVmWithNoFilesInLayout;
import com.vmware.vim.binding.vim.fault.StorageDrsIolbDisabledInternally;
import com.vmware.vim.binding.vim.fault.StorageDrsUnableToMoveFiles;
import com.vmware.vim.binding.vim.fault.VmFaultToleranceTooManyVMsOnHost;
import com.vmware.vim.binding.vim.fault.WillLoseHAProtection;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.drs.model.DatastoreNameData;
import com.vmware.vsphere.client.drs.model.DrsFaultDetailItem;
import com.vmware.vsphere.client.drs.model.DrsFaultListItem;
import com.vmware.vsphere.client.drs.model.PreventedRecommendation;
import com.vmware.vsphere.client.drs.model.TargetNameData;
import com.vmware.vsphere.client.drs.model.VmMonitorTargetData;
import com.vmware.vsphere.client.drs.util.FaultsLocalizationUtil;
import com.vmware.vsphere.client.dscluster.model.SdrsFaultVmData;
import com.vmware.vsphere.client.dscluster.util.ModelPropertyRetrievalUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SdrsFaultsUtil {
    private static final int VM_DISK_RESERVED_IDS_MAX_THRESHOLD = 1000000;
    private static final String DRS_FAULT_HELP_ID_PREFIX = "com.vmware.vsphere.troubleshooting.doc.";
    private static final String ICON_VM_DISK = "vx-icon-vmDisk";

    public static void getFaultTargetEntities(DrsFaults[] sdrsFaultsArray, Set<ManagedObjectReference> faultsByVmTargets, Set<ManagedObjectReference> faultsByVmDiskTargets) {
        for (DrsFaults sdrsFault : sdrsFaultsArray) {
            if (sdrsFault == null) continue;
            for (DrsFaults.FaultsByVm vmFault : sdrsFault.getFaultsByVm()) {
                ManagedObjectReference vmRef = vmFault.getVm();
                if (vmRef == null) continue;
                if (vmFault instanceof DrsFaults.FaultsByVirtualDisk && SdrsFaultsUtil.isFaultByVirtualDisk((DrsFaults.FaultsByVirtualDisk)vmFault)) {
                    faultsByVmDiskTargets.add(vmRef);
                    continue;
                }
                faultsByVmTargets.add(vmRef);
            }
        }
    }

    public static DrsFaultListItem[] getFaultListData(DrsFaults[] sdrsFaultsArray, QueryBindingService queryBindingService) {
        ArrayList<DrsFaultListItem> drsFaultItems = new ArrayList<DrsFaultListItem>();
        if (!ArrayUtil.isNullOrEmpty((Object[])sdrsFaultsArray)) {
            HashSet<ManagedObjectReference> faultsByVmTargets = new HashSet<ManagedObjectReference>();
            HashSet<ManagedObjectReference> faultsByVmDiskTargets = new HashSet<ManagedObjectReference>();
            SdrsFaultsUtil.getFaultTargetEntities(sdrsFaultsArray, faultsByVmTargets, faultsByVmDiskTargets);
            Map<Object, VmMonitorTargetData> byVmFaultsTargetData = ModelPropertyRetrievalUtil.getObjectProperties(queryBindingService, faultsByVmTargets.toArray(new ManagedObjectReference[0]), VirtualMachine.class.getSimpleName(), VmMonitorTargetData.class);
            Map<Object, SdrsFaultVmData> byVmDiskFaultsTargetData = ModelPropertyRetrievalUtil.getObjectProperties(queryBindingService, faultsByVmDiskTargets.toArray(new ManagedObjectReference[0]), VirtualMachine.class.getSimpleName(), SdrsFaultVmData.class);
            for (DrsFaults sdrsFault : sdrsFaultsArray) {
                if (sdrsFault == null) continue;
                DrsFaultListItem faultListItem = SdrsFaultsUtil.buildFaultListItem(sdrsFault, byVmFaultsTargetData, byVmDiskFaultsTargetData);
                drsFaultItems.add(faultListItem);
            }
        }
        return drsFaultItems.toArray(new DrsFaultListItem[drsFaultItems.size()]);
    }

    private static DrsFaultListItem buildFaultListItem(DrsFaults sdrsFault, Map<Object, VmMonitorTargetData> byVmFaultsTargetData, Map<Object, SdrsFaultVmData> byVmDiskFaultsTargetData) {
        DatastoreNameData datastoreData;
        SdrsFaultVmData vmData;
        DrsFaults.FaultsByVirtualDisk firstFault;
        DrsFaultListItem faultListItem = new DrsFaultListItem();
        faultListItem.setReason(sdrsFault.getReason());
        if (sdrsFault.getFaultsByVm() != null && sdrsFault.getFaultsByVm().length > 0 && sdrsFault.getFaultsByVm()[0] instanceof DrsFaults.FaultsByVirtualDisk && SdrsFaultsUtil.isFaultByVirtualDisk(firstFault = (DrsFaults.FaultsByVirtualDisk)sdrsFault.getFaultsByVm()[0]) && (vmData = byVmDiskFaultsTargetData.get(firstFault.getVm())) != null && (datastoreData = vmData.getVmdkDatastoreData(firstFault.getDisk().getDiskId())) != null) {
            faultListItem.setTarget((TargetNameData)datastoreData);
        }
        faultListItem.setDetails(SdrsFaultsUtil.buildFaultDetailsList(sdrsFault, byVmFaultsTargetData, byVmDiskFaultsTargetData));
        return faultListItem;
    }

    private static List<DrsFaultDetailItem> buildFaultDetailsList(DrsFaults fault, Map<Object, VmMonitorTargetData> byVmFaultsTargetData, Map<Object, SdrsFaultVmData> byVmDiskFaultsTargetData) {
        ArrayList<DrsFaultDetailItem> faultDetailItems = new ArrayList<DrsFaultDetailItem>();
        for (DrsFaults.FaultsByVm vmFault : fault.getFaultsByVm()) {
            if (ArrayUtil.isNullOrEmpty((Object[])vmFault.getFault()) || !(vmFault instanceof DrsFaults.FaultsByVirtualDisk)) continue;
            DrsFaults.FaultsByVirtualDisk vmDiskFault = (DrsFaults.FaultsByVirtualDisk)vmFault;
            Integer diskId = null;
            if (SdrsFaultsUtil.isFaultByVirtualDisk(vmDiskFault)) {
                diskId = vmDiskFault.getDisk().getDiskId();
            }
            for (Exception methodFault : vmDiskFault.getFault()) {
                DrsFaultDetailItem faultDetailItem = SdrsFaultsUtil.createDrsFaultDetailItem(diskId, vmFault.getVm(), methodFault, byVmFaultsTargetData, byVmDiskFaultsTargetData);
                faultDetailItems.add(faultDetailItem);
            }
        }
        return faultDetailItems;
    }

    private static DrsFaultDetailItem createDrsFaultDetailItem(Integer diskId, ManagedObjectReference vm, Exception methodFault, Map<Object, VmMonitorTargetData> byVmFaultsTargetData, Map<Object, SdrsFaultVmData> byVmDiskFaultsTargetData) {
        DrsFaultDetailItem detailsItem = new DrsFaultDetailItem();
        detailsItem.setHelpId(SdrsFaultsUtil.getDrsFaultHelpExtensionId(methodFault));
        String faultDetailMessage = FaultsLocalizationUtil.getDrsFaultMessage((Exception)methodFault);
        detailsItem.setFaultDetailMessage(faultDetailMessage);
        PreventedRecommendation preventedRecommendation = new PreventedRecommendation();
        if (diskId != null) {
            String vmdkName = null;
            SdrsFaultVmData vmData = byVmDiskFaultsTargetData.get(vm);
            if (vmData != null) {
                vmdkName = vmData.getVmdkName(diskId);
                DatastoreNameData datastoreData = vmData.getVmdkDatastoreData(diskId);
                preventedRecommendation.setTargetVm((TargetNameData)vmData);
                preventedRecommendation.setTargetVmds((TargetNameData)datastoreData);
                preventedRecommendation.setTargetVmdk(vmdkName);
            }
            detailsItem.setPreventedRecommendationIcon(ICON_VM_DISK);
        } else if (vm != null) {
            VmMonitorTargetData vmData = byVmFaultsTargetData.get(vm);
            preventedRecommendation.setTargetVm((TargetNameData)vmData);
            detailsItem.setPreventedRecommendationIcon(vmData.getPrimaryIconId());
        }
        detailsItem.setPreventedRecommendation(preventedRecommendation);
        return detailsItem;
    }

    private static String getDrsFaultHelpExtensionId(Exception fault) {
        if (fault instanceof RuleViolation) {
            return "IDH_TSVM_AFFINITY";
        }
        String helpId = fault instanceof NoCompatibleHost || fault instanceof NoCompatibleDatastore || fault instanceof NoConnectedDatastore ? "vc_301" : (fault instanceof StorageDrsCannotMoveTemplate || fault instanceof StorageDrsCannotMoveFTVm || fault instanceof StorageDrsCannotMoveDiskInMultiWriterMode || fault instanceof StorageDrsCannotMoveManuallyPlacedSwapFile || fault instanceof StorageDrsCannotMoveVmInUserFolder || fault instanceof StorageDrsCannotMoveVmWithMountedCDROM || fault instanceof StorageDrsCannotMoveVmWithNoFilesInLayout || fault instanceof StorageDrsCannotMoveIndependentDisk || fault instanceof StorageDrsCannotMoveSharedDisk || fault instanceof StorageDrsCannotMoveManuallyPlacedVm || fault instanceof CannotPlaceWithoutPrerequisiteMoves || fault instanceof StorageDrsUnableToMoveFiles || fault instanceof WillLoseHAProtection ? "vc_302" : (fault instanceof InsufficientStorageSpace ? "vc_303" : (fault instanceof NoDiskSpace || fault instanceof InvalidDatastoreState || fault instanceof CannotAccessNetwork || fault instanceof StorageDrsIolbDisabledInternally ? "vc_304" : (fault instanceof FaultTolerancePrimaryPowerOnNotAttempted || fault instanceof VmFaultToleranceTooManyVMsOnHost || fault instanceof FaultToleranceAntiAffinityViolated ? "vc_305" : "vc_304"))));
        return helpId;
    }

    public static boolean isFaultByVirtualDisk(DrsFaults.FaultsByVirtualDisk vmFault) {
        return vmFault.disk != null && vmFault.disk.diskId > 0 && vmFault.disk.diskId < 1000000;
    }
}

