/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.impl.formatters;

import com.vmware.vim.binding.pbm.capability.types.TimeSpan;
import com.vmware.vim.binding.pbm.capability.types.TimeUnitEnum;
import com.vmware.vsphere.client.spbm.impl.formatters.FormatterUtil;
import com.vmware.vsphere.client.spbm.util.PbmUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TimeSpanUtil {
    private static final Log _logger = LogFactory.getLog(TimeSpanUtil.class);

    public static String timeSpanUnitToString(String unit) {
        if (TimeUnitEnum.SECONDS.toString().equals(unit)) {
            return PbmUtil.getLocalizedString("timeSpanUnit.seconds", new String[0]);
        }
        if (TimeUnitEnum.MINUTES.toString().equals(unit)) {
            return PbmUtil.getLocalizedString("timeSpanUnit.minutes", new String[0]);
        }
        if (TimeUnitEnum.HOURS.toString().equals(unit)) {
            return PbmUtil.getLocalizedString("timeSpanUnit.hours", new String[0]);
        }
        if (TimeUnitEnum.DAYS.toString().equals(unit)) {
            return PbmUtil.getLocalizedString("timeSpanUnit.days", new String[0]);
        }
        if (TimeUnitEnum.WEEKS.toString().equals(unit)) {
            return PbmUtil.getLocalizedString("timeSpanUnit.weeks", new String[0]);
        }
        if (TimeUnitEnum.MONTHS.toString().equals(unit)) {
            return PbmUtil.getLocalizedString("timeSpanUnit.months", new String[0]);
        }
        if (TimeUnitEnum.YEARS.toString().equals(unit)) {
            return PbmUtil.getLocalizedString("timeSpanUnit.years", new String[0]);
        }
        _logger.error((Object)("Unsupported TimeSpanUnit: " + unit));
        return "";
    }

    public static String timeSpanToString(TimeSpan timeSpan) {
        if (timeSpan == null) {
            return "";
        }
        return PbmUtil.getLocalizedString("timeSpan.format", FormatterUtil.formatNumber(timeSpan.value), TimeSpanUtil.timeSpanUnitToString(timeSpan.unit));
    }
}

