/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.impl.formatters;

import com.vmware.vim.binding.pbm.capability.CapabilityInstance;
import com.vmware.vim.binding.pbm.capability.CapabilityMetadata;
import com.vmware.vsphere.client.spbm.data.NamespaceCapabilityMetadata;
import com.vmware.vsphere.client.spbm.data.profile.content.PropertyData;
import com.vmware.vsphere.client.spbm.util.PbmUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class VsanCapabilitiesFormatter {
    public static final String VSAN_NAMESPACE = "VSAN";
    public static final int VMWARE_VSAN_CACHE_RESERVATION_SCALE_FACTOR = 10000;
    public static final int VMWARE_VSAN_CACHE_RESERVATION_PRECISION = 4;
    public static final String CACHE_RESERVATION_CAPABILITY = "cacheReservation";
    private static final String SUBFAILURES_TO_TOLERATE_CAPABILITY = "subFailuresToTolerate";
    private static final String LOCALITY_CAPABILITY = "locality";
    private static final String REPLICA_PREFERENCE_CAPABILITY = "replicaPreference";
    private static final String CHECKSUM_DISABLED_CAPABILITY = "checksumDisabled";
    private static final String IOPS_LIMIT_CAPABILITY = "iopsLimit";
    private static final String PRIMARY_TO_TOLERATE_CAPABILITY = "hostFailuresToTolerate";
    private static final String STRIPE_WIDTH_CAPABILITY = "stripeWidth";
    private static final String OBJECT_SPACE_RESERVATION_CAPABILITY = "proportionalCapacity";
    private static final String FORCE_PROVISIONING_CAPABILITY = "forceProvisioning";
    private static final String LOCALITY_NONE = "None";
    private static final String LOCALITY_PRIMARY = "Preferred Fault Domain";
    private static final String LOCALITY_SECONDARY = "Secondary Fault Domain";
    private static final String RAID1 = "RAID-1 (Mirroring) - Performance";
    private static final String RAID5 = "RAID-5/6 (Erasure Coding) - Capacity";

    public static boolean isVsanNamespace(String namespace) {
        return VSAN_NAMESPACE.equals(namespace);
    }

    public static boolean hasMissingMetadata(List<CapabilityInstance> capabilityInstances, Map<String, NamespaceCapabilityMetadata> namespaceMetadata) {
        if (capabilityInstances == null || capabilityInstances.size() == 0) {
            return false;
        }
        if (namespaceMetadata == null || namespaceMetadata.size() == 0) {
            return true;
        }
        for (CapabilityInstance capInstance : capabilityInstances) {
            if (VsanCapabilitiesFormatter.containsCapability(namespaceMetadata, capInstance.id.id, capInstance.id.namespace)) continue;
            return true;
        }
        return false;
    }

    static boolean containsCapability(Map<String, NamespaceCapabilityMetadata> namespaceMetadata, String capability, String namespace) {
        if (namespaceMetadata == null || namespaceMetadata.size() == 0) {
            return false;
        }
        NamespaceCapabilityMetadata vsanCapabilityMetadata = namespaceMetadata.get(namespace);
        if (vsanCapabilityMetadata == null) {
            return false;
        }
        for (CapabilityMetadata capabilityMetadata : vsanCapabilityMetadata.capabilityMetadata) {
            if (!capabilityMetadata.id.id.equals(capability)) continue;
            return true;
        }
        return false;
    }

    static boolean containsVsanCapability(Map<String, NamespaceCapabilityMetadata> namespaceMetadata, String capability) {
        return VsanCapabilitiesFormatter.containsCapability(namespaceMetadata, capability, VSAN_NAMESPACE);
    }

    public static List<PropertyData> getVsanRuleProperties(List<CapabilityInstance> capabilityInstances, Map<String, NamespaceCapabilityMetadata> namespaceMetadata) {
        VsanCapabilitiesData vsanCapabilitiesData = VsanCapabilitiesFormatter.getCapabilityDataFromRuleSet(capabilityInstances, namespaceMetadata);
        ArrayList<PropertyData> result = new ArrayList<PropertyData>();
        if (vsanCapabilitiesData == null) {
            return result;
        }
        result.add(VsanCapabilitiesFormatter.getSiteTolerancePropertyData(vsanCapabilitiesData, namespaceMetadata));
        result.add(VsanCapabilitiesFormatter.getFailuresToToleratePropertyData(vsanCapabilitiesData, namespaceMetadata));
        result.add(PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.placement.diskStripes", new String[0]), Integer.toString(vsanCapabilitiesData.diskStripes)));
        if (VsanCapabilitiesFormatter.containsVsanCapability(namespaceMetadata, IOPS_LIMIT_CAPABILITY)) {
            result.add(PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.placement.iopsLimit", new String[0]), Integer.toString(vsanCapabilitiesData.iopsLimit)));
        }
        result.add(VsanCapabilitiesFormatter.getObjectSpaceReservationPropertyData(vsanCapabilitiesData));
        result.add(VsanCapabilitiesFormatter.getReadCacheReservationPropertyData(vsanCapabilitiesData));
        if (VsanCapabilitiesFormatter.containsVsanCapability(namespaceMetadata, CHECKSUM_DISABLED_CAPABILITY)) {
            result.add(PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.placement.disableObjectChecksum", new String[0]), vsanCapabilitiesData.checksumDisabled ? PbmUtil.getLocalizedString("vsan.yes", new String[0]) : PbmUtil.getLocalizedString("vsan.no", new String[0])));
        }
        result.add(PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.placement.forceProvisioning", new String[0]), vsanCapabilitiesData.forceProvisioning ? PbmUtil.getLocalizedString("vsan.yes", new String[0]) : PbmUtil.getLocalizedString("vsan.no", new String[0])));
        return result;
    }

    static VsanCapabilitiesData getDefaultValuesCapabilityData(Map<String, NamespaceCapabilityMetadata> namespaceMetadata) {
        if (namespaceMetadata == null) {
            return null;
        }
        NamespaceCapabilityMetadata vsanCapabilityMetadata = namespaceMetadata.get(VSAN_NAMESPACE);
        if (vsanCapabilityMetadata == null) {
            return null;
        }
        VsanCapabilitiesData defaultCapabilitiesData = new VsanCapabilitiesData();
        block24: for (CapabilityMetadata capability : vsanCapabilityMetadata.capabilityMetadata) {
            Object defaultValue = capability.propertyMetadata[0].defaultValue;
            switch (capability.id.id) {
                case "hostFailuresToTolerate": {
                    defaultCapabilitiesData.primaryFtt = (Integer)defaultValue;
                    continue block24;
                }
                case "subFailuresToTolerate": {
                    defaultCapabilitiesData.secondaryFtt = (Integer)defaultValue;
                    continue block24;
                }
                case "locality": {
                    defaultCapabilitiesData.locality = (String)defaultValue;
                    continue block24;
                }
                case "replicaPreference": {
                    defaultCapabilitiesData.replicaPreference = (String)defaultValue;
                    continue block24;
                }
                case "stripeWidth": {
                    defaultCapabilitiesData.diskStripes = (Integer)defaultValue;
                    continue block24;
                }
                case "cacheReservation": {
                    defaultCapabilitiesData.readCacheReservation = (Integer)defaultValue;
                    continue block24;
                }
                case "checksumDisabled": {
                    defaultCapabilitiesData.checksumDisabled = (Boolean)defaultValue;
                    continue block24;
                }
                case "iopsLimit": {
                    defaultCapabilitiesData.iopsLimit = (Integer)defaultValue;
                    continue block24;
                }
                case "proportionalCapacity": {
                    defaultCapabilitiesData.objectSpaceReservation = (Integer)defaultValue;
                    continue block24;
                }
                case "forceProvisioning": {
                    defaultCapabilitiesData.forceProvisioning = (Boolean)defaultValue;
                }
            }
        }
        return defaultCapabilitiesData;
    }

    static VsanCapabilitiesData getCapabilityDataFromRuleSet(List<CapabilityInstance> vSanCapabilities, Map<String, NamespaceCapabilityMetadata> namespaceMetadata) {
        VsanCapabilitiesData defaultCapabilites = VsanCapabilitiesFormatter.getDefaultValuesCapabilityData(namespaceMetadata);
        if (defaultCapabilites == null) {
            return null;
        }
        if (vSanCapabilities == null) {
            return defaultCapabilites;
        }
        boolean isStretchedCluster = false;
        for (CapabilityInstance item : vSanCapabilities) {
            if (!item.id.id.equals(SUBFAILURES_TO_TOLERATE_CAPABILITY)) continue;
            isStretchedCluster = true;
            break;
        }
        return new VsanCapabilitiesData(isStretchedCluster, VsanCapabilitiesFormatter.getCapabilityValue(vSanCapabilities, PRIMARY_TO_TOLERATE_CAPABILITY, defaultCapabilites.primaryFtt), VsanCapabilitiesFormatter.getCapabilityValue(vSanCapabilities, SUBFAILURES_TO_TOLERATE_CAPABILITY, defaultCapabilites.secondaryFtt), VsanCapabilitiesFormatter.getCapabilityValue(vSanCapabilities, LOCALITY_CAPABILITY, defaultCapabilites.locality), VsanCapabilitiesFormatter.getCapabilityValue(vSanCapabilities, REPLICA_PREFERENCE_CAPABILITY, defaultCapabilites.replicaPreference), VsanCapabilitiesFormatter.getCapabilityValue(vSanCapabilities, STRIPE_WIDTH_CAPABILITY, defaultCapabilites.diskStripes), VsanCapabilitiesFormatter.getCapabilityValue(vSanCapabilities, IOPS_LIMIT_CAPABILITY, defaultCapabilites.iopsLimit), VsanCapabilitiesFormatter.getCapabilityValue(vSanCapabilities, CHECKSUM_DISABLED_CAPABILITY, defaultCapabilites.checksumDisabled), VsanCapabilitiesFormatter.getCapabilityValue(vSanCapabilities, CACHE_RESERVATION_CAPABILITY, defaultCapabilites.readCacheReservation), VsanCapabilitiesFormatter.getCapabilityValue(vSanCapabilities, OBJECT_SPACE_RESERVATION_CAPABILITY, defaultCapabilites.objectSpaceReservation), VsanCapabilitiesFormatter.getCapabilityValue(vSanCapabilities, FORCE_PROVISIONING_CAPABILITY, defaultCapabilites.forceProvisioning));
    }

    static PropertyData getSiteTolerancePropertyData(VsanCapabilitiesData vsanCapabilitiesData, Map<String, NamespaceCapabilityMetadata> namespaceMetadata) {
        String stTolerance = PbmUtil.getLocalizedString("vsan.policy.siteTolerance.none", new String[0]);
        if (vsanCapabilitiesData.isStretchedCluster && VsanCapabilitiesFormatter.containsVsanCapability(namespaceMetadata, SUBFAILURES_TO_TOLERATE_CAPABILITY)) {
            if (vsanCapabilitiesData.primaryFtt == 0) {
                if (VsanCapabilitiesFormatter.containsVsanCapability(namespaceMetadata, LOCALITY_CAPABILITY) && !vsanCapabilitiesData.locality.equals(LOCALITY_NONE)) {
                    stTolerance = vsanCapabilitiesData.locality.equals(LOCALITY_PRIMARY) ? PbmUtil.getLocalizedString("vsan.policy.siteTolerance.nonePrimary", new String[0]) : PbmUtil.getLocalizedString("vsan.policy.siteTolerance.noneSecondary", new String[0]);
                }
            } else {
                stTolerance = PbmUtil.getLocalizedString("vsan.policy.siteTolerance.dualSiteMirroring", new String[0]);
            }
        }
        PropertyData propertyData = PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.placement.siteDisasterTolerance", new String[0]), stTolerance);
        return propertyData;
    }

    static PropertyData getReadCacheReservationPropertyData(VsanCapabilitiesData vsanCapabilitiesData) {
        BigDecimal rawValue = BigDecimal.valueOf(vsanCapabilitiesData.readCacheReservation);
        BigDecimal percentValue = rawValue.divide(BigDecimal.valueOf(10000L), 4, RoundingMode.FLOOR);
        String readCacheValue = PbmUtil.getLocalizedString("vsan.policy.readCacheReservation.percentageFormat", Integer.toString(percentValue.intValue()));
        return PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.placement.readCacheReservation", new String[0]), readCacheValue);
    }

    static PropertyData getObjectSpaceReservationPropertyData(VsanCapabilitiesData vsanCapabilitiesData) {
        String objectSpaceReservation;
        switch (vsanCapabilitiesData.objectSpaceReservation) {
            case 0: {
                objectSpaceReservation = PbmUtil.getLocalizedString("vsan.policy.objSpaceReservation.thin", new String[0]);
                break;
            }
            case 100: {
                objectSpaceReservation = PbmUtil.getLocalizedString("vsan.policy.objSpaceReservation.thick", new String[0]);
                break;
            }
            default: {
                objectSpaceReservation = PbmUtil.getLocalizedString("vsan.policy.objSpaceReservation.percentageFormat", Integer.toString(vsanCapabilitiesData.objectSpaceReservation));
            }
        }
        return PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.placement.objectSpaceReservation", new String[0]), objectSpaceReservation);
    }

    static PropertyData getFailuresToToleratePropertyData(VsanCapabilitiesData vsanCapabilitiesData, Map<String, NamespaceCapabilityMetadata> namespaceMetadata) {
        int ftt;
        int n = ftt = vsanCapabilitiesData.isStretchedCluster ? vsanCapabilitiesData.secondaryFtt : vsanCapabilitiesData.primaryFtt;
        String fttValue = ftt == 0 ? PbmUtil.getLocalizedString("vsan.policy.ft.none", new String[0]) : (ftt == 3 ? PbmUtil.getLocalizedString("vsan.policy.ft.threeFailuresMirror", new String[0]) : (VsanCapabilitiesFormatter.containsVsanCapability(namespaceMetadata, LOCALITY_CAPABILITY) && vsanCapabilitiesData.replicaPreference.equals(RAID5) ? (ftt == 1 ? PbmUtil.getLocalizedString("vsan.policy.ft.oneFailureErasureCoding", new String[0]) : PbmUtil.getLocalizedString("vsan.policy.ft.twoFailuresErasureCoding", new String[0])) : (ftt == 1 ? PbmUtil.getLocalizedString("vsan.policy.ft.oneFailureMirror", new String[0]) : PbmUtil.getLocalizedString("vsan.policy.ft.twoFailuresMirror", new String[0]))));
        return PropertyData.newInstance(PbmUtil.getLocalizedString("vsan.sp.placement.failuresToTolerate", new String[0]), fttValue);
    }

    static <T> T getCapabilityValue(List<CapabilityInstance> capabilityInstances, String capability, T defaultValue) {
        for (CapabilityInstance item : capabilityInstances) {
            if (!item.id.id.equals(capability)) continue;
            return (T)item.constraint[0].propertyInstance[0].value;
        }
        return defaultValue;
    }

    static class VsanCapabilitiesData {
        public boolean isStretchedCluster;
        public int primaryFtt;
        public int secondaryFtt;
        public String locality;
        public String replicaPreference;
        public int diskStripes;
        public int iopsLimit;
        public boolean checksumDisabled;
        public int readCacheReservation;
        public int objectSpaceReservation;
        public boolean forceProvisioning;

        public VsanCapabilitiesData() {
        }

        public VsanCapabilitiesData(boolean isStretchedCluster, int primaryFtt, int secondaryFtt, String locality, String replicaPreference, int diskStripes, int iopsLimit, boolean checksumDisabled, int readCacheReservation, int objectSpaceReservation, boolean forceProvisioning) {
            this.isStretchedCluster = isStretchedCluster;
            this.primaryFtt = primaryFtt;
            this.secondaryFtt = secondaryFtt;
            this.locality = locality;
            this.replicaPreference = replicaPreference;
            this.diskStripes = diskStripes;
            this.iopsLimit = iopsLimit;
            this.checksumDisabled = checksumDisabled;
            this.readCacheReservation = readCacheReservation;
            this.objectSpaceReservation = objectSpaceReservation;
            this.forceProvisioning = forceProvisioning;
        }
    }
}

