/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.spbm.util;

import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vcservice.VcServiceConnectionInfo;
import com.vmware.vsphere.client.spbm.LocationLookupException;
import com.vmware.vsphere.client.spbm.PbmService;
import com.vmware.vsphere.client.spbm.PbmServiceFactory;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class PbmSessionUtil {
    private static final String PBM_SERVICE_MAP = "com.vmware.vsphere.client.spbm.util.PBM_SERVICE_MAP";
    private static final String PBM_SYNC_OBJ_KEY = "com.vmware.vsphere.client.spbm.util.PBM_SYNC_OBJ_KEY";

    public static PbmService getService(String serviceGuid, PbmServiceFactory serviceFactory) throws LocationLookupException, ComponentManagerFault {
        return PbmSessionUtil.getService(serviceGuid, null, serviceFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PbmService getService(String serviceGuid, HttpSession session, PbmServiceFactory serviceFactory) throws LocationLookupException, ComponentManagerFault {
        Object syncObject;
        VcService vcService = VimSessionUtil.getService((String)serviceGuid, (HttpSession)session);
        String pbmServiceKey = PbmSessionUtil.getPbmServiceKey(vcService);
        if (pbmServiceKey == null) {
            return null;
        }
        Map<String, PbmService> serviceMap = null;
        Object object = syncObject = SessionUtil.getSyncObject((String)PBM_SYNC_OBJ_KEY, (HttpSession)session);
        synchronized (object) {
            serviceMap = PbmSessionUtil.getPbmServiceMap(session);
            PbmService pbmService = serviceMap.get(pbmServiceKey);
            if (pbmService instanceof PbmService) {
                return pbmService;
            }
        }
        PbmService pbmService = serviceFactory.getService(vcService);
        Object object2 = syncObject;
        synchronized (object2) {
            serviceMap.put(pbmServiceKey, pbmService);
        }
        return pbmService;
    }

    private static String getPbmServiceKey(VcService vcService) {
        if (vcService == null) {
            return null;
        }
        VcServiceConnectionInfo connectionInfo = vcService.getConnectionInfo();
        if (connectionInfo == null) {
            return null;
        }
        return vcService.getServiceGuid() + ":" + connectionInfo.getSessionCookie();
    }

    public static void logoutAllPbmServices(String clientId) {
        Map serviceMap = (Map)SessionUtil.getData((String)PBM_SERVICE_MAP, (String)clientId);
        if (serviceMap == null || serviceMap.isEmpty()) {
            return;
        }
        for (PbmService pbmService : serviceMap.values()) {
            pbmService.logout();
        }
    }

    private static Map<String, PbmService> getPbmServiceMap(HttpSession session) {
        HashMap serviceMap = (HashMap)SessionUtil.getData((String)PBM_SERVICE_MAP);
        if (serviceMap == null) {
            serviceMap = new HashMap();
            SessionUtil.setData((String)PBM_SERVICE_MAP, serviceMap);
        }
        return serviceMap;
    }
}

