/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.websso.client;

import org.apache.commons.lang.Validate;

public final class SignatureAlgorithm
extends Enum<SignatureAlgorithm> {
    public static final /* enum */ SignatureAlgorithm RSA_SHA1 = new SignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1", "SHA1withRSA");
    public static final /* enum */ SignatureAlgorithm RSA_SHA256 = new SignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "SHA256withRSA");
    public static final /* enum */ SignatureAlgorithm ALGO_ID_SIGNATURE_RSA_SHA384 = new SignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384", "SHA384withRSA");
    public static final /* enum */ SignatureAlgorithm RSA_SHA512 = new SignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", "SHA512withRSA");
    private final String algorithmURI;
    private final String algorithmName;
    private static final /* synthetic */ SignatureAlgorithm[] $VALUES;

    public static SignatureAlgorithm[] values() {
        return (SignatureAlgorithm[])$VALUES.clone();
    }

    public static SignatureAlgorithm valueOf(String name) {
        return Enum.valueOf(SignatureAlgorithm.class, name);
    }

    private SignatureAlgorithm(String algorithmURI, String algorithmName) {
        assert (algorithmURI != null);
        assert (algorithmName != null);
        this.algorithmURI = algorithmURI;
        this.algorithmName = algorithmName;
    }

    public String toString() {
        return this.algorithmURI;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public static SignatureAlgorithm getSignatureAlgorithmForURI(String signatureAlgorithmURI) {
        Validate.notEmpty((String)signatureAlgorithmURI);
        SignatureAlgorithm result = null;
        for (SignatureAlgorithm algo : SignatureAlgorithm.values()) {
            if (!algo.toString().equals(signatureAlgorithmURI)) continue;
            result = algo;
            break;
        }
        return result;
    }

    static {
        $VALUES = new SignatureAlgorithm[]{RSA_SHA1, RSA_SHA256, ALGO_ID_SIGNATURE_RSA_SHA384, RSA_SHA512};
    }
}

