/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.websso.client;

import com.vmware.af.VmAfClient;
import com.vmware.identity.cdc.CdcFactory;
import com.vmware.identity.cdc.CdcSession;
import com.vmware.identity.websso.client.WebssoClientException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteAffinity {
    static final Logger logger = LoggerFactory.getLogger(SiteAffinity.class);
    private static final String AFD_SERVER = "localhost";

    public static String getAffinitizedDC() throws WebssoClientException {
        String dc = null;
        try {
            VmAfClient client = null;
            try {
                client = new VmAfClient(AFD_SERVER);
            }
            catch (Exception e) {
                logger.error("Failed to create AFD client.", (Throwable)e);
                throw new WebssoClientException("AFD client fails in getting affinitized DC.");
            }
            dc = client.getDomainControllerEx(null);
            logger.info("getAffinitizedDC: " + dc);
        }
        catch (UnsatisfiedLinkError e) {
            logger.warn("Failed to init VmAfClient, likely due to missing libvmafdclient.so. Message: {}", (Object)e.getMessage());
        }
        catch (NoClassDefFoundError e) {
            logger.warn("Failed to init VmAfClient, likely due to missing vmafd jar. Message: {}", (Object)e.getMessage());
        }
        return dc;
    }

    public static List<String> enumDCEntries() throws WebssoClientException {
        List dcList = null;
        try (CdcSession cdcSession = null;){
            cdcSession = CdcFactory.createCdcSessionViaIPC();
            if (cdcSession == null) {
                logger.error("Failed to create AFD CdcSession via IPC. ");
                throw new WebssoClientException("AFD cdcSession is created null.");
            }
            dcList = cdcSession.enumDCEntries();
            if (dcList == null) {
                logger.error("AFD cdcSession returns null DC list.");
                throw new WebssoClientException("AFD cdcSession returns null DC list.");
            }
        }
        catch (UnsatisfiedLinkError e) {
            logger.info("Failed to init CdcSession, likely due to missing libcdcjni.so.", (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            logger.info("Failed to init CdcSession, likely due to missing vmafd jar.", (Throwable)e);
        }
        return dcList;
    }
}

