/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.identity.websso.client;

import com.vmware.identity.websso.client.SamlUtils;
import com.vmware.identity.websso.client.SharedUtils;
import com.vmware.identity.websso.client.SubjectData;
import com.vmware.identity.websso.client.ValidationResult;
import com.vmware.identity.websso.client.ValidationState;
import com.vmware.identity.websso.client.endpoint.SloListener;
import java.io.ByteArrayOutputStream;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.SessionIndex;
import org.opensaml.xml.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SloRequestValidationState
extends ValidationState {
    private static final Logger logger = LoggerFactory.getLogger(SloRequestValidationState.class);
    private final SloListener controller;
    private LogoutRequest logoutRequest;

    public SloRequestValidationState(HttpServletRequest request, SloListener controller) {
        super(controller.getMetadataSettings());
        this.setRequest(request);
        this.controller = controller;
    }

    @Override
    public void validate() throws Exception {
        logger.info("Validating SLO Request..");
        Validate.notNull((Object)this.getRequest());
        this.DecodeResponse();
        this.logoutRequest = (LogoutRequest)SamlUtils.unmarshallSAMLObj(this.getSamlDom());
        Validate.notNull((Object)this.logoutRequest, (String)"LogoutRequest object");
        this.setMessageID(this.logoutRequest.getID());
        this.setIssuerVal(this.logoutRequest.getIssuer().getValue());
        this.setIssueInstant(this.logoutRequest.getIssueInstant());
        this.setDestination(this.logoutRequest.getDestination());
        NameID nameID = this.logoutRequest.getNameID();
        Validate.notNull((Object)nameID, (String)"nameID");
        this.setMessageData(new SubjectData(nameID.getFormat(), nameID.getValue()));
        List sessionIndexs = this.logoutRequest.getSessionIndexes();
        if (sessionIndexs != null && !sessionIndexs.isEmpty()) {
            this.setSessionIndex(((SessionIndex)sessionIndexs.get(0)).getSessionIndex());
        }
        logger.info("Optional sessionIndex value is: ", (Object)this.getSessionIndex());
        this.validateDestination();
        this.validateSloIssuer(null, this.getIssuerVal());
        logger.info("Successfully validated issuer: ", (Object)this.getIssuerVal());
        String checkAlg = this.getRequest().getParameter("SigAlg");
        X509Certificate cert = SamlUtils.getIDPCertByIssuer(this.controller.getMetadataSettings(), this.getIssuerVal());
        SamlUtils samlUtils = new SamlUtils(cert, null, null, checkAlg, null);
        try {
            samlUtils.validateRequestSignature(this.getRequest(), true);
        }
        catch (Exception error) {
            logger.info("SLO request signature validation failed.", (Throwable)error);
            if (this.getValidationResult().isValid()) {
                this.setValidationResult(new ValidationResult(400, "BadRequest", "Invalid signature."));
            }
            throw error;
        }
        logger.info("SLO request validation succeeded");
    }

    private void DecodeResponse() throws Exception {
        String relayState;
        String samlRequestStr = this.getRequest().getParameter("SAMLRequest");
        logger.trace("Coded SAML Request is " + samlRequestStr);
        String decodedResponseStr = SamlUtils.extractResponse(samlRequestStr);
        Validate.notEmpty((String)decodedResponseStr, (String)"decodedResponseStr");
        this.setSamlDom(SharedUtils.createDOM(decodedResponseStr));
        if (logger.isDebugEnabled()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Element rootE = this.getSamlDom().getDocumentElement();
            rootE.normalize();
            SharedUtils.formattedPrint(rootE, baos);
            decodedResponseStr = baos.toString("UTF-8");
            logger.info("Decoded SAML Request is " + decodedResponseStr);
        }
        if ((relayState = this.getRequest().getParameter("RelayState")) != null) {
            String decodedRelayState = new String(Base64.decode((String)relayState));
            this.setRelayState(relayState);
            logger.info("Decoded Relay State is " + decodedRelayState);
        }
    }
}

